/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.inventory.BasicItemHandler;
import elec332.core.inventory.ContainerNull;
import elec332.core.inventory.DoubleItemHandler;
import elec332.core.util.InventoryHelper;
import elec332.core.util.ItemStackHelper;
import elec332.core.util.NBTBuilder;
import elec332.core.world.WorldHelper;
import elec332.craftingtableiv.CraftingTableIV;
import elec332.craftingtableiv.api.IRecipeHandler;
import elec332.craftingtableiv.handler.RecipeHandler;
import elec332.craftingtableiv.tileentity.TileEntityCraftingTableIV;
import elec332.craftingtableiv.util.FastRecipeList;
import elec332.craftingtableiv.util.WrappedItemHandler;
import elec332.craftingtableiv.util.WrappedRecipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class CraftingHandler {
    private static FastRecipeList recipeList;
    private static List<WrappedRecipe> allRecipes;
    private static List<Class<? extends IRecipe>> erroredClasses;

    public static void rebuildList() {
        CraftingHandler.clearLists();
        Set<IRecipeHandler> recipeHandlers = RecipeHandler.getCompatHandler().getRegistry();
        RegistryNamespaced recipeList = CraftingManager.field_193380_a;
        HashMap entries = Maps.newHashMap();
        TreeMap namedList = Maps.newTreeMap();
        block2: for (IRecipe recipe : recipeList) {
            if (recipe == null || !ItemStackHelper.isStackValid((ItemStack)recipe.func_77571_b()) || RecipeHandler.getCompatHandler().isRecipeDisabled(recipe) || CraftingTableIV.getItemRegistryName(recipe.func_77571_b()) == null || CraftingTableIV.nuggetFilter && CraftingHandler.isNugget(recipe.func_77571_b())) continue;
            String s = CraftingTableIV.getItemIdentifier(recipe.func_77571_b());
            for (String s1 : CraftingTableIV.disabledMods) {
                if (s1.equalsIgnoreCase(s)) continue block2;
            }
            boolean invalid = false;
            for (IRecipeHandler handler : recipeHandlers) {
                if (!handler.canHandleRecipe(recipe)) continue;
                WrappedRecipe wrappedRecipe = null;
                try {
                    wrappedRecipe = CraftingHandler.handleRecipe(recipe, handler);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to handle recipe: " + recipe.getClass().getCanonicalName() + " " + recipe, e);
                }
                if (wrappedRecipe != null) {
                    if (s.contains("minecraft")) {
                        entries.computeIfAbsent("minecraft", k -> Lists.newArrayList()).add(wrappedRecipe);
                        continue block2;
                    }
                    namedList.computeIfAbsent(s, k -> Lists.newArrayList()).add(wrappedRecipe);
                    continue block2;
                }
                if (handler.logHandlerErrors()) {
                    CraftingTableIV.logger.warn("Recipe " + recipe.getClass().getName() + " has invalid ingredients!");
                }
                invalid = true;
            }
            if (!invalid) continue;
            erroredClasses.add(recipe.getClass());
        }
        entries.putAll(namedList);
        for (List wrappedRecipeList : entries.values()) {
            for (WrappedRecipe wrappedRecipe : wrappedRecipeList) {
                CraftingHandler.recipeList.addRecipe(wrappedRecipe);
                allRecipes.add(wrappedRecipe);
            }
        }
        allRecipes = ImmutableList.copyOf(allRecipes);
    }

    private static void clearLists() {
        recipeList = new FastRecipeList();
        allRecipes = Lists.newArrayList();
    }

    @Nullable
    private static WrappedRecipe handleRecipe(IRecipe recipe, IRecipeHandler handler) {
        if (recipe == null || handler == null) {
            return null;
        }
        return WrappedRecipe.of(recipe, handler);
    }

    private static boolean isNugget(ItemStack stack) {
        if (CraftingTableIV.getItemRegistryName(stack).contains("nugget")) {
            return true;
        }
        int[] nArray = OreDictionary.getOreIDs((ItemStack)stack);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            if (!OreDictionary.getOreName((int)i2).contains("nugget")) continue;
            return true;
        }
        return false;
    }

    public static List<WrappedRecipe> getAllRecipes() {
        return allRecipes;
    }

    public static <I extends IItemHandlerModifiable> int canCraft(IWorldAccessibleInventory<I> inventory, WrappedRecipe recipe, @Nullable FastRecipeList list, boolean craft, int max) {
        int limit;
        if (max <= 0) {
            return 0;
        }
        if (max != 1 && max > (limit = CraftingHandler.getMaxStackSize(recipe.getRecipeOutput()))) {
            max = limit;
        }
        ItemStack[] oldContents = inventory.getInventory().getCopyOfContents();
        WrappedItemHandler<BasicItemHandler> inv = WrappedItemHandler.of(new BasicItemHandler(oldContents.length));
        inv.setContents(oldContents);
        int ret = CraftingHandler.maxCraft(inventory, inv, recipe, list, craft, 0, max);
        if (ret > 0 && craft && !CraftingHandler.isClient()) {
            inventory.getInventory().setContents(inv.getCopyOfContents());
        }
        return ret;
    }

    private static <I extends IItemHandlerModifiable> int maxCraft(IWorldAccessibleInventory<I> inventory, WrappedItemHandler wrappedInventory, WrappedRecipe recipe, @Nullable FastRecipeList list, boolean craft, int recursion, int max) {
        int ret = 0;
        int oS = recipe.getOutputSize();
        int times = MathHelper.func_76141_d((float)((float)max / (float)oS));
        for (int i = 0; i < times && CraftingHandler.canCraft(inventory, wrappedInventory, recipe, list, craft, recursion); ++i) {
            ret += oS;
        }
        return ret;
    }

    private static <I extends IItemHandlerModifiable> boolean canCraft(IWorldAccessibleInventory<I> inventory, WrappedItemHandler wrappedInventory, WrappedRecipe recipe, @Nullable FastRecipeList list, boolean craft, int recursion) {
        if (recursion >= CraftingTableIV.recursionDepth || inventory == null || recipe == null) {
            return false;
        }
        int inputSize = recipe.getIngredients().length;
        Object[] usedIngredients = new ItemStack[inputSize];
        Arrays.fill(usedIngredients, ItemStackHelper.NULL_STACK);
        for (int o = 0; o < inputSize; ++o) {
            Ingredient obj = recipe.getIngredients()[o];
            if (obj == null || obj == Ingredient.field_193370_a) continue;
            int i = CraftingHandler.getFirstSlotWithItemStack((IItemHandler)wrappedInventory, obj, recipe);
            if (i >= 0) {
                usedIngredients[o] = wrappedInventory.getStackInSlot(i).func_77946_l();
                CraftingHandler.handleStuff(inventory, wrappedInventory, i, craft);
                continue;
            }
            if (list != null) {
                List<WrappedRecipe> recipes = list.getCraftingRecipe(obj, recipe);
                if (CraftingHandler.canCraftAnyOf(recipes, inventory, wrappedInventory, list, craft, recursion, recipe)) {
                    i = CraftingHandler.getFirstSlotWithItemStack((IItemHandler)wrappedInventory, obj, recipe);
                    if (i < 0) {
                        return false;
                    }
                    usedIngredients[o] = wrappedInventory.getStackInSlot(i).func_77946_l();
                    CraftingHandler.handleStuff(inventory, wrappedInventory, i, craft);
                    continue;
                }
                return false;
            }
            return false;
        }
        ItemStack out = recipe.getRecipeHandler().getCraftingResult(recipe.getRecipe(), CraftingHandler.getInv((ItemStack[])usedIngredients));
        if (out == null || !ItemStackHelper.isStackValid((ItemStack)out)) {
            return false;
        }
        if (!wrappedInventory.addItemToInventory(out, false)) {
            if (recursion != 0) {
                return false;
            }
            inventory.dropStack(out);
        }
        if (craft && CraftingHandler.isClient()) {
            CraftingHandler.sendCraftingMessage(inventory, recipe, (ItemStack[])usedIngredients);
        }
        return true;
    }

    private static InventoryCrafting getInv(ItemStack[] s) {
        InventoryCrafting ret = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = i >= s.length ? ItemStackHelper.NULL_STACK : s[i];
            ret.func_70299_a(i, stack);
        }
        return ret;
    }

    private static int getFirstSlotWithItemStack(IItemHandler inventory, Ingredient stack, WrappedRecipe recipe) {
        IRecipeHandler recipeHandler = recipe.getRecipeHandler();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (!ItemStackHelper.isStackValid((ItemStack)itemStack) || !recipeHandler.isValidIngredientFor(recipe.getRecipe(), stack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    private static boolean canCraftAnyOf(List<WrappedRecipe> recipes, IWorldAccessibleInventory<?> inventory, WrappedItemHandler wrappedInventory, @Nullable FastRecipeList list, boolean craft, int recursion, WrappedRecipe original) {
        for (WrappedRecipe wrappedRecipe : recipes) {
            if (CraftingHandler.isLoopSensitive(original, wrappedRecipe) && (CraftingTableIV.aggressiveLoopCheck || CraftingHandler.isSingleLoop(original, wrappedRecipe))) continue;
            ItemStack[] copy = wrappedInventory.getCopyOfContents();
            if (CraftingHandler.canCraft(inventory, wrappedInventory, wrappedRecipe, list, craft, recursion + 1)) {
                return true;
            }
            wrappedInventory.setContents(copy);
        }
        return false;
    }

    private static boolean isLoopSensitive(WrappedRecipe original, WrappedRecipe wrappedRecipe) {
        return original.sameItems() && wrappedRecipe.sameItems() && wrappedRecipe.oneItem() != original.oneItem();
    }

    private static boolean isSingleLoop(WrappedRecipe original, WrappedRecipe wrappedRecipe) {
        ItemStack stack = null;
        ItemStack out = null;
        if (original.oneItem()) {
            stack = original.getOneItem();
            out = wrappedRecipe.getRecipeOutput();
        } else if (wrappedRecipe.oneItem()) {
            stack = wrappedRecipe.getOneItem();
            out = original.getRecipeOutput();
        }
        return stack != null && out != null && InventoryHelper.areEqualNoSizeNoNBT((ItemStack)stack, (ItemStack)out);
    }

    private static void handleStuff(IWorldAccessibleInventory worldAccessibleInventory, WrappedItemHandler inventory, int slot, boolean craft) {
        ItemStack stack = inventory.getStackInSlot(slot).func_77946_l();
        inventory.extractItem(slot, 1, false);
        if (stack.func_77973_b().hasContainerItem(stack)) {
            ItemStack itemStack = stack.func_77973_b().getContainerItem(stack);
            if (ItemStackHelper.isStackValid((ItemStack)itemStack) && itemStack.func_77984_f() && itemStack.func_77952_i() > itemStack.func_77958_k()) {
                itemStack = null;
            }
            if (itemStack != null && !inventory.addItemToInventory(itemStack, false) && craft) {
                worldAccessibleInventory.dropStack(itemStack);
            }
        }
    }

    private static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    private static int getMaxStackSize(ItemStack stack) {
        return stack.func_77973_b().getItemStackLimit(stack);
    }

    public static IWorldAccessibleInventory<?> forCraftingTableIV(EntityPlayer player, TileEntityCraftingTableIV craftingTableIV) {
        return new CraftingTableIVHandler(player, craftingTableIV, player.func_130014_f_());
    }

    public static void onMessageReceived(IWorldAccessibleInventory<?> inventory, NBTTagCompound recipeTag) {
        List<WrappedRecipe> recipes = recipeList.getCraftingRecipe(ItemStackHelper.loadItemStackFromNBT((NBTTagCompound)recipeTag.func_74775_l("out")));
        NBTTagList list = recipeTag.func_150295_c("ingredients", 10);
        WrappedRecipe wrappedRecipe = null;
        block0: for (WrappedRecipe recipe : recipes) {
            if (list.func_74745_c() != recipe.getIngredients().length) continue;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Ingredient obj = recipe.getIngredients()[i];
                ItemStack stack = ItemStackHelper.loadItemStackFromNBT((NBTTagCompound)list.func_150305_b(i));
                if (!(!ItemStackHelper.isStackValid((ItemStack)stack) ? obj == null || obj == Ingredient.field_193370_a : recipe.getRecipeHandler().isValidIngredientFor(recipe.getRecipe(), obj, stack))) continue block0;
            }
            wrappedRecipe = recipe;
            break;
        }
        if (wrappedRecipe == null) {
            System.out.println("Unable to find recipe.");
            return;
        }
        int i = wrappedRecipe.getOutputSize();
        if (recipeTag.func_74764_b("recipeAmt")) {
            i = recipeTag.func_74771_c("recipeAmt");
        }
        CraftingHandler.canCraft(inventory, wrappedRecipe, null, true, i);
    }

    private static void sendCraftingMessage(IWorldAccessibleInventory inventory, WrappedRecipe recipe, ItemStack[] usedIngredients) {
        NBTTagCompound recipeTag = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        recipe.getRecipe().func_77571_b().func_77955_b(tag);
        recipeTag.func_74782_a("out", (NBTBase)tag);
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : usedIngredients) {
            tag = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(tag);
            }
            list.func_74742_a((NBTBase)tag);
        }
        recipeTag.func_74782_a("ingredients", (NBTBase)list);
        CraftingTableIV.instance.sendCraftingMessage(inventory, recipeTag);
    }

    static {
        erroredClasses = Lists.newArrayList();
    }

    public static final class CraftingTableIVHandler
    implements IWorldAccessibleInventory {
        private WrappedItemHandler<?> inventory;
        private World world;
        private TileEntityCraftingTableIV craftingTableIV;
        private EntityPlayer player;

        public CraftingTableIVHandler() {
        }

        private CraftingTableIVHandler(EntityPlayer player, TileEntityCraftingTableIV craftingTableIV, World world) {
            if (player.func_130014_f_() != world && craftingTableIV.func_145831_w() != world) {
                throw new IllegalArgumentException();
            }
            this.inventory = WrappedItemHandler.of(new DoubleItemHandler((IItemHandlerModifiable)craftingTableIV, (IItemHandlerModifiable)new PlayerMainInvWrapper(player.field_71071_by)));
            this.world = world;
            this.craftingTableIV = craftingTableIV;
            this.player = player;
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("dimID", WorldHelper.getDimID((World)this.world));
            tag.func_74768_a("playerID", this.player.func_145782_y());
            tag.func_74778_a("PlayerUUID", this.player.func_110124_au().toString());
            new NBTBuilder(tag).setBlockPos(this.craftingTableIV.func_174877_v());
        }

        public IWorldAccessibleInventory<?> readFromNBT(NBTTagCompound tag) {
            WorldServer world = DimensionManager.getWorld((int)tag.func_74762_e("dimID"));
            EntityPlayer player = (EntityPlayer)world.func_73045_a(tag.func_74762_e("playerID"));
            if (player == null) {
                CraftingTableIV.logger.error("PlayerEntity with ID: " + tag.func_74762_e("playerID") + " does no longer exist?!?");
                player = world.func_152378_a(UUID.fromString(tag.func_74779_i("PlayerUUID")));
                if (player == null) {
                    return null;
                }
            }
            TileEntityCraftingTableIV craftingTableIV = (TileEntityCraftingTableIV)WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)new NBTBuilder(tag).getBlockPos());
            return new CraftingTableIVHandler(player, craftingTableIV, (World)world);
        }

        public WrappedItemHandler<?> getInventory() {
            return this.inventory;
        }

        @Override
        public void dropStack(@Nonnull ItemStack stack) {
            if (!CraftingHandler.isClient()) {
                WorldHelper.dropStack((World)this.world, (BlockPos)this.craftingTableIV.func_174877_v(), (ItemStack)stack);
            }
        }
    }

    public static interface IWorldAccessibleInventory<I extends IItemHandlerModifiable> {
        public void writeToNBT(NBTTagCompound var1);

        public IWorldAccessibleInventory<I> readFromNBT(NBTTagCompound var1);

        public WrappedItemHandler<I> getInventory();

        public void dropStack(@Nonnull ItemStack var1);
    }
}

