/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.block.IFluidloggableFluid;
import git.jbredwards.fluidlogged_api.api.network.FluidloggedAPINetworkHandler;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidBase;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.message.MessageVaporizeEffects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockFluidClassic
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("getOptimalFlowDirections");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (instructions.getFirst() == insn.getPrevious()) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/world/IBlockAccess", obfuscated ? "func_180495_p" : "getBlockState", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", true));
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(58, 5));
        } else if (this.checkMethod(insn, "isSourceBlock")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 5));
            list.add((AbstractInsnNode)new VarInsnNode(21, 3));
            list.add((AbstractInsnNode)this.genMethodNode("getOptimalFlowDirections", "(Lnet/minecraftforge/fluids/BlockFluidClassic;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
            instructions.insert(insn, list);
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/block/IFluidloggableFluid");
        this.overrideMethod(classNode, method -> method.name.equals("getQuantaValue"), "getQuantaValue", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)I", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlock", "I");
        });
        this.overrideMethod(classNode, method -> method.name.equals(obfuscated ? "func_180650_b" : "updateTick"), "fluidUpdateTick", "(Lnet/minecraftforge/fluids/BlockFluidClassic;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;IIZ)V", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "quantaPerBlock", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidClassic", "canCreateSources", "Z");
        });
        this.overrideMethod(classNode, method -> method.name.equals("isFlowingVertically"), "isFluidFlowingVertically", "(Lnet/minecraftforge/fluids/BlockFluidClassic;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)Z", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
        });
        this.overrideMethod(classNode, method -> method.name.equals("canFlowInto"), "canFlowInto", "(Lnet/minecraftforge/fluids/BlockFluidClassic;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
        });
        this.overrideMethod(classNode, method -> method.name.equals("isSourceBlock"), "isSourceBlock", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/EnumFacing;)Z", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(185, "net/minecraft/world/IBlockAccess", obfuscated ? "func_180495_p" : "getBlockState", "(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;", true);
            generator.visitInsn(1);
        });
        this.overrideMethod(classNode, method -> method.name.equals("place"), "place", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraftforge/fluids/FluidStack;ZLnet/minecraft/block/state/IBlockState;)I", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(21, 4);
            generator.visitVarInsn(25, 0);
            generator.visitMethodInsn(182, "net/minecraft/block/Block", obfuscated ? "func_176223_P" : "getDefaultState", "()Lnet/minecraft/block/state/IBlockState;", false);
        });
        this.overrideMethod(classNode, method -> method.name.equals("drain"), "drain", "(Lnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;ZLnet/minecraftforge/fluids/FluidStack;)Lnet/minecraftforge/fluids/FluidStack;", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidClassic", "stack", "Lnet/minecraftforge/fluids/FluidStack;");
        });
        this.addMethod(classNode, "isFluidloggableFluid", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", "isFluidFluidloggable", "(Lgit/jbredwards/fluidlogged_api/api/block/IFluidloggableFluid;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;IZ)Z", generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(25, 3);
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidBase", "densityDir", "I");
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/fluids/BlockFluidClassic", "canCreateSources", "Z");
        });
        this.addMethod(classNode, "isFluidloggableFluid", "()Z", "isFluidFluidloggable", "(Lnet/minecraft/block/Block;)Z", generator -> generator.visitVarInsn(25, 0));
        classNode.interfaces.add("git/jbredwards/fluidlogged_api/mod/asm/plugins/forge/PluginBlockFluidClassic$Accessor");
        this.addMethod(classNode, "getOptimalFlowDirections_Public", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)[Z", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(182, "net/minecraftforge/fluids/BlockFluidClassic", "getOptimalFlowDirections", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)[Z", false);
        });
        this.addMethod(classNode, "getLargerQuanta_Public", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)I", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
            generator.visitMethodInsn(182, "net/minecraftforge/fluids/BlockFluidClassic", "getLargerQuanta", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;I)I", false);
        });
        this.addMethod(classNode, "canFlowInto_Public", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitMethodInsn(182, "net/minecraftforge/fluids/BlockFluidClassic", "canFlowInto", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z", false);
        });
        this.addMethod(classNode, "flowIntoBlock_Public", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;I)V", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(25, 2);
            generator.visitVarInsn(21, 3);
            generator.visitMethodInsn(182, "net/minecraftforge/fluids/BlockFluidClassic", "flowIntoBlock", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;I)V", false);
        });
        return true;
    }

    @Override
    public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        method.localVariables.add(new LocalVariableNode("here", "Lnet/minecraft/block/state/IBlockState;", null, start, end, 5));
        return true;
    }

    @Override
    public boolean recalcFrames(boolean obfuscated) {
        return true;
    }

    public static interface Accessor {
        @Nonnull
        public boolean[] getOptimalFlowDirections_Public(@Nonnull World var1, @Nonnull BlockPos var2);

        public int getLargerQuanta_Public(@Nonnull IBlockAccess var1, @Nonnull BlockPos var2, int var3);

        public boolean canFlowInto_Public(@Nonnull IBlockAccess var1, @Nonnull BlockPos var2);

        public void flowIntoBlock_Public(@Nonnull World var1, @Nonnull BlockPos var2, int var3);
    }

    public static final class Hooks {
        @Nonnull
        public static final EnumFacing[] SIDES = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH};

        public static boolean canFlowInto(@Nonnull BlockFluidClassic block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            return FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidFromState(state), block.getFluid()) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) > 0 || block.canDisplace(world, pos);
        }

        @Nullable
        public static FluidStack drain(@Nonnull IFluidBlock block, @Nonnull World world, @Nonnull BlockPos pos, boolean doDrain, @Nullable FluidStack stack) {
            IBlockState here = world.func_180495_p(pos);
            FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)world, pos, here);
            if (fluidState.isEmpty()) {
                return null;
            }
            if (doDrain) {
                if (fluidState.getState() == here) {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                } else if (!FluidloggedUtils.setFluidState(world, pos, here, FluidState.EMPTY, false)) {
                    return null;
                }
            }
            return fluidState.getLevel() != 0 ? null : (stack == null ? new FluidStack(block.getFluid(), 1000) : stack.copy());
        }

        public static void fluidUpdateTick(@Nonnull BlockFluidClassic block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int quantaPerBlock, int densityDir, boolean canCreateSources) {
            if (!world.func_175707_a(pos.func_177982_a(-quantaPerBlock, -quantaPerBlock, -quantaPerBlock), pos.func_177982_a(quantaPerBlock, quantaPerBlock, quantaPerBlock))) {
                return;
            }
            IBlockState here = world.func_180495_p(pos);
            if (Hooks.tryVaporizeHere(block.getFluid(), state, here, world, pos)) {
                here = state;
            }
            EnumFacing facingDir = densityDir > 0 ? EnumFacing.UP : EnumFacing.DOWN;
            int quantaRemaining = quantaPerBlock - (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (quantaRemaining < quantaPerBlock) {
                int expQuanta;
                int adjacentSourceBlocks = 0;
                if (ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)pos, (IBlockState)state, (boolean)canCreateSources)) {
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        BlockPos offset = pos.func_177972_a(facing);
                        if (!Hooks.isSourceBlock((IFluidBlock)block, (IBlockAccess)world, offset, world.func_180495_p(offset), facing.func_176734_d())) continue;
                        ++adjacentSourceBlocks;
                    }
                }
                IBlockState vertical = world.func_180495_p(pos.func_177981_b(densityDir));
                if (adjacentSourceBlocks >= 2 && (vertical.func_185904_a().func_76220_a() || Hooks.isSourceBlock((IFluidBlock)block, (IBlockAccess)world, pos.func_177981_b(densityDir), vertical, facingDir.func_176734_d()))) {
                    expQuanta = quantaPerBlock;
                } else if (PluginBlockFluidBase.Hooks.hasVerticalFlow((IBlockAccess)world, pos, block.getFluid(), densityDir)) {
                    expQuanta = quantaPerBlock - 1;
                } else {
                    int maxQuanta = -100;
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        BlockPos offset = pos.func_177972_a(side);
                        if (!FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, side) || !FluidloggedUtils.canFluidFlow((IBlockAccess)world, offset, world.func_180495_p(offset), side.func_176734_d())) continue;
                        maxQuanta = ((Accessor)block).getLargerQuanta_Public((IBlockAccess)world, offset, maxQuanta);
                    }
                    expQuanta = maxQuanta - 1;
                }
                if (expQuanta != quantaRemaining) {
                    quantaRemaining = expQuanta;
                    if (expQuanta <= 0) {
                        world.func_175698_g(pos);
                    } else {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(quantaPerBlock - expQuanta)), 11);
                        world.func_175684_a(pos, (Block)block, block.func_149738_a(world));
                        world.func_175722_b(pos, (Block)block, false);
                    }
                }
            } else {
                Hooks.tryFlowIntoFluidloggable((IFluidBlock)block, world, pos, facingDir, state, here, quantaPerBlock, canCreateSources, EnumFacing.field_176754_o);
            }
            if (FluidloggedAPIConfigHandler.verticalFluidloggedFluidSpread) {
                Hooks.tryFlowIntoFluidloggable((IFluidBlock)block, world, pos, facingDir, state, here, quantaPerBlock, canCreateSources, facingDir);
            }
            if (FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facingDir) && block.canDisplace((IBlockAccess)world, pos.func_177981_b(densityDir))) {
                ((Accessor)block).flowIntoBlock_Public(world, pos.func_177981_b(densityDir), 1);
                return;
            }
            int flowMeta = quantaPerBlock - quantaRemaining + 1;
            if (flowMeta >= quantaPerBlock) {
                return;
            }
            if (Hooks.isSourceBlock((IFluidBlock)block, (IBlockAccess)world, pos, here, null) || !block.isFlowingVertically((IBlockAccess)world, pos)) {
                if (PluginBlockFluidBase.Hooks.hasVerticalFlow((IBlockAccess)world, pos, block.getFluid(), densityDir)) {
                    flowMeta = 1;
                }
                boolean[] flowTo = ((Accessor)block).getOptimalFlowDirections_Public(world, pos);
                for (int i = 0; i < 4; ++i) {
                    if (!flowTo[i] || !FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, SIDES[i])) continue;
                    ((Accessor)block).flowIntoBlock_Public(world, pos.func_177972_a(SIDES[i]), flowMeta);
                }
            }
        }

        public static boolean tryVaporizeHere(@Nonnull Fluid fluid, @Nonnull IBlockState state, @Nonnull IBlockState here, @Nonnull World world, @Nonnull BlockPos pos) {
            if (FluidloggedAPIConfigHandler.lavalogVaporizeFlammable && here != state && state.func_185904_a() == Material.field_151587_i && world.func_82736_K().func_82766_b("doFireTick")) {
                boolean isFlammable = here.func_185904_a().func_76217_h();
                if (!isFlammable) {
                    for (EnumFacing facing : EnumFacing.values()) {
                        if (!here.func_177230_c().isFlammable((IBlockAccess)world, pos, facing)) continue;
                        isFlammable = true;
                        break;
                    }
                }
                if (isFlammable) {
                    if (!world.field_72995_K) {
                        FluidloggedAPINetworkHandler.INSTANCE.sendToAllAround((IMessage)new MessageVaporizeEffects(fluid, pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 64.0));
                        fluid.vaporize(null, world, pos, new FluidStack(fluid, 1000));
                    }
                    return world.func_175656_a(pos, state);
                }
            }
            return false;
        }

        public static void tryFlowIntoFluidloggable(@Nonnull IFluidBlock block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facingDir, @Nonnull IBlockState state, @Nonnull IBlockState here, int quantaPerBlock, boolean canCreateSources, EnumFacing ... flowInto) {
            if (quantaPerBlock > 0 && FluidloggedAPIConfigHandler.fluidloggedFluidSpread > 0 && (FluidloggedAPIConfigHandler.fluidloggedFluidSpread == 2 || state != here) && (state != here || FluidloggedUtils.isFluidloggableFluid(state, world, pos)) && ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)pos, (IBlockState)state, (boolean)canCreateSources)) {
                block0: for (EnumFacing facing : flowInto) {
                    IBlockState neighbor;
                    BlockPos offset;
                    if (!FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, facing) || !FluidloggedUtils.canFluidFlow((IBlockAccess)world, offset = pos.func_177972_a(facing), neighbor = world.func_180495_p(offset), facing.func_176734_d()) || !FluidloggedUtils.isStateFluidloggable(neighbor, world, offset, block.getFluid()) || !FluidState.get((IBlockAccess)world, offset).isEmpty()) continue;
                    for (EnumFacing adjacentFacing : EnumFacing.field_82609_l) {
                        FluidState adjacentFluid;
                        IBlockState adjacent;
                        BlockPos adjacentOffset;
                        if (adjacentFacing == facingDir || adjacentFacing == facing.func_176734_d() || adjacentFacing.func_96559_d() != 0 && !FluidloggedAPIConfigHandler.verticalFluidloggedFluidSpread || !FluidloggedUtils.canFluidFlow((IBlockAccess)world, offset, neighbor, adjacentFacing) || !FluidloggedUtils.canFluidFlow((IBlockAccess)world, adjacentOffset = offset.func_177972_a(adjacentFacing), adjacent = world.func_180495_p(adjacentOffset), adjacentFacing.func_176734_d())) continue;
                        FluidState fluidState = adjacentFluid = FluidloggedAPIConfigHandler.fluidloggedFluidSpread == 1 ? FluidState.get((IBlockAccess)world, adjacentOffset) : FluidloggedUtils.getFluidState((IBlockAccess)world, adjacentOffset, adjacent);
                        if (!FluidloggedUtils.isCompatibleFluid(adjacentFluid.getFluid(), block.getFluid()) || !FluidloggedUtils.isFluidloggableFluid(adjacentFluid.getState(), world, adjacentOffset)) continue;
                        FluidloggedUtils.setFluidState(world, offset, neighbor, FluidState.of(block.getFluid()), false);
                        continue block0;
                    }
                }
            }
        }

        public static boolean isFluidFlowingVertically(@Nonnull BlockFluidClassic block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int densityDir) {
            EnumFacing facingDir = densityDir < 0 ? EnumFacing.UP : EnumFacing.DOWN;
            IBlockState here = world.func_180495_p(pos);
            if (!FluidloggedUtils.canFluidFlow(world, pos, here, facingDir.func_176734_d())) {
                return false;
            }
            IBlockState neighbor = world.func_180495_p(pos.func_177981_b(densityDir));
            return FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(world, pos.func_177981_b(densityDir), neighbor).getFluid(), block.getFluid()) || FluidloggedUtils.isCompatibleFluid(FluidloggedUtils.getFluidState(world, pos, here).getFluid(), block.getFluid()) && ((Accessor)block).canFlowInto_Public(world, pos.func_177981_b(densityDir));
        }

        public static boolean isFluidFluidloggable(@Nonnull IFluidloggableFluid block, @Nonnull IBlockState fluid, @Nonnull World world, @Nonnull BlockPos pos, int densityDir, boolean canCreateSources) {
            if (!block.isFluidloggableFluid()) {
                return false;
            }
            if ((Integer)fluid.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                return true;
            }
            if (!canCreateSources) {
                return false;
            }
            IBlockState vertical = world.func_180495_p(pos.func_177979_c(densityDir));
            return FluidloggedUtils.isCompatibleFluid(block.getFluid(), FluidloggedUtils.getFluidState((IBlockAccess)world, pos.func_177979_c(densityDir), vertical).getFluid()) && FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos.func_177979_c(densityDir), vertical, densityDir < 1 ? EnumFacing.DOWN : EnumFacing.UP);
        }

        public static boolean isFluidFluidloggable(@Nonnull Block block) {
            Fluid fluid = FluidloggedUtils.getFluidFromBlock(block);
            return fluid != null && block == fluid.getBlock() && !block.func_149716_u();
        }

        public static boolean isSourceBlock(@Nonnull IFluidBlock block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nullable EnumFacing facing) {
            if (facing != null && !FluidloggedUtils.canFluidFlow(world, pos, here, facing)) {
                return false;
            }
            FluidState fluidState = FluidloggedUtils.getFluidState(world, pos, here);
            return FluidloggedUtils.isCompatibleFluid(fluidState.getFluid(), block.getFluid()) && fluidState.getLevel() == 0;
        }

        public static boolean getOptimalFlowDirections(@Nonnull BlockFluidClassic block, @Nonnull IBlockAccess world, @Nonnull BlockPos offset, @Nonnull BlockPos pos, @Nonnull IBlockState here, int side) {
            return !FluidloggedUtils.canFluidFlow(world, pos, here, SIDES[side]) || block.isSourceBlock(world, offset);
        }

        public static int getQuantaValue(@Nonnull IFluidBlock block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int quantaPerBlock) {
            IBlockState here = world.func_180495_p(pos);
            if (here.func_177230_c().isAir(here, world, pos)) {
                return 0;
            }
            FluidState fluidState = FluidloggedUtils.getFluidState(world, pos, here);
            return FluidloggedUtils.isCompatibleFluid(fluidState.getFluid(), block.getFluid()) ? quantaPerBlock - fluidState.getLevel() : -1;
        }

        public static int place(@Nonnull IFluidBlock block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidStack fluidStack, boolean doPlace, @Nonnull IBlockState defaultState) {
            if (fluidStack.amount < 1000) {
                return 0;
            }
            if (doPlace) {
                IBlockState here = world.func_180495_p(pos);
                if (FluidloggedUtils.isStateFluidloggable(here, world, pos, block.getFluid())) {
                    if (!FluidloggedUtils.setFluidState(world, pos, here, FluidState.of(block.getFluid()), true)) {
                        return 0;
                    }
                } else {
                    FluidUtil.destroyBlockOnFluidPlacement((World)world, (BlockPos)pos);
                    world.func_180501_a(pos, defaultState, 11);
                }
            }
            return 1000;
        }
    }
}

