/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.util;

import git.jbredwards.fluidlogged_api.api.asm.impl.IChunkProvider;
import git.jbredwards.fluidlogged_api.api.asm.impl.IFluidStateProvider;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@Immutable
public class FluidState
extends Pair<Fluid, IBlockState> {
    @Nonnull
    public static final FluidState EMPTY = new FluidState(null, () -> Blocks.field_150350_a.func_176223_P());
    protected final Fluid fluid;
    protected final Supplier<IBlockState> state;
    protected byte level = (byte)-1;

    protected FluidState(@Nullable Fluid fluidIn, @Nonnull Supplier<IBlockState> stateIn) {
        this.fluid = fluidIn;
        this.state = stateIn;
    }

    @Nonnull
    public static FluidState of(@Nullable Fluid fluid) {
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return EMPTY;
        }
        return FluidState.of(!(fluid.getBlock() instanceof BlockLiquid) ? fluid.getBlock().func_176223_P() : BlockLiquid.func_176363_b((Material)fluid.getBlock().func_176223_P().func_185904_a()).func_176223_P());
    }

    @Nonnull
    public static FluidState of(@Nullable Block block) {
        return block != null ? FluidState.of(FluidloggedUtils.getFluidFromBlock(block)) : EMPTY;
    }

    @Nonnull
    public static FluidState of(@Nullable IBlockState state) {
        FluidState defaultFluidState = IFluidStateProvider.getDefaultFluidState(state);
        if (!defaultFluidState.isEmpty()) {
            return defaultFluidState;
        }
        Fluid fluid = FluidloggedUtils.getFluidFromState(state);
        if (fluid == null) {
            return EMPTY;
        }
        FluidState fluidState = new FluidState(fluid, () -> state);
        IFluidStateProvider.setDefaultFluidState(state, fluidState);
        return fluidState;
    }

    @Nonnull
    public static FluidState get(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return FluidState.getFromProvider((ICapabilityProvider)IChunkProvider.getChunk(world, pos), pos);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static FluidState get(@Nonnull BlockPos pos) {
        return FluidState.getFromProvider((ICapabilityProvider)IChunkProvider.getClientChunk(pos), pos);
    }

    @Nonnull
    public static FluidState getFromProvider(@Nullable ICapabilityProvider p, @Nonnull BlockPos pos) {
        IFluidStateCapability cap = IFluidStateCapability.get(p);
        return cap == null ? EMPTY : cap.getContainer(pos).getFluidState(pos, EMPTY);
    }

    @Nonnull
    public static FluidState deserialize(int serialized) {
        return FluidState.of(Block.func_149729_e((int)serialized));
    }

    public int serialize() {
        return this.isEmpty() ? 0 : Block.func_149682_b((Block)this.getBlock());
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Nonnull
    public IBlockState getState() {
        return this.state.get();
    }

    public boolean isValid() {
        return this.getState().func_177230_c() instanceof IFluidBlock;
    }

    @Nonnull
    public IFluidBlock getFluidBlock() {
        if (this.isValid()) {
            return (IFluidBlock)this.getState().func_177230_c();
        }
        throw new IllegalStateException("Invalid FluidState, please report this to the Fluidlogged API bug tracker!");
    }

    @Nonnull
    public Block getBlock() {
        return this.getState().func_177230_c();
    }

    @Nonnull
    public Material getMaterial() {
        return this.getState().func_185904_a();
    }

    public int getLevel() {
        return this.level > -1 ? this.level : (this.level = ((Integer)this.getState().func_177229_b((IProperty)BlockLiquid.field_176367_b)).byteValue());
    }

    public final Fluid getLeft() {
        return this.getFluid();
    }

    public final IBlockState getRight() {
        return this.getState();
    }

    public final IBlockState getValue() {
        return (IBlockState)super.getValue();
    }

    public final IBlockState setValue(@Nullable IBlockState value) {
        throw new UnsupportedOperationException();
    }
}

