/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.block;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class BlockWaterloggedPlant
extends BlockBush
implements IFluidloggable {
    @Nonnull
    protected Fluid parentFluid = FluidRegistry.WATER;

    protected BlockWaterloggedPlant(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    protected BlockWaterloggedPlant(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
    }

    public boolean func_176196_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)worldIn, pos);
        return !fluidState.isEmpty() && this.isFluidValid(this.func_176223_P(), worldIn, pos, fluidState.getFluid()) && FluidloggedUtils.isFluidloggableFluid(fluidState.getState(), worldIn, pos) && super.func_176196_c(worldIn, pos);
    }

    @Override
    public boolean isFluidValid(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Fluid fluid) {
        return FluidloggedUtils.isCompatibleFluid(this.parentFluid, fluid);
    }

    @Override
    @Nonnull
    public EnumActionResult onFluidDrain(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState here, int blockFlags) {
        world.func_175718_b(2001, pos, BlockWaterloggedPlant.func_176210_f((IBlockState)here));
        this.func_176226_b(world, pos, here, 0);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        return EnumActionResult.SUCCESS;
    }
}

