/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.asm;

import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigHandler;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.ws.Holder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public interface IASMPlugin
extends Opcodes {
    @Nonnull
    public static final Holder<String> ACTIVE_PLUGIN = new Holder((Object)"Unknown Plugin");

    public static void resetActivePlugin() {
        IASMPlugin.ACTIVE_PLUGIN.value = "Unknown Plugin";
    }

    public static void setActivePlugin(@Nonnull String plugin) {
        IASMPlugin.ACTIVE_PLUGIN.value = plugin;
    }

    @Nonnull
    default public String getHookClass() {
        return this.getClass().getName().replace('.', '/') + "$Hooks";
    }

    default public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        return this.isMethodValid(method, obfuscated) ? 1 : 0;
    }

    default public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return false;
    }

    default public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        return true;
    }

    default public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        return true;
    }

    default public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        return false;
    }

    default public byte[] transform(@Nonnull byte[] basicClass, boolean obfuscated) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, this.recalcFrames(obfuscated) ? 4 : 0);
        if (this.transformClass(classNode, obfuscated)) {
            for (MethodNode method : classNode.methods) {
                int index = this.getMethodIndex(method, obfuscated);
                if (index == 0) continue;
                this.informConsole(classNode.name, method);
                LabelNode start = new LabelNode();
                LabelNode end = new LabelNode();
                if (this.addLocalVariables(method, start, end, index)) {
                    method.instructions.insertBefore(method.instructions.getFirst(), (AbstractInsnNode)start);
                    method.instructions.insert(method.instructions.getLast(), (AbstractInsnNode)end);
                }
                for (AbstractInsnNode insn : method.instructions.toArray()) {
                    if (this.transform(method.instructions, method, insn, obfuscated, index)) break;
                }
            }
        } else {
            this.informConsole(classNode.name, null);
        }
        ClassWriter writer = new ClassWriter(1 | (this.recalcFrames(obfuscated) ? 2 : 0));
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    default public boolean shouldInformConsole() {
        return FluidloggedAPIConfigHandler.debugASMPlugins;
    }

    default public void informConsole(@Nonnull String className, @Nullable MethodNode method) {
        if (this.shouldInformConsole()) {
            if (method == null) {
                System.out.printf("%s: transforming... %s%n", IASMPlugin.ACTIVE_PLUGIN.value, className);
            } else {
                System.out.printf("%s: transforming... %s.%s%s%n", IASMPlugin.ACTIVE_PLUGIN.value, className, method.name, method.desc);
            }
        }
    }

    default public void overrideMethod(@Nonnull ClassNode classNode, @Nonnull Predicate<MethodNode> searchCondition, @Nullable String hookName, @Nullable String hookDesc, @Nonnull Consumer<GeneratorAdapter> consumer) {
        for (MethodNode method : classNode.methods) {
            if (!searchCondition.test(method)) continue;
            this.informConsole(classNode.name, method);
            method.instructions.clear();
            if (method.tryCatchBlocks != null) {
                method.tryCatchBlocks.clear();
            }
            if (method.localVariables != null) {
                method.localVariables.clear();
            }
            if (method.visibleLocalVariableAnnotations != null) {
                method.visibleLocalVariableAnnotations.clear();
            }
            if (method.invisibleLocalVariableAnnotations != null) {
                method.invisibleLocalVariableAnnotations.clear();
            }
            consumer.accept(new GeneratorAdapter((MethodVisitor)method, method.access, method.name, method.desc));
            if (hookName != null && hookDesc != null) {
                method.visitMethodInsn(184, this.getHookClass(), hookName, hookDesc, false);
            }
            method.visitInsn(Type.getReturnType((String)method.desc).getOpcode(172));
        }
    }

    default public void addMethod(@Nonnull ClassNode classNode, @Nonnull String name, @Nonnull String desc, @Nullable String hookName, @Nullable String hookDesc, @Nonnull Consumer<GeneratorAdapter> consumer) {
        MethodNode method = new MethodNode(1, name, desc, null, null);
        this.informConsole(classNode.name, method);
        consumer.accept(new GeneratorAdapter((MethodVisitor)method, method.access, method.name, method.desc));
        if (hookName != null && hookDesc != null) {
            method.visitMethodInsn(184, this.getHookClass(), hookName, hookDesc, false);
        }
        method.visitInsn(Type.getReturnType((String)method.desc).getOpcode(172));
        classNode.methods.add(method);
    }

    default public void removeFrom(@Nonnull InsnList instructions, @Nonnull AbstractInsnNode insn, int n) {
        Supplier<AbstractInsnNode> toRemove;
        Supplier<AbstractInsnNode> supplier = n < 0 ? () -> ((AbstractInsnNode)insn).getPrevious() : (toRemove = () -> ((AbstractInsnNode)insn).getNext());
        if (n < 0) {
            n = -n;
        }
        while (n-- > 0) {
            instructions.remove(toRemove.get());
        }
        instructions.remove(insn);
    }

    @Nonnull
    default public MethodInsnNode genMethodNode(@Nonnull String name, @Nonnull String desc) {
        return this.genMethodNode(this.getHookClass(), name, desc);
    }

    @Nonnull
    default public MethodInsnNode genMethodNode(@Nonnull String clazz, @Nonnull String name, @Nonnull String desc) {
        return new MethodInsnNode(184, clazz, name, desc, false);
    }

    @Nonnull
    default public AbstractInsnNode getPrevious(@Nonnull AbstractInsnNode insn, int count) {
        while (count-- > 0 && insn.getPrevious() != null) {
            insn = insn.getPrevious();
        }
        return insn;
    }

    @Nonnull
    default public AbstractInsnNode getNext(@Nonnull AbstractInsnNode insn, int count) {
        while (count-- > 0 && insn.getNext() != null) {
            insn = insn.getNext();
        }
        return insn;
    }

    default public boolean checkMethod(@Nonnull MethodNode method, @Nullable String name, @Nullable String desc) {
        if (name == null && desc == null) {
            return true;
        }
        if (name == null) {
            return method.desc.equals(desc);
        }
        if (desc == null) {
            return method.name.equals(name);
        }
        return method.name.equals(name) && method.desc.equals(desc);
    }

    default public boolean checkMethod(@Nullable AbstractInsnNode insn, @Nullable String name, @Nullable String desc) {
        if (!(insn instanceof MethodInsnNode)) {
            return false;
        }
        if (name == null && desc == null) {
            return true;
        }
        if (name == null) {
            return ((MethodInsnNode)insn).desc.equals(desc);
        }
        if (desc == null) {
            return ((MethodInsnNode)insn).name.equals(name);
        }
        return ((MethodInsnNode)insn).name.equals(name) && ((MethodInsnNode)insn).desc.equals(desc);
    }

    default public boolean checkMethod(@Nullable AbstractInsnNode insn, @Nonnull String name) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).name.equals(name);
    }

    default public boolean checkField(@Nullable AbstractInsnNode insn, @Nullable String name, @Nullable String desc) {
        if (!(insn instanceof FieldInsnNode)) {
            return false;
        }
        if (name == null && desc == null) {
            return true;
        }
        if (name == null) {
            return ((FieldInsnNode)insn).desc.equals(desc);
        }
        if (desc == null) {
            return ((FieldInsnNode)insn).name.equals(name);
        }
        return ((FieldInsnNode)insn).name.equals(name) && ((FieldInsnNode)insn).desc.equals(desc);
    }

    default public boolean checkField(@Nullable AbstractInsnNode insn, @Nonnull String name) {
        return insn instanceof FieldInsnNode && ((FieldInsnNode)insn).name.equals(name);
    }

    default public boolean recalcFrames(boolean obfuscated) {
        return false;
    }
}

