/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.core.BCLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.profiler.Profiler;
import org.apache.logging.log4j.Logger;

public class ProfilerUtil {
    public static void printProfilerResults(Profiler profiler, String rootName) {
        ProfilerUtil.printProfilerResults(profiler, rootName, -1L);
    }

    public static void printProfilerResults(Profiler profiler, String rootName, long totalNanoseconds) {
        ProfilerUtil.writeProfilerResults(profiler, rootName, totalNanoseconds, System.out::println);
    }

    public static void logProfilerResults(Profiler profiler, String rootName) {
        ProfilerUtil.logProfilerResults(profiler, rootName, -1L);
    }

    public static void logProfilerResults(Profiler profiler, String rootName, long totalNanoseconds) {
        ProfilerUtil.writeProfilerResults(profiler, rootName, totalNanoseconds, arg_0 -> ((Logger)BCLog.logger).info(arg_0));
    }

    public static void saveProfilerResults(Profiler profiler, String rootName, Path dest) throws IOException {
        ProfilerUtil.saveProfilerResults(profiler, rootName, -1L, dest);
    }

    public static void saveProfilerResults(Profiler profiler, String rootName, File dest) throws IOException {
        dest = dest.getAbsoluteFile();
        dest.getParentFile().mkdirs();
        ProfilerUtil.saveProfilerResults(profiler, rootName, -1L, dest.toPath());
    }

    public static void saveProfilerResults(Profiler profiler, String rootName, long totalNanoseconds, Path dest) throws IOException {
        try (BufferedWriter br = Files.newBufferedWriter(dest, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            ProfilerUtil.writeProfilerResults(profiler, rootName, str -> {
                br.write(str);
                br.newLine();
            });
            br.flush();
        }
    }

    public static <E extends Throwable> void writeProfilerResults(Profiler profiler, String rootName, ILogAcceptor<E> dest) throws E {
        ProfilerUtil.writeProfilerResults(profiler, rootName, -1L, dest);
    }

    public static <E extends Throwable> void writeProfilerResults(Profiler profiler, String rootName, long totalNanoseconds, ILogAcceptor<E> dest) throws E {
        ProfilerUtil.writeProfilerResults_Internal(profiler, rootName, totalNanoseconds, 0, dest);
    }

    private static <E extends Throwable> void writeProfilerResults_Internal(Profiler profiler, String sectionName, long totalNanoseconds, int indent, ILogAcceptor<E> dest) throws E {
        List list = profiler.func_76321_b(sectionName);
        if (list != null && list.size() >= 3) {
            for (int i = 1; i < list.size(); ++i) {
                Profiler.Result result = (Profiler.Result)list.get(i);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format("[%02d] ", indent));
                for (int j = 0; j < indent; ++j) {
                    builder.append("|   ");
                }
                builder.append(result.field_76331_c);
                builder.append(" - ");
                builder.append(String.format("%.2f", result.field_76332_a));
                builder.append("%/");
                builder.append(String.format("%.2f", result.field_76330_b));
                if (totalNanoseconds > 0L) {
                    builder.append(" (");
                    long nano = (long)(result.field_76330_b * (double)totalNanoseconds / 100.0);
                    if (nano < 99999L) {
                        builder.append(NumberFormat.getInstance().format(nano));
                        builder.append("ns");
                    } else if (nano < 99999999L) {
                        builder.append(NumberFormat.getInstance().format(nano / 1000L));
                        builder.append("\u00b5s");
                    } else if (nano < 99999999999L) {
                        builder.append(NumberFormat.getInstance().format(nano / 1000000L));
                        builder.append("ms");
                    } else {
                        builder.append(NumberFormat.getInstance().format(nano / 1000000000L));
                        builder.append("s");
                    }
                    builder.append(")");
                }
                dest.write(builder.toString());
                if ("unspecified".equals(result.field_76331_c)) continue;
                if (indent > 20) {
                    dest.write("[[ Too deep! ]]");
                    continue;
                }
                ProfilerUtil.writeProfilerResults_Internal(profiler, sectionName + "." + result.field_76331_c, totalNanoseconds, indent + 1, dest);
            }
        }
    }

    public static ProfilerEntry createEntry(Profiler p1, Profiler p2) {
        if (p1.field_76327_a) {
            if (p2.field_76327_a) {
                return new ProfilerEntry2(p1, p2);
            }
            return new ProfilerEntry1(p1);
        }
        if (p2.field_76327_a) {
            return new ProfilerEntry1(p2);
        }
        return ProfilerEntry0.INSTANCE;
    }

    static final class ProfilerEntry2
    implements ProfilerEntry {
        final Profiler p1;
        final Profiler p2;

        ProfilerEntry2(Profiler p1, Profiler p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public void startSection(String name) {
            this.p1.func_76320_a(name);
            this.p2.func_76320_a(name);
        }

        @Override
        public void endSection() {
            this.p1.func_76319_b();
            this.p2.func_76319_b();
        }
    }

    static final class ProfilerEntry1
    implements ProfilerEntry {
        final Profiler p;

        ProfilerEntry1(Profiler p) {
            this.p = p;
        }

        @Override
        public void startSection(String name) {
            this.p.func_76320_a(name);
        }

        @Override
        public void endSection() {
            this.p.func_76319_b();
        }
    }

    static enum ProfilerEntry0 implements ProfilerEntry
    {
        INSTANCE;


        @Override
        public void startSection(String name) {
        }

        @Override
        public void endSection() {
        }
    }

    public static interface ProfilerEntry {
        public void startSection(String var1);

        public void endSection();

        default public void endStartSection(String name) {
            this.endSection();
            this.startSection(name);
        }
    }

    public static interface ILogAcceptor<E extends Throwable> {
        public void write(String var1) throws E;
    }
}

