/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.item;

import buildcraft.lib.BCLib;
import buildcraft.lib.guide.GuideBook;
import buildcraft.lib.guide.GuideBookRegistry;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.misc.NBTUtilBC;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemGuide
extends ItemBC_Neptune {
    private static final String DEFAULT_BOOK = "buildcraftcore:main";
    private static final ResourceLocation ADVANCEMENT = new ResourceLocation("buildcraftcore:guide");
    private static final String TAG_BOOK_NAME = "BookName";

    public ItemGuide(String id) {
        super(id);
        this.func_77642_a(this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        AdvancementUtil.unlockAdvancement(player, ADVANCEMENT);
        player.openGui((Object)BCLib.INSTANCE, 0, world, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    protected void addSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (GuideBook book : GuideBookRegistry.INSTANCE.getAllEntries()) {
            ItemStack stack = new ItemStack((Item)this);
            if (!book.name.toString().equals(DEFAULT_BOOK)) {
                ItemGuide.setBookName(stack, book.name.toString());
            }
            items.add((Object)stack);
        }
    }

    public String func_77653_i(ItemStack stack) {
        String bookName = ItemGuide.getBookName(stack);
        GuideBook book = GuideBookRegistry.INSTANCE.getBook(bookName);
        if (book != null) {
            return book.title.func_150254_d();
        }
        return super.func_77653_i(stack);
    }

    public static String getBookName(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b(TAG_BOOK_NAME, 8)) {
            return DEFAULT_BOOK;
        }
        return nbt.func_74779_i(TAG_BOOK_NAME);
    }

    public static void setBookName(ItemStack stack, String book) {
        NBTTagCompound nbt = NBTUtilBC.getItemData(stack);
        nbt.func_74778_a(TAG_BOOK_NAME, book);
    }
}

