/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.wind;

import ic2.api.classic.wind.IWindFactory;
import ic2.api.classic.wind.IWindHandler;
import ic2.api.classic.wind.IWindHandlerInfo;
import ic2.api.classic.wind.IWindManager;
import ic2.core.IC2;
import ic2.core.platform.wind.ClassicWindFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;

public class WindManager
implements IWindManager {
    Map<World, IWindHandlerInfo> handlers = new HashMap<World, IWindHandlerInfo>();
    List<IWindFactory> factories = new ArrayList<IWindFactory>();
    IWindFactory defaultFactory = new ClassicWindFactory();

    @Override
    public void registerWindHandlerFactory(IWindFactory factory) {
        if (factory == null) {
            return;
        }
        this.factories.add(factory);
    }

    @Override
    public IWindHandler getHanlderFromWorld(World world) {
        if (world == null) {
            IC2.log.warn("Wind Managers Require a World To run");
            return null;
        }
        IWindHandlerInfo handler = this.handlers.get(world);
        if (handler == null) {
            handler = this.createForWorld(world);
            this.handlers.put(world, handler);
        }
        return handler;
    }

    private IWindHandlerInfo createForWorld(World world) {
        for (IWindFactory factory : this.factories) {
            IWindHandlerInfo handler;
            if (!factory.canHandleWorld(world) || (handler = factory.createWindHander(world)) == null) continue;
            return handler;
        }
        return this.defaultFactory.createWindHander(world);
    }

    public void onUnload() {
        for (IWindHandlerInfo info : this.handlers.values()) {
            info.onUnloaded();
        }
        this.handlers.clear();
    }

    public void onWorldUnload(World world) {
        IWindHandlerInfo info = this.handlers.remove(world);
        if (info != null) {
            info.onUnloaded();
        }
    }
}

