/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import ic2.core.platform.textures.Ic2Models;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.util.vector.Vector3f;

public abstract class BaseModel
extends PerspectiveMapWrapper {
    public static final Vec3Helper[][] faces = new Vec3Helper[][]{{new Vec3Helper(false, false, false), new Vec3Helper(true, false, true)}, {new Vec3Helper(false, true, false), new Vec3Helper(true, true, true)}, {new Vec3Helper(false, false, false), new Vec3Helper(true, true, false)}, {new Vec3Helper(false, false, true), new Vec3Helper(true, true, true)}, {new Vec3Helper(false, false, false), new Vec3Helper(true, true, true)}, {new Vec3Helper(false, false, false), new Vec3Helper(true, true, true)}};
    static final FaceBakery bake = new FaceBakery();
    private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> camera;
    private TextureAtlasSprite partical;
    private static List<BakedQuad> EMPTYLIST = ImmutableList.of();

    public BaseModel(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        super(null, transforms);
        this.camera = transforms;
    }

    public ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getCamera() {
        return this.camera;
    }

    public FaceBakery getBakery() {
        return bake;
    }

    public List<BakedQuad> getEmptyList() {
        return EMPTYLIST;
    }

    public Vector3f getMinBox(EnumFacing side, AxisAlignedBB box) {
        return faces[side.func_176745_a()][0].applyBoundingBox(box);
    }

    public Vector3f getMaxBox(EnumFacing side, AxisAlignedBB box) {
        return faces[side.func_176745_a()][1].applyBoundingBox(box);
    }

    protected void setParticalTexture(TextureAtlasSprite sprite) {
        this.partical = Ic2Models.getIconSafe(sprite);
    }

    public abstract void init();

    public TextureAtlasSprite func_177554_e() {
        return this.partical;
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.func_177555_b();
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    protected List<BakedQuad>[] createList(int count) {
        List[] quads = new List[count];
        for (int i = 0; i < count; ++i) {
            quads[i] = new ArrayList();
        }
        return quads;
    }

    public static class Vec3Helper {
        boolean x;
        boolean y;
        boolean z;

        public Vec3Helper(boolean par1, boolean par2, boolean par3) {
            this.x = par1;
            this.y = par2;
            this.z = par3;
        }

        public Vector3f applyBoundingBox(AxisAlignedBB box) {
            float xScale = (float)(this.x ? box.field_72336_d : box.field_72340_a);
            float yScale = (float)(this.y ? box.field_72337_e : box.field_72338_b);
            float zScale = (float)(this.z ? box.field_72334_f : box.field_72339_c);
            return new Vector3f(16.0f * xScale, 16.0f * yScale, 16.0f * zScale);
        }
    }
}

