/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player.achievements.criteria;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import ic2.core.platform.player.achievements.criteria.IStatPredicate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class StatTrigger
implements ICriterionTrigger<StatInstance> {
    private static final ResourceLocation ID = new ResourceLocation("ic2", "has_stat");
    Map<PlayerAdvancements, Listeners> instances = new LinkedHashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<StatInstance> listener) {
        Listeners list = this.instances.get(playerAdvancementsIn);
        if (list == null) {
            list = new Listeners(playerAdvancementsIn);
            this.instances.put(playerAdvancementsIn, list);
        }
        list.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<StatInstance> listener) {
        Listeners list = this.instances.get(playerAdvancementsIn);
        if (list == null) {
            return;
        }
        if (list.remove(listener)) {
            this.instances.remove(playerAdvancementsIn);
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.instances.remove(playerAdvancementsIn);
    }

    public void onTrigger(EntityPlayerMP mp) {
        Listeners list = this.instances.get(mp.func_192039_O());
        if (list != null) {
            list.trigger(mp);
        }
    }

    public StatInstance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return new StatInstance(ID, IStatPredicate.createFromObject(json.get("stat")));
    }

    public static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        final Set<ICriterionTrigger.Listener<StatInstance>> listeners = new LinkedHashSet<ICriterionTrigger.Listener<StatInstance>>();

        public Listeners(PlayerAdvancements player) {
            this.playerAdvancements = player;
        }

        public void add(ICriterionTrigger.Listener<StatInstance> instance) {
            this.listeners.add(instance);
        }

        public boolean remove(ICriterionTrigger.Listener<StatInstance> instance) {
            this.listeners.remove(instance);
            return this.listeners.isEmpty();
        }

        public void trigger(EntityPlayerMP mp) {
            ArrayList<ICriterionTrigger.Listener<StatInstance>> list = new ArrayList<ICriterionTrigger.Listener<StatInstance>>();
            for (ICriterionTrigger.Listener<StatInstance> listener : this.listeners) {
                if (!((StatInstance)listener.func_192158_a()).test(mp)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class StatInstance
    extends AbstractCriterionInstance {
        IStatPredicate predicate;

        public StatInstance(ResourceLocation id, IStatPredicate pre) {
            super(id);
            this.predicate = pre;
        }

        public boolean test(EntityPlayerMP mp) {
            return this.predicate.test(mp);
        }
    }
}

