/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.classic.network.INetworkGuiDataProvider;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import ic2.core.network.buffers.FieldBuffer;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

public class GuiFieldPacket
extends IC2Packet {
    List<NetworkManager.FieldData> data = new ArrayList<NetworkManager.FieldData>();
    int dim;
    BlockPos position;

    public GuiFieldPacket() {
    }

    public GuiFieldPacket(TileEntity tile, List<NetworkManager.FieldData> fields) {
        this.dim = tile.func_145831_w().field_73011_w.getDimension();
        this.position = tile.func_174877_v();
        this.data = fields;
    }

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        this.dim = buffer.readInt();
        this.position = BlockPos.func_177969_a((long)buffer.readLong());
        int expected = buffer.readByte();
        for (int i = 0; i < expected; ++i) {
            byte type = buffer.readByte();
            if (type > 0) {
                byte index = buffer.readByte();
                NetworkField.BitLevel level = NetworkField.BitLevel.getLevel(type - 1);
                this.data.add(new NetworkManager.FieldData(index, level, DataEncoder.decode(buffer, level)));
                continue;
            }
            String id = buffer.readString(NetworkField.BitLevel.Bit8);
            this.data.add(new NetworkManager.FieldData(id, DataEncoder.decode(buffer)));
        }
    }

    @Override
    public void write(ByteBuf par1) {
        OutputBuffer buffer = new OutputBuffer(par1);
        buffer.writeInt(this.dim);
        buffer.writeLong(this.position.func_177986_g());
        buffer.writeByte((byte)this.data.size());
        for (NetworkManager.FieldData entry : this.data) {
            if (entry.isNew) {
                buffer.writeByte((byte)(1 + entry.bitLevel.getIndex()));
                buffer.writeByte((byte)entry.index);
                DataEncoder.encode(buffer, entry.data, entry.bitLevel);
                continue;
            }
            buffer.writeByte((byte)0);
            buffer.writeString(entry.fieldName, NetworkField.BitLevel.Bit8);
            DataEncoder.encode(buffer, entry.data);
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dim);
        if (world == null) {
            throw new RuntimeException("Packet Got Incorrect Data");
        }
        TileEntity tile = world.func_175625_s(this.position);
        if (!(tile instanceof INetworkGuiDataProvider)) {
            throw new RuntimeException("Packet Got Incorrect Data");
        }
        INetworkGuiDataProvider other = (INetworkGuiDataProvider)tile;
        FieldBuffer buffer = NetworkManager.getFieldBuffer(tile);
        for (NetworkManager.FieldData entry : this.data) {
            FieldBuffer.FieldInfo info;
            FieldBuffer.FieldInfo fieldInfo = info = entry.isNew ? buffer.getInfo(entry.index) : buffer.getInfo(entry.fieldName);
            if (info == null) {
                FMLLog.getLogger().info("Field: " + (entry.isNew ? Integer.valueOf(entry.index) : entry.fieldName) + ", Not Exsistend In the clientSide");
                continue;
            }
            try {
                info.setData(tile, entry.data);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            other.onGuiFieldSynced(info.getFieldID());
        }
    }
}

