/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.fieldEvents.custom;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;

public class PayloadFieldPacket
implements INetworkFieldData {
    public String[] strings;
    public int[] numbers;
    public boolean[] flags;

    public PayloadFieldPacket() {
    }

    public PayloadFieldPacket(int text, int number, int flag) {
        this.strings = new String[text];
        this.numbers = new int[number];
        this.flags = new boolean[flag];
    }

    public void addString(int slot, String text) {
        this.strings[slot] = text;
    }

    public void addFlag(int slot, boolean flag) {
        this.flags[slot] = flag;
    }

    public void addNumber(int slot, int number) {
        this.numbers[slot] = number;
    }

    @Override
    public void read(IInputBuffer buffer) {
        int i;
        int length = buffer.readByte();
        this.strings = new String[length];
        for (i = 0; i < length; ++i) {
            this.strings[i] = buffer.readString();
        }
        length = buffer.readByte();
        this.numbers = new int[length];
        for (i = 0; i < length; ++i) {
            this.numbers[i] = buffer.readInt();
        }
        length = buffer.readByte();
        this.flags = new boolean[length];
        for (i = 0; i < length; ++i) {
            this.flags[i] = buffer.readBoolean();
        }
    }

    @Override
    public void write(IOutputBuffer buffer) {
        int i;
        buffer.writeByte((byte)this.strings.length);
        for (i = 0; i < this.strings.length; ++i) {
            buffer.writeString(this.strings[i]);
        }
        buffer.writeByte((byte)this.numbers.length);
        for (i = 0; i < this.numbers.length; ++i) {
            buffer.writeInt(this.numbers[i]);
        }
        buffer.writeByte((byte)this.flags.length);
        for (i = 0; i < this.flags.length; ++i) {
            buffer.writeBoolean(this.flags[i]);
        }
    }

    public boolean getFlag(int slot) {
        return this.flags[slot];
    }

    public int getNumber(int slot) {
        return this.numbers[slot];
    }

    public String getString(int slot) {
        return this.strings[slot];
    }

    public int getSize(int type) {
        switch (type) {
            case 0: {
                return this.strings.length;
            }
            case 1: {
                return this.numbers.length;
            }
            case 2: {
                return this.flags.length;
            }
        }
        return 0;
    }
}

