/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.tile.ISpecialWrenchable;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.block.base.util.info.misc.IWrench;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemToolWrench
extends ItemIC2
implements ICustomItemCameraTransform,
IWrench {
    public ItemToolWrench() {
        this.func_77625_d(1);
        this.setTranslationKey(Ic2ItemLang.wrench);
        this.func_77656_e(160);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public int getTextureEntry(int meta) {
        return 53;
    }

    public boolean canTakeDamage(ItemStack stack, int damage) {
        return true;
    }

    public void damageItem(ItemStack stack, int damage, EntityPlayer player) {
        stack.func_77972_a(damage, (EntityLivingBase)player);
    }

    public boolean canOverrideLossChance(ItemStack stack) {
        return false;
    }

    public void onLossPrevented(EntityPlayer player, ItemStack stack) {
    }

    public boolean hasBigCost(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ISpecialWrenchable special;
        ItemStack stack = player.func_184586_b(hand);
        if (!this.canTakeDamage(stack, 1)) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof IWrenchable)) {
            return EnumActionResult.PASS;
        }
        boolean server = IC2.platform.isSimulating();
        IWrenchable wrenchBlock = (IWrenchable)state.func_177230_c();
        EnumFacing facing = wrenchBlock.getFacing(world, pos);
        if (facing != null) {
            EnumFacing newSide = side;
            if (IC2.keyboard.isAltKeyDown(player)) {
                newSide = player.func_70093_af() ? EnumFacing.func_82600_a((int)(facing.func_176745_a() + 5)) : EnumFacing.func_82600_a((int)(facing.func_176745_a() + 1));
            } else if (player.func_70093_af()) {
                newSide = side.func_176734_d();
            }
            if (newSide != facing && wrenchBlock.setFacing(world, pos, newSide, player)) {
                if (server) {
                    this.damageItem(stack, 1, player);
                } else {
                    IC2.audioManager.playOnce(player, PositionSpec.Hand, Ic2Sounds.wrenchUse, true, IC2.audioManager.defaultVolume);
                }
                return server ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
        }
        Vec3d vec = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        ISpecialWrenchable iSpecialWrenchable = special = wrenchBlock instanceof ISpecialWrenchable ? (ISpecialWrenchable)wrenchBlock : null;
        if (special != null && special.hasSpecialAction(world, pos, side, player, vec) && this.canTakeDamage(stack, 5)) {
            EnumActionResult result = special.onSpecialAction(world, pos, side, player, vec);
            if (result == EnumActionResult.FAIL) {
                return EnumActionResult.PASS;
            }
            if (result == EnumActionResult.SUCCESS) {
                this.damageItem(stack, 5, player);
                return result;
            }
        }
        if (this.canTakeDamage(stack, this.canOverrideLossChance(stack) ? 100 : 10) && wrenchBlock.wrenchCanRemove(world, pos, player) && server) {
            List<ItemStack> drops;
            double chance = special != null ? special.getWrenchSuccessRate(world, pos) : 0.85;
            boolean originalDrop = (double)world.field_73012_v.nextFloat() <= (chance *= this.applyFortune(stack, this.getModifier(stack)));
            this.damageItem(stack, 10, player);
            if (!originalDrop && this.canOverrideLossChance(stack)) {
                originalDrop = true;
                this.onLossPrevented(player, stack);
                if (this.hasBigCost(stack)) {
                    this.damageItem(stack, 200, player);
                }
            }
            if (originalDrop) {
                drops = wrenchBlock.getWrenchDrops(world, pos, state, world.func_175625_s(pos), player, 0);
                IC2.achievements.issueStat(player, "machineSaver");
            } else {
                drops = state.func_177230_c().getDrops((IBlockAccess)world, pos, state, 0);
                IC2.achievements.issueStat(player, "machineLoser");
            }
            for (ItemStack item : drops) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
            }
            world.func_175698_g(pos);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public double getModifier(ItemStack stack) {
        return 1.0;
    }

    public double applyFortune(ItemStack stack, double base) {
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        for (int i = 0; i < fortune; ++i) {
            base += base * 0.03;
        }
        return base;
    }

    @Override
    public boolean isWrench(ItemStack stack) {
        return true;
    }
}

