/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.item.IItemReactorPlanStorage;
import ic2.core.IC2;
import ic2.core.block.machine.low.logic.crafter.CraftingRecipe;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMemoryStick
extends ItemIC2
implements IItemReactorPlanStorage,
ICustomItemCameraTransform {
    public ItemMemoryStick() {
        this.func_77625_d(1);
        this.setTranslationKey(Ic2ItemLang.memoryStick);
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> ctrlList = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlList.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlList.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.usbReset));
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public boolean isPlanStorage(ItemStack stack) {
        return true;
    }

    @Override
    public boolean setSetup(ItemStack stack, String setup) {
        if (this.hasSetup(stack)) {
            return false;
        }
        StackUtil.getOrCreateNbtData(stack).func_74778_a("PlanID", setup);
        return true;
    }

    @Override
    public void setPlanName(ItemStack stack, String setup) {
        stack.func_151001_c(setup);
    }

    @Override
    public boolean hasSetup(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74764_b("PlanID");
    }

    @Override
    public String getSetup(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74779_i("PlanID");
    }

    @Override
    public int getTextureEntry(int meta) {
        return 60;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.keyboard.isAltKeyDown(playerIn)) {
            stack.func_77982_d(null);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public static void saveRecipe(ItemStack stack, int index, CraftingRecipe recipe) {
        NBTTagCompound nbt = new NBTTagCompound();
        recipe.writeToNBT(nbt);
        StackUtil.getOrCreateNbtData(stack).func_74782_a("Recipe_" + index, (NBTBase)nbt);
    }

    public static void deleteRecipe(ItemStack stack, int index) {
        StackUtil.getNbtData(stack).func_82580_o("Recipe_" + index);
    }

    public static CraftingRecipe loadRecipe(ItemStack stack, int index) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("Recipe_" + index)) {
            CraftingRecipe recipe = new CraftingRecipe();
            recipe.readFromNBT(nbt.func_74775_l("Recipe_" + index));
            return recipe;
        }
        return null;
    }
}

