/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.item.IEUReader;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.block.personal.base.misc.IPersonalBlock;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.util.misc.StackUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemDebug
extends ItemIC2
implements IEUReader {
    private static String[] modes = new String[]{"Interfaces and Fields", "Tile Data"};

    public ItemDebug() {
        this.setTranslationKey(Ic2ItemLang.debugItem);
        this.func_77627_a(false);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 17;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af() && IC2.platform.isSimulating()) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            int mode = nbt.func_74762_e("Mode") + 1;
            if (mode >= modes.length) {
                mode = 0;
            }
            nbt.func_74768_a("Mode", mode);
            IC2.platform.messagePlayer(playerIn, "Debug Mode: " + modes[mode]);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        switch (StackUtil.getNbtData(player.func_184586_b(hand)).func_74762_e("Mode")) {
            case 0: {
                IBlockState state = world.func_180495_p(pos);
                TileEntity tile = world.func_175625_s(pos);
                String plat = IC2.platform.isRendering() ? "client" : (IC2.platform.isSimulating() ? "sp" : "server");
                String message = state.func_177230_c() != Blocks.field_150350_a ? "[" + plat + "] id: " + state.func_177230_c() + " name: " + state.func_177230_c().func_149739_a() + " te: " + tile : "[" + plat + "] id: " + state.func_177230_c() + " name: null te: " + tile;
                IC2.platform.messagePlayer(player, message);
                System.out.println(message);
                if (tile != null) {
                    message = "[" + plat + "] interfaces:";
                    Class<?> c = tile.getClass();
                    do {
                        for (Class<?> i : c.getInterfaces()) {
                            message = message + " " + i.getName();
                        }
                    } while ((c = c.getSuperclass()) != null);
                    IC2.platform.messagePlayer(player, message);
                    System.out.println(message);
                }
                if (state.func_177230_c() != Blocks.field_150350_a) {
                    System.out.println("block fields:");
                    ItemDebug.dumpObjectFields(state.func_177230_c());
                }
                if (tile == null) break;
                System.out.println("tile entity fields:");
                ItemDebug.dumpObjectFields(tile);
                break;
            }
            case 1: {
                if (!IC2.platform.isSimulating()) {
                    return EnumActionResult.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof TileEntityBlock) {
                    TileEntityBlock te = (TileEntityBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "Block: Active=" + te.getActive() + " Facing=" + te.getFacing());
                }
                if (tileEntity instanceof TileEntityGeneratorBase) {
                    TileEntityGeneratorBase te2 = (TileEntityGeneratorBase)tileEntity;
                    IC2.platform.messagePlayer(player, "BaseGen: Fuel=" + te2.fuel + " Storage=" + te2.storage);
                }
                if (tileEntity instanceof TileEntityElecMachine) {
                    TileEntityElecMachine te3 = (TileEntityElecMachine)tileEntity;
                    IC2.platform.messagePlayer(player, "ElecMachine: Energy=" + te3.energy);
                }
                if (tileEntity instanceof IEnergyStorage) {
                    IEnergyStorage te4 = (IEnergyStorage)tileEntity;
                    IC2.platform.messagePlayer(player, "EnergyStorage: Stored=" + te4.getStored());
                }
                if (tileEntity instanceof IReactor) {
                    IReactor te5 = (IReactor)tileEntity;
                    IC2.platform.messagePlayer(player, "Reactor: Heat=" + te5.getHeat() + " MaxHeat=" + te5.getMaxHeat() + " HEM=" + te5.getHeatEffectModifier() + " Output=" + te5.getReactorEnergyOutput());
                }
                if (tileEntity instanceof IPersonalBlock) {
                    IPersonalBlock te6 = (IPersonalBlock)tileEntity;
                    IC2.platform.messagePlayer(player, "PersonalBlock: CanAccess=" + te6.canAccess(player.func_110124_au()));
                }
                if (!(tileEntity instanceof TileEntityCrop)) break;
                TileEntityCrop te7 = (TileEntityCrop)tileEntity;
                IC2.platform.messagePlayer(player, "PersonalBlock: Crop=" + te7.getCrop() + " Size=" + te7.getCurrentSize() + " Growth=" + te7.getStatGrowth() + " Gain=" + te7.getStatGain() + " Resistance=" + te7.getStatResistance() + " Nutrients=" + te7.getTerrainNutrients() + " Water=" + te7.getTerrainHumidity() + " GrowthPoints=" + te7.getGrowthPoints());
                break;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private static void dumpObjectFields(Object o) {
        Class<?> fieldDeclaringClass = o.getClass();
        do {
            Field[] fields;
            for (Field field : fields = fieldDeclaringClass.getDeclaredFields()) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    System.out.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: " + field.get(o));
                }
                catch (IllegalAccessException e) {
                    System.out.println("name: " + fieldDeclaringClass.getName() + "." + field.getName() + " type: " + field.getType() + " value: <can't access>");
                }
                field.setAccessible(accessible);
            }
        } while ((fieldDeclaringClass = fieldDeclaringClass.getSuperclass()) != null);
    }

    @Override
    public boolean isEUReader(ItemStack stack) {
        return true;
    }
}

