/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.render.model;

import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class JetpackModel
extends BaseModel {
    JetpackModel other;
    boolean gui;
    ItemWithMeta armor;
    List<BakedQuad> quads = new ArrayList<BakedQuad>();

    public JetpackModel(ItemWithMeta meta, TextureAtlasSprite sprite) {
        this(sprite);
        this.armor = meta;
    }

    public JetpackModel(TextureAtlasSprite sprite) {
        super(Ic2Models.getItemTransforms());
        this.setParticalTexture(sprite);
    }

    @Override
    public void init() {
        ItemModelMesher mesher;
        TextureAtlasSprite sprite = this.func_177554_e();
        if (this.armor != null && (mesher = this.getMesher()) != null) {
            IBakedModel model = mesher.func_178089_a(this.armor.toStack());
            this.quads.addAll(ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false).func_188616_a(null, null, 0L));
            this.setParticalTexture(model.func_177554_e());
        }
        this.quads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(this.getCamera().get((Object)ItemCameraTransforms.TransformType.GUI))));
        this.gui = false;
        this.other = new JetpackModel(this.func_177554_e());
        this.other.gui = true;
        this.other.other = this;
        for (BakedQuad quad : this.quads) {
            if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
            this.other.quads.add(quad);
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null && side == null) {
            return this.quads;
        }
        return this.getEmptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair pair = PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI && !this.gui && pair.getRight() == null) {
            return Pair.of((Object)((Object)this.other), null);
        }
        if (cameraTransformType != ItemCameraTransforms.TransformType.GUI && this.gui) {
            return Pair.of((Object)((Object)this.other), (Object)pair.getRight());
        }
        return pair;
    }

    private ItemModelMesher getMesher() {
        RenderItem item = Minecraft.func_71410_x().func_175599_af();
        if (item == null) {
            return null;
        }
        return item.func_175037_a();
    }
}

