/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ic2.api.classic.crops.ClassicBaseSeed;
import ic2.api.classic.recipe.crafting.IAdvRecipe;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.api.classic.recipe.crafting.IRecipeObject;
import ic2.api.classic.recipe.crafting.RecipeInputFluid;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.crop.misc.RecipeInputCrop;
import ic2.core.block.machine.recipes.entries.RecipeInputDamaged;
import ic2.core.block.machine.recipes.managers.RecipeManager;
import ic2.core.item.recipe.AdvRecipe;
import ic2.core.item.recipe.AdvShapelessRecipe;
import ic2.core.item.recipe.entry.InvertedRecipeInput;
import ic2.core.item.recipe.entry.RecipeEntryDye;
import ic2.core.item.recipe.entry.RecipeInputAll;
import ic2.core.item.recipe.entry.RecipeInputArray;
import ic2.core.item.recipe.entry.RecipeInputCombined;
import ic2.core.item.recipe.entry.RecipeInputElectricItem;
import ic2.core.item.recipe.entry.RecipeInputIgnoreNBT;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AdvRecipeBase
extends IForgeRegistryEntry.Impl<IRecipe>
implements IAdvRecipe,
IRecipe {
    private static boolean ignore = false;
    public static JsonObject obj = new JsonObject();
    static Set<String> recipeIDs = new LinkedHashSet<String>();
    static Map<Class<?>, Function<Object, Object>> hashFunctions = new HashMap();
    protected boolean hidden;
    protected ItemStack output;
    protected ICraftingRecipeList.IRecipeModifier modifier;
    protected List<IRecipeObject> objects = new ArrayList<IRecipeObject>();
    protected NonNullList<Ingredient> ingredients = null;
    protected String recipeID;
    static Set<ResourceLocation> duplicates = new HashSet<ResourceLocation>();

    public static String getRecipeID(List<Object> inputs, List<Object> outputs, String baseID) {
        ArrayList<Object> hashable = new ArrayList<Object>();
        for (Object obj : inputs) {
            AdvRecipeBase.addHash(hashable, obj);
        }
        for (Object obj : outputs) {
            AdvRecipeBase.addHash(hashable, obj);
        }
        return baseID + "_" + Arrays.hashCode(hashable.toArray(new Object[hashable.size()]));
    }

    private static void addHash(List<Object> hashable, Object toHash) {
        if (toHash == null) {
            return;
        }
        if (!(toHash instanceof IRecipeInput) || !AdvRecipeBase.handleRecipeEntry((IRecipeInput)toHash, hashable)) {
            if (toHash instanceof Ingredient) {
                for (ItemStack stack : ((Ingredient)toHash).func_193365_a()) {
                    AdvRecipeBase.addHash(hashable, stack);
                }
            } else if (toHash instanceof ItemStack) {
                ItemStack stack = (ItemStack)toHash;
                hashable.add(Arrays.hashCode(new Object[]{stack.func_77973_b().getRegistryName(), stack.func_77960_j(), stack.func_77978_p()}));
            } else if (toHash instanceof FluidStack) {
                FluidStack stack = (FluidStack)toHash;
                hashable.add(Arrays.hashCode(new Object[]{stack.getFluid().getUnlocalizedName(), stack.tag}));
            } else if (toHash instanceof IForgeRegistryEntry) {
                hashable.add(((IForgeRegistryEntry)toHash).getRegistryName());
            } else if (toHash instanceof String) {
                hashable.add(toHash);
            } else {
                Function<Object, Object> function = hashFunctions.get(toHash.getClass());
                if (function != null) {
                    hashable.add(function.apply(toHash));
                }
            }
        }
    }

    public static void registerHashFunction(Class<?> clz, Function<Object, Object> function) {
        hashFunctions.put(clz, function);
    }

    private static boolean handleRecipeEntry(IRecipeInput entry, List<Object> toHash) {
        if (entry instanceof RecipeInputItemStack) {
            RecipeInputItemStack recipe = (RecipeInputItemStack)entry;
            toHash.add(Arrays.hashCode(new Object[]{recipe.input.func_77973_b().getRegistryName(), recipe.input.func_77960_j(), recipe.input.func_77978_p()}));
            return true;
        }
        if (entry instanceof RecipeEntryDye) {
            toHash.add("Dye");
            return true;
        }
        if (entry instanceof RecipeInputAll) {
            for (IRecipeInput subEntry : ((RecipeInputAll)entry).inputs) {
                AdvRecipeBase.handleRecipeEntry(subEntry, toHash);
            }
            return true;
        }
        if (entry instanceof RecipeInputArray) {
            for (ItemStack input : ((RecipeInputArray)entry).list) {
                toHash.add(Arrays.hashCode(new Object[]{input.func_77973_b().getRegistryName(), input.func_77960_j(), input.func_77978_p()}));
            }
            return true;
        }
        if (entry instanceof RecipeInputCombined) {
            for (IRecipeInput subEntry : ((RecipeInputCombined)entry).inputs) {
                AdvRecipeBase.handleRecipeEntry(subEntry, toHash);
            }
            return true;
        }
        if (entry instanceof RecipeInputElectricItem) {
            toHash.add(Arrays.hashCode(new Object[]{((RecipeInputElectricItem)entry).item.func_77973_b().getRegistryName(), ((RecipeInputElectricItem)entry).item.func_77960_j(), ((RecipeInputElectricItem)entry).item.func_77978_p()}));
            return true;
        }
        if (entry instanceof RecipeInputIgnoreNBT) {
            toHash.add(Arrays.hashCode(new Object[]{((RecipeInputIgnoreNBT)entry).item.func_77973_b().getRegistryName(), ((RecipeInputIgnoreNBT)entry).item.func_77960_j(), ((RecipeInputIgnoreNBT)entry).item.func_77978_p()}));
            return true;
        }
        if (entry instanceof RecipeInputDamaged) {
            toHash.add(((RecipeInputDamaged)entry).type.getRegistryName());
            return true;
        }
        if (entry instanceof RecipeInputFluid) {
            toHash.add(Arrays.hashCode(new Object[]{((RecipeInputFluid)entry).fluid.getUnlocalizedName(), ((RecipeInputFluid)entry).fluid.tag}));
            return true;
        }
        if (entry instanceof RecipeInputCrop) {
            ClassicBaseSeed crop = ((RecipeInputCrop)entry).seed;
            toHash.add(Arrays.hashCode(new Object[]{crop.crop.getTranslationKey(), crop.statResistance, crop.statGrowth, crop.statGain, crop.size}));
            return true;
        }
        if (entry instanceof RecipeInputOreDict) {
            toHash.add(((RecipeInputOreDict)entry).getOreDictEntry());
            return true;
        }
        if (entry instanceof InvertedRecipeInput) {
            AdvRecipeBase.handleRecipeEntry(((InvertedRecipeInput)entry).input, toHash);
            return true;
        }
        return false;
    }

    @Override
    public String getRecipeID() {
        return this.recipeID;
    }

    public NonNullList<Ingredient> func_192400_c() {
        block4: {
            if (this.ingredients != null) break block4;
            this.ingredients = this.buildList();
            if (this.getRecipeType() == IAdvRecipe.RecipeType.Shaped) {
                for (IRecipeObject rec : this.objects) {
                    this.ingredients.set(rec.getSlot(), (Object)Ingredient.func_193369_a((ItemStack[])rec.getItems().toArray(new ItemStack[0])));
                }
            } else {
                for (IRecipeObject rec : this.objects) {
                    this.ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])rec.getItems().toArray(new ItemStack[0])));
                }
            }
        }
        return this.ingredients;
    }

    public abstract NonNullList<Ingredient> buildList();

    public static <T extends AdvRecipeBase> T registerRecipe(T recipe) {
        if (ignore) {
            ForgeRegistries.RECIPES.register(recipe);
            return recipe;
        }
        if (obj.has(recipe.recipeID) && !obj.get(recipe.recipeID).getAsBoolean()) {
            FMLLog.getLogger().info("Recipe: " + recipe.getRegistryName() + " did not get added");
            return recipe;
        }
        if (duplicates.contains(recipe.getRegistryName())) {
            FMLLog.log.info("Duplicates: " + recipe.getRegistryName());
        }
        duplicates.add(recipe.getRegistryName());
        obj.addProperty(recipe.recipeID, Boolean.valueOf(true));
        ForgeRegistries.RECIPES.register(recipe);
        return recipe;
    }

    public static <T extends AdvRecipeBase> T overrideRecipe(T recipe) {
        ((ForgeRegistry)ForgeRegistries.RECIPES).remove(new ResourceLocation("ic2", recipe.getRecipeID()));
        duplicates.remove(new ResourceLocation("ic2", recipe.getRecipeID()));
        return AdvRecipeBase.registerRecipe(recipe);
    }

    protected IRecipe setRegistryNameFixed(String resourcePath) {
        super.setRegistryName(Loader.instance().activeModContainer().getModId(), resourcePath);
        return this;
    }

    public ItemStack func_77571_b() {
        if (this.modifier != null) {
            return this.modifier.getOutput(this.output.func_77946_l(), true);
        }
        return this.output.func_77946_l();
    }

    @Override
    public boolean isInvisible() {
        return this.hidden;
    }

    public boolean func_192399_d() {
        return this.hidden;
    }

    public String func_193358_e() {
        return new ResourceLocation("ic2", this.func_77571_b().func_82833_r()).toString();
    }

    @Override
    public List<IRecipeObject> getRecipeInput() {
        return new ArrayList<IRecipeObject>(this.objects);
    }

    public static void loadRecipes(JsonObject obj) {
        if (obj.size() == 0) {
            return;
        }
        ignore = true;
        RecipeManager.convert(obj.get("recipes"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                try {
                    AdvRecipeBase.loadRecipe(t);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ignore = false;
    }

    static void loadRecipe(JsonObject value) {
        String type = value.get("recipeType").getAsString();
        if (type.equalsIgnoreCase("shaped")) {
            ItemStack output = RecipeManager.createStack(value.getAsJsonObject("output"));
            if (output.func_190926_b()) {
                FMLLog.log.info("Recipe output is invalid: " + value.getAsJsonArray("output"));
                return;
            }
            final ArrayList<Boolean> allStuff = new ArrayList<Boolean>();
            allStuff.add(obj.has("hidden") ? obj.get("hidden").getAsBoolean() : false);
            AdvRecipeBase.convert(value.get("pattern"), new Consumer<JsonPrimitive>(){

                @Override
                public void accept(JsonPrimitive t) {
                    if (t.isString()) {
                        allStuff.add(t.getAsString());
                    }
                }
            });
            final LinkedHashMap inputs = new LinkedHashMap();
            RecipeManager.convert(value.get("inputs"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    String id = t.get("inputType").getAsString();
                    Character type = Character.valueOf(t.get("patternID").getAsCharacter());
                    if (id.equalsIgnoreCase("ore")) {
                        int amount = t.has("amount") ? t.get("amount").getAsInt() : 1;
                        inputs.put(type, new RecipeInputOreDict(t.get("oreID").getAsString(), amount));
                    } else if (id.equalsIgnoreCase("fluid")) {
                        Fluid fluid = FluidRegistry.getFluid((String)t.get("fluidID").getAsString());
                        if (fluid == null) {
                            FMLLog.log.info("FluidID is Invalid: " + t.get("fluidID"));
                            return;
                        }
                        int amount = t.has("fluidAmount") ? t.get("fluidAmount").getAsInt() : 1000;
                        inputs.put(type, new RecipeInputFluid(new FluidStack(fluid, amount)));
                    } else if (id.equalsIgnoreCase("item")) {
                        ItemStack stack = RecipeManager.createStack(t);
                        if (stack.func_190926_b()) {
                            FMLLog.log.info("Input is Invalid: " + t);
                            return;
                        }
                        if (stack.func_77973_b() instanceof IElectricItem) {
                            inputs.put(type, new RecipeInputElectricItem(stack.func_77946_l()));
                        } else {
                            inputs.put(type, new RecipeInputItemStack(stack.func_77946_l()));
                        }
                    } else if (id.equalsIgnoreCase("itemList")) {
                        final ArrayList<IRecipeInput> subInputs = new ArrayList<IRecipeInput>();
                        RecipeManager.convert(t.get("items"), new Consumer<JsonObject>(){

                            @Override
                            public void accept(JsonObject t) {
                                ItemStack stack = RecipeManager.createStack(t);
                                if (stack.func_190926_b()) {
                                    FMLLog.log.info("Input is Invalid: " + t);
                                    return;
                                }
                                if (stack.func_77973_b() instanceof IElectricItem) {
                                    subInputs.add(new RecipeInputElectricItem(stack.func_77946_l()));
                                } else {
                                    subInputs.add(new RecipeInputItemStack(stack.func_77946_l()));
                                }
                            }
                        });
                        inputs.put(type, new RecipeInputCombined(subInputs));
                    }
                }
            });
            for (Map.Entry entry : inputs.entrySet()) {
                allStuff.add((Boolean)entry.getKey());
                allStuff.add((Boolean)entry.getValue());
            }
            AdvRecipe.addAndGet(output, allStuff.toArray());
        } else if (type.equalsIgnoreCase("shapeless")) {
            ItemStack output = RecipeManager.createStack(value.getAsJsonObject("output"));
            if (output.func_190926_b()) {
                FMLLog.log.info("Recipe output is invalid: " + value.getAsJsonArray("output"));
                return;
            }
            final ArrayList<Boolean> inputs = new ArrayList<Boolean>();
            inputs.add(obj.has("hidden") ? obj.get("hidden").getAsBoolean() : false);
            RecipeManager.convert(value.get("inputs"), new Consumer<JsonObject>(){

                @Override
                public void accept(JsonObject t) {
                    String id = t.get("inputType").getAsString();
                    if (id.equalsIgnoreCase("ore")) {
                        int amount = t.has("amount") ? t.get("amount").getAsInt() : 1;
                        inputs.add(new RecipeInputOreDict(t.get("oreID").getAsString(), amount));
                    } else if (id.equalsIgnoreCase("fluid")) {
                        Fluid fluid = FluidRegistry.getFluid((String)t.get("fluidID").getAsString());
                        if (fluid == null) {
                            FMLLog.log.info("FluidID is Invalid: " + t.get("fluidID"));
                            return;
                        }
                        int amount = t.has("fluidAmount") ? t.get("fluidAmount").getAsInt() : 1000;
                        inputs.add(new RecipeInputFluid(new FluidStack(fluid, amount)));
                    } else if (id.equalsIgnoreCase("item")) {
                        ItemStack stack = RecipeManager.createStack(t);
                        if (stack.func_190926_b()) {
                            FMLLog.log.info("Input is Invalid: " + t);
                            return;
                        }
                        if (stack.func_77973_b() instanceof IElectricItem) {
                            inputs.add(new RecipeInputElectricItem(stack.func_77946_l()));
                        } else {
                            inputs.add(new RecipeInputItemStack(stack.func_77946_l()));
                        }
                    } else if (id.equalsIgnoreCase("itemList")) {
                        final ArrayList<IRecipeInput> subInputs = new ArrayList<IRecipeInput>();
                        RecipeManager.convert(t.get("items"), new Consumer<JsonObject>(){

                            @Override
                            public void accept(JsonObject t) {
                                ItemStack stack = RecipeManager.createStack(t);
                                if (stack.func_190926_b()) {
                                    FMLLog.log.info("Input is Invalid: " + t);
                                    return;
                                }
                                if (stack.func_77973_b() instanceof IElectricItem) {
                                    subInputs.add(new RecipeInputElectricItem(stack.func_77946_l()));
                                } else {
                                    subInputs.add(new RecipeInputItemStack(stack.func_77946_l()));
                                }
                            }
                        });
                        inputs.add(new RecipeInputCombined(subInputs));
                    }
                }
            });
            AdvShapelessRecipe.addAndGet(output, inputs.toArray());
        }
    }

    static void convert(JsonElement element, Consumer<JsonPrimitive> receiver) {
        if (element == null) {
            return;
        }
        if (element.isJsonPrimitive()) {
            receiver.accept(element.getAsJsonPrimitive());
        } else if (element.isJsonArray()) {
            for (JsonElement entry : element.getAsJsonArray()) {
                if (!entry.isJsonPrimitive()) continue;
                receiver.accept(entry.getAsJsonPrimitive());
            }
        }
    }
}

