/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;

public class ItemReactorVentSpread
extends ItemIC2
implements ISteamReactorComponent,
IReactorPlannerComponent {
    public ItemReactorVentSpread() {
        this.setTranslationKey(Ic2ItemLang.spreadVent);
        this.func_77625_d(1);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 4;
    }

    @Override
    public String getSheet(int meta) {
        return "i3";
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        if (heatrun) {
            this.cool(reactor, x - 1, y);
            this.cool(reactor, x + 1, y);
            this.cool(reactor, x, y - 1);
            this.cool(reactor, x, y + 1);
        }
    }

    @Override
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return 0.0f;
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        this.processChamber(yourStack, reactor, x, y, heatrun);
    }

    private void cool(IReactor reactor, int x, int y) {
        IReactorComponent comp;
        ItemStack stack = reactor.getItemAt(x, y);
        if (stack.func_77973_b() instanceof IReactorComponent && (comp = (IReactorComponent)stack.func_77973_b()).canStoreHeat(stack, reactor, x, y)) {
            comp.alterHeat(stack, reactor, x, y, -4);
        }
    }

    @Override
    public ItemStack[] getSubParts() {
        return null;
    }

    @Override
    public boolean hasSubParts() {
        return false;
    }

    @Override
    public ItemStack getReactorPart() {
        return new ItemStack((Item)this);
    }

    @Override
    public short getID(ItemStack stack) {
        return 26;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.VentSpread;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.PartCooling) {
            return new NBTTagInt(4);
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return stat == IReactorPlannerComponent.ReactorComponentStat.PartCooling;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.PartCooling) {
            int sides = 0;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                IReactorComponent comp;
                int newY;
                int newX = x + facing.func_82601_c();
                ItemStack other = reactor.getItemAt(newX, newY = y + facing.func_82599_e());
                if (other == null || !(other.func_77973_b() instanceof IReactorComponent) || !(comp = (IReactorComponent)other.func_77973_b()).canStoreHeat(other, reactor, x, y)) continue;
                ++sides;
            }
            return new NBTTagInt(4 * sides);
        }
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

