/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.core.IC2;
import ic2.core.entity.boat.EntityCarbonBoat;
import ic2.core.entity.boat.EntityElectricBoat;
import ic2.core.entity.boat.EntityRubberBoat;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIC2Boat
extends ItemIC2
implements IBootable {
    public ItemIC2Boat() {
        this.setTranslationKey(Ic2ItemLang.boatItem);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 82 + meta;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.boatCarbon;
            }
            case 1: {
                return Ic2ItemLang.boatRubber;
            }
            case 2: {
                return Ic2ItemLang.boatRubberBroken;
            }
            case 3: {
                return Ic2ItemLang.boatElectric;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        if (stack.func_77960_j() == 3) {
            List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
            ctrlTip.add(Ic2InfoLang.whileInBoat.getLocalized());
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(3), Ic2InfoLang.accessTheBoatInventory));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(7), Ic2InfoLang.gainBoatForwardThrust));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(8), Ic2InfoLang.gainBoatBackwardsThrust));
            ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.resetEngineThrust));
        }
    }

    @Override
    public void onLoad() {
        Ic2Items.boatCarbon = new ItemStack((Item)this, 1, 0);
        Ic2Items.boatRubber = new ItemStack((Item)this, 1, 1);
        Ic2Items.boatRubberBroken = new ItemStack((Item)this, 1, 2);
        Ic2Items.boatElectric = new ItemStack((Item)this, 1, 3);
    }

    public static Entity createBoat(World world, Vec3d vec, int meta) {
        switch (meta) {
            case 0: {
                return new EntityCarbonBoat(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case 1: {
                return new EntityRubberBoat(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case 3: {
                return new EntityElectricBoat(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
        }
        return null;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        float f8;
        float f6;
        double d3;
        float f5;
        ItemStack stack = playerIn.func_184586_b(handIn);
        float f = 1.0f;
        float f1 = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C) * f;
        float f2 = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B) * f;
        double d0 = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * (double)f;
        double d1 = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * (double)f + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * (double)f;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180))));
        Vec3d vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)))) * d3, (double)(f8 = f3 * f5) * d3);
        RayTraceResult raytraceresult = worldIn.func_72901_a(vec3d, vec3d1, true);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        Vec3d vec3d2 = playerIn.func_70676_i(f);
        boolean flag = false;
        List list = worldIn.func_72839_b((Entity)playerIn, playerIn.func_174813_aQ().func_72321_a(vec3d2.field_72450_a * d3, vec3d2.field_72448_b * d3, vec3d2.field_72449_c * d3).func_186662_g(1.0));
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisalignedbb;
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L() || !(axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y())).func_72318_a(vec3d)) continue;
            flag = true;
        }
        if (flag) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        Block block = worldIn.func_180495_p(raytraceresult.func_178782_a()).func_177230_c();
        boolean flag1 = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
        Entity entityboat = ItemIC2Boat.createBoat(worldIn, raytraceresult.field_72307_f, stack.func_77960_j());
        if (entityboat == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        entityboat.field_70177_z = playerIn.field_70177_z;
        if (!worldIn.func_184144_a(entityboat, entityboat.func_174813_aQ().func_186662_g(-0.1)).isEmpty()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d(entityboat);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

