/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.core.inventory.base.IC2ItemInventory;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.item.inv.container.ContainerCraftingUpgrade;
import ic2.core.item.upgrades.subtypes.machine.CraftingUpgrade;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class InventoryCraftingUpgrade
extends IC2ItemInventory {
    Map<ItemStack, List<Integer>> slots;
    public boolean valid;
    public boolean oreDicted;
    public String outputName = "";

    public InventoryCraftingUpgrade(EntityPlayer player, IHandHeldInventory inv, ItemStack item) {
        super(player, inv, item);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCraftingUpgrade(this, this.getID(), player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.valid = nbt.func_74767_n("isValid");
        this.oreDicted = nbt.func_74767_n("oreDict");
        this.outputName = nbt.func_74779_i("Output");
        this.slots = new LinkedHashMap<ItemStack, List<Integer>>();
        NBTTagList list = nbt.func_150295_c("RecipeItems", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            ItemStack stack = new ItemStack(data);
            if (stack.func_190926_b()) continue;
            ArrayList<Integer> slotList = new ArrayList<Integer>();
            NBTTagList slotData = data.func_150295_c("Slots", 3);
            for (int x = 0; x < slotData.func_74745_c(); ++x) {
                slotList.add(slotData.func_186858_c(x));
            }
            this.slots.put(stack, slotList);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ItemStack, List<Integer>> entry : this.slots.entrySet()) {
            NBTTagCompound data = entry.getKey().func_77955_b(new NBTTagCompound());
            NBTTagList slotList = new NBTTagList();
            for (Integer slot : entry.getValue()) {
                slotList.func_74742_a((NBTBase)new NBTTagInt(slot.intValue()));
            }
            data.func_74782_a("Slots", (NBTBase)slotList);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("RecipeItems", (NBTBase)list);
        nbt.func_74757_a("isValid", this.valid);
        nbt.func_74757_a("oreDict", this.oreDicted);
        nbt.func_74778_a("Output", this.outputName);
    }

    public void valdiateRecipe(EntityPlayer player) {
        int i;
        this.valid = false;
        this.slots.clear();
        InventoryCrafting crafting = new InventoryCrafting(CraftingUpgrade.nullContainer, 3, 3);
        for (i = 0; i < 9; ++i) {
            crafting.func_70299_a(i, ((ItemStack)this.inventory.get(i)).func_77946_l());
        }
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        this.inventory.set(9, (Object)CraftingManager.func_82787_a((InventoryCrafting)crafting, (World)player.field_70170_p));
        ForgeHooks.setCraftingPlayer(null);
        if (((ItemStack)this.inventory.get(9)).func_190926_b()) {
            this.outputName = "";
            return;
        }
        for (i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b()) continue;
            this.getSlot(stack).add(i);
        }
        this.outputName = ((ItemStack)this.inventory.get(9)).func_82833_r();
        this.valid = true;
    }

    public List<Integer> getSlot(ItemStack stack) {
        for (Map.Entry<ItemStack, List<Integer>> entry : this.slots.entrySet()) {
            if (!StackUtil.isStackEqual(entry.getKey(), stack, false, false) || entry.getKey().func_190916_E() != stack.func_190916_E()) continue;
            return entry.getValue();
        }
        ArrayList<Integer> set = new ArrayList<Integer>();
        this.slots.put(stack, set);
        return set;
    }

    public void onJEIData(NBTTagCompound nbt) {
        this.valid = false;
        this.slots.clear();
        this.outputName = "";
        for (int i = 0; i < 10; ++i) {
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
        NBTTagList list = nbt.func_150295_c("RecipeItems", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            ItemStack stack = new ItemStack(data);
            if (stack.func_190926_b()) continue;
            NBTTagList slotData = data.func_150295_c("Slots", 3);
            for (int x = 0; x < slotData.func_74745_c(); ++x) {
                this.inventory.set(slotData.func_186858_c(x), (Object)stack.func_77946_l());
            }
        }
    }
}

