/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.base;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.BasicElectricItem;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.ITexturedItem;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBatteryBase
extends BasicElectricItem
implements ITexturedItem,
IAdvancedTexturedItem {
    private ModelResourceLocation[] locations = new ModelResourceLocation[5];
    boolean rightclick;
    int index;

    protected ItemBatteryBase(int par1) {
        this.index = par1;
    }

    public ItemBatteryBase(int index, int max, int trans, int tier) {
        this(index);
        this.maxCharge = max;
        this.tier = tier;
        this.transferLimit = trans;
    }

    public ItemBatteryBase(int index, int max, int trans, int tier, boolean pro) {
        this(index, max, trans, tier);
        this.provider = pro;
    }

    public ItemBatteryBase setRightClick() {
        this.rightclick = true;
        return this;
    }

    @Override
    public List<ItemStack> getValidItemVariants() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack item = new ItemStack((Item)this);
            item.func_77964_b(i);
            list.add(item);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(ItemStack item) {
        int meta = item.func_77952_i();
        if (meta == 0) {
            return Ic2Icons.getTextures("i1")[this.index + 4];
        }
        if (meta == 1) {
            return Ic2Icons.getTextures("i1")[this.index + 3];
        }
        if (meta == 2) {
            return Ic2Icons.getTextures("i1")[this.index + 2];
        }
        if (meta == 3) {
            return Ic2Icons.getTextures("i1")[this.index + 1];
        }
        return Ic2Icons.getTextures("i1")[this.index];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        int damage = stack.func_77952_i();
        ResourceLocation location = this.getRegistryName();
        String name = stack.func_77977_a();
        this.locations[damage] = new ModelResourceLocation(location.func_110624_b() + name.substring(name.indexOf(".") + 1) + damage, "inventory");
        return this.locations[damage];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (ElectricItem.manager.getCharge(stack) == 0.0) {
            return this.locations[4];
        }
        if (damage <= 1) {
            return this.locations[0];
        }
        if (damage <= 8) {
            return this.locations[1];
        }
        if (damage <= 14) {
            return this.locations[2];
        }
        if (damage <= 20) {
            return this.locations[3];
        }
        return this.locations[4];
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (this.rightclick) {
            playerIn.func_184598_c(handIn);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public int func_77626_a(ItemStack stack) {
        return 20000;
    }

    public void onUsingTick(ItemStack itemStackIn, EntityLivingBase entity, int count) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        EnumHand playerHand = player.func_184600_cs();
        boolean charged = false;
        if (playerHand == EnumHand.OFF_HAND) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof IElectricItem)) continue;
                IElectricItem item = (IElectricItem)stack.func_77973_b();
                double transfer = ElectricItem.manager.discharge(itemStackIn, 2 * this.transferLimit, item.getTier(itemStackIn), true, false, true);
                transfer = ElectricItem.manager.charge(stack, transfer, this.tier, true, false);
                ElectricItem.manager.discharge(itemStackIn, transfer, item.getTier(itemStackIn), true, false, false);
                if (transfer != 0.0) {
                    charged = true;
                    continue;
                }
                break;
            }
        } else {
            ItemStack stack;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack2;
                if (i == player.field_71071_by.field_70461_c || !((stack2 = player.field_71071_by.func_70301_a(i)).func_77973_b() instanceof IElectricItem)) continue;
                IElectricItem item = (IElectricItem)stack2.func_77973_b();
                double transfer = ElectricItem.manager.discharge(itemStackIn, 2 * this.transferLimit, item.getTier(itemStackIn), true, false, true);
                transfer = ElectricItem.manager.charge(stack2, transfer, this.tier, true, false);
                ElectricItem.manager.discharge(itemStackIn, transfer, item.getTier(itemStackIn), true, false, false);
                if (transfer == 0.0) break;
                charged = true;
            }
            if (!charged && (stack = player.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)stack.func_77973_b();
                double transfer = ElectricItem.manager.discharge(itemStackIn, 2 * this.transferLimit, item.getTier(itemStackIn), true, false, true);
                transfer = ElectricItem.manager.charge(stack, transfer, this.tier, true, false);
                ElectricItem.manager.discharge(itemStackIn, transfer, item.getTier(itemStackIn), true, false, false);
                if (transfer > 0.0) {
                    charged = true;
                }
            }
        }
        if (!charged) {
            player.func_184602_cy();
        }
        IC2.platform.updatePlayerUsingItem(player, itemStackIn);
    }

    public boolean wantsToPlay(ItemStack stack) {
        return false;
    }

    public ResourceLocation createSound(ItemStack stack) {
        return null;
    }

    @Override
    public List<Integer> getValidVariants() {
        return new ArrayList<Integer>();
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        if (this.rightclick) {
            List<String> ctrlList = sortedTooltip.get((Object)ToolTipType.Ctrl);
            ctrlList.add(Ic2Lang.onItemRightClick.getLocalized());
            ctrlList.add(TextFormatting.UNDERLINE + Ic2InfoLang.chargesItems.getLocalized());
        }
    }
}

