/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.base;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.IFilter;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.render.model.JetpackModel;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.ICustomModeledItem;
import ic2.core.util.helpers.ItemWithMeta;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemArmorElectricJetpackBase
extends ItemArmorJetpackBase
implements IDamagelessElectricItem,
ICustomModeledItem,
IElectricTool,
IAdvancedTexturedItem {
    public static List<ItemStack> jetpackArmors = new ArrayList<ItemStack>();
    public static List<IFilter> jetpackFilters = new ArrayList<IFilter>();
    Map<ItemWithMeta, ModelResourceLocation> locations = new HashMap<ItemWithMeta, ModelResourceLocation>();

    public ItemArmorElectricJetpackBase(int index, EntityEquipmentSlot equipmentSlotIn) {
        super(index, equipmentSlotIn);
        this.func_77656_e(0);
    }

    public static void addArmor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        jetpackArmors.add(stack);
        jetpackFilters.add(new BasicItemFilter(stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> altTip = sortedTooltip.get((Object)ToolTipType.Alt);
        ItemStack armor = ItemArmorElectricJetpackBase.getArmor(stack);
        if (!armor.func_190926_b()) {
            int max = armor.func_77958_k();
            altTip.add(Ic2InfoLang.jetpackArmor.getLocalizedFormatted(armor.func_82833_r()));
            altTip.add(Ic2InfoLang.jetpackArmorDurability.getLocalizedFormatted(max - armor.func_77952_i(), armor.func_77958_k()));
            altTip.add("");
        }
        if (ItemArmorElectricJetpackBase.isArmorRecipe(stack)) {
            tooltip.add(Ic2InfoLang.jetpackRecipe.getLocalized());
        }
    }

    public static void addJetpackArmor(ItemStack jetpack, ItemStack armor) {
        if (armor.func_190926_b()) {
            NBTTagCompound data = StackUtil.getOrCreateNbtData(jetpack);
            data.func_82580_o("JetpackArmor");
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        armor.func_77955_b(data);
        jetpack.func_77983_a("JetpackArmor", (NBTBase)data);
    }

    public static ItemStack getArmor(ItemStack jetpack) {
        NBTTagCompound data = StackUtil.getNbtData(jetpack);
        if (data.func_74764_b("JetpackArmor")) {
            return new ItemStack(data.func_74775_l("JetpackArmor"));
        }
        return ItemStack.field_190927_a;
    }

    public static void addMarkArmorRecipe(ItemStack jetpack, boolean data) {
        StackUtil.getOrCreateNbtData(jetpack).func_74757_a("Recipe", data);
    }

    public static boolean isArmorRecipe(ItemStack jetpack) {
        return StackUtil.getNbtData(jetpack).func_74767_n("Recipe");
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        ItemStack stack = ItemArmorElectricJetpackBase.getArmor(armor);
        if (!stack.func_190926_b()) {
            ItemArmor item = (ItemArmor)stack.func_77973_b();
            return new ISpecialArmor.ArmorProperties(0, (double)item.field_77879_b, armor.func_77958_k() + 1 - stack.func_77952_i());
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        ItemStack stack = ItemArmorElectricJetpackBase.getArmor(armor);
        if (!stack.func_190926_b()) {
            ItemArmor item = (ItemArmor)stack.func_77973_b();
            return item.field_77879_b;
        }
        return super.getArmorDisplay(player, armor, slot);
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ItemStack armor = ItemArmorElectricJetpackBase.getArmor(stack);
        if (!armor.func_190926_b()) {
            armor.func_77972_a(damage, entity);
            if (armor.func_190926_b()) {
                ItemArmorElectricJetpackBase.addJetpackArmor(stack, ItemStack.field_190927_a);
            }
        }
        super.damageArmor(entity, stack, source, damage, slot);
    }

    @Override
    public List<Integer> getValidVariants() {
        return new ArrayList<Integer>();
    }

    @Override
    public List<ItemStack> getValidItemTypes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)this, 1, 0));
        for (int i = 0; i < jetpackArmors.size(); ++i) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            ItemArmorElectricJetpackBase.addJetpackArmor(stack, jetpackArmors.get(i));
            list.add(stack);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromItem(ItemStack item) {
        ItemStack stack = ItemArmorElectricJetpackBase.getArmor(item);
        if (stack.func_190926_b()) {
            return new JetpackModel(Ic2Icons.getTextures("i2")[this.index]);
        }
        return new JetpackModel(new ItemWithMeta(stack), Ic2Icons.getTextures("i2")[45]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        ResourceLocation resource = this.getRegistryName();
        String name = this.func_77667_c(stack);
        ItemStack armor = ItemArmorElectricJetpackBase.getArmor(stack);
        if (armor.func_190926_b()) {
            ModelResourceLocation location = new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1), "inventory");
            this.locations.put(null, location);
            return location;
        }
        String armorName = armor.func_77977_a();
        ItemWithMeta meta = new ItemWithMeta(armor);
        ModelResourceLocation location = new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1) + ":" + armorName.substring(armorName.indexOf(".") + 1), "inventory");
        this.locations.put(meta, location);
        return location;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        ItemStack armor = ItemArmorElectricJetpackBase.getArmor(stack);
        if (GuiScreen.func_146272_n() || armor.func_190926_b()) {
            return this.locations.get(null);
        }
        return this.locations.get(new ItemWithMeta(armor));
    }

    @Override
    public int getMaxFuel(ItemStack stack) {
        return (int)this.getMaxCharge(stack);
    }

    @Override
    public int getFuel(ItemStack stack) {
        return (int)ElectricItem.manager.getCharge(stack);
    }

    @Override
    public void useEnergy(EntityPlayer player, ItemStack stack, int amount) {
        boolean did = ElectricItem.manager.use(stack, amount, (EntityLivingBase)player);
        if (!did) {
            ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        ItemStack full = new ItemStack((Item)this);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        subItems.add((Object)empty);
        subItems.add((Object)full);
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        switch (this.field_77881_a) {
            case CHEST: {
                return EnumEnchantmentType.ARMOR_CHEST;
            }
            case FEET: {
                return EnumEnchantmentType.ARMOR_FEET;
            }
            case HEAD: {
                return EnumEnchantmentType.ARMOR_HEAD;
            }
            case LEGS: {
                return EnumEnchantmentType.ARMOR_LEGS;
            }
        }
        return EnumEnchantmentType.ARMOR;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return false;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_92091_k || ench == Enchantments.field_185296_A;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }
}

