/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.buttons;

import com.google.common.base.Strings;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.IToolTipButton;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.components.special.DisplayLocaleComp;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class IconButton
extends IC2Button
implements IToolTipButton {
    List<LocaleComp> locales = new LinkedList<LocaleComp>();
    ItemStack item;
    boolean iconOnly = false;

    public IconButton(int buttonId, int x, int y, int widthIn, int heightIn) {
        super(buttonId, x, y, widthIn, heightIn, "");
    }

    public IconButton(int buttonId, int x, int y, int widthIn, int heightIn, LocaleComp text) {
        super(buttonId, x, y, widthIn, heightIn, text);
    }

    public IconButton setItemStack(ItemStack stack) {
        this.item = stack.func_77946_l();
        return this;
    }

    public IconButton addComponents(List<LocaleComp> comps) {
        this.locales.addAll(comps);
        this.setTextVisiblity(false);
        return this;
    }

    public IconButton addText(LocaleComp comp) {
        this.locales.add(comp);
        this.setTextVisiblity(false);
        return this;
    }

    public IconButton addText(String name) {
        return this.addText(new DisplayLocaleComp(name));
    }

    public IconButton clearText() {
        this.locales.clear();
        this.setTextVisiblity(true);
        return this;
    }

    public IconButton setIconOnly() {
        this.iconOnly = true;
        return this;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.iconOnly) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        }
        if (this.item != null) {
            mc.func_175599_af().func_175042_a(this.item, this.field_146128_h + 2, this.field_146129_i + 2);
        }
    }

    @Override
    public void addToolTips(GuiIC2 gui, int mouseX, int mouseY, List<String> toolTip) {
        if (this.field_146123_n && this.locales.size() > 0) {
            String text = this.getName().getLocalized();
            if (!Strings.isNullOrEmpty((String)text)) {
                toolTip.add(text);
            }
            for (LocaleComp comp : this.locales) {
                toolTip.add(comp.getLocalized());
            }
        }
    }
}

