/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.fluid;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.core.util.obj.ITankListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class IC2Tank
extends FluidTank
implements INetworkFieldData {
    List<ITankListener> listeners = new ArrayList<ITankListener>();

    public IC2Tank(int capacity) {
        super(capacity);
    }

    public IC2Tank(Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
    }

    public IC2Tank(FluidStack fluidStack, int capacity) {
        super(fluidStack, capacity);
    }

    public void addListener(ITankListener list) {
        this.listeners.add(list);
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.capacity = buffer.readInt();
        this.fluid = buffer.readBoolean() ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.readNBTData()) : null;
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeInt(this.capacity);
        buffer.writeBoolean(this.fluid != null);
        if (this.fluid != null) {
            buffer.writeNBTData(this.fluid.writeToNBT(new NBTTagCompound()));
        }
    }

    protected void onContentsChanged() {
        for (ITankListener list : this.listeners) {
            list.onTankChanged((IFluidTank)this);
        }
    }

    public boolean hasRoom() {
        return this.getFluidAmount() < this.getCapacity();
    }
}

