/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.item.ICutterItem;
import ic2.core.block.base.BlockCommonContainer;
import ic2.core.block.render.model.MultiPartLuminatorModel;
import ic2.core.block.wiring.tile.TileEntityMultipartLuminator;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMultipartLuminator
extends BlockCommonContainer
implements ICustomModeledBlock,
IBootable {
    public BlockMultipartLuminator() {
        super(Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
        this.func_149752_b(0.5f);
        this.setTranslationKey(Ic2BlockLang.luminatorMultipart);
        this.setHarvestLevel("pickaxe", 1);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMultipartLuminator();
    }

    @Override
    public IBlockState getDefaultBlockState() {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMultipartLuminator) {
            return ((TileEntityMultipartLuminator)tile).getActive() ? 15 : 0;
        }
        return 0;
    }

    public int func_149750_m(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMultipartLuminator) {
            TileEntityMultipartLuminator lumi = (TileEntityMultipartLuminator)tile;
            if (side == null || !lumi.hasSide(side.func_176745_a())) {
                lumi.setWireColor(IEnergyConductorColored.WireColor.fromColor(color));
            } else {
                lumi.setSideColor(side, IEnergyConductorColored.WireColor.fromColor(color));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        if (stack != null && stack.func_77973_b() instanceof ICutterItem) {
            ((ICutterItem)stack.func_77973_b()).cutInsulationFrom(stack, worldIn, pos, playerIn);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    public void onLoad() {
        Ic2States.luminatorMultipart = this.func_176223_P();
        Ic2Items.luminatorMultipart = new ItemStack((Block)this, 1, 0);
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        return Arrays.asList(this.func_176223_P());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        return new MultiPartLuminatorModel();
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return true;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMultipartLuminator) {
            return new BlockStateContainerIC2.IC2BlockState(state, ((TileEntityMultipartLuminator)tile).getEntry());
        }
        return super.getExtendedState(state, world, pos);
    }
}

