/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.tile;

import ic2.core.block.personal.base.TileEntityPersonalStorageBase;
import ic2.core.block.personal.base.misc.IPersonalBlock;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.container.ContainerPersonalChest;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.misc.IHasInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IItemContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityPersonalChest
extends TileEntityPersonalStorageBase
implements IPersonalBlock,
IItemContainer {
    public PersonalInventory inv = new PersonalInventory(54);
    public IHasInventoryWrapper handler = new IHasInventoryWrapper(this.inv).setDissableModify().setDissableExtraction().setDissableInserting();
    public int numUsingPlayers;
    public float lidAngle;
    public float prevLidAngle;

    @Override
    public boolean allowExtraction() {
        return true;
    }

    @Override
    public IPersonalInventory getInventory(UUID user) {
        if (this.canAccess(user)) {
            return this.inv;
        }
        return null;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        if (this.canAccess(player.func_110124_au())) {
            this.openInventory();
            return new ContainerPersonalChest(player.field_71071_by, this, false);
        }
        if (this.allowView) {
            this.openInventory();
            return new ContainerPersonalChest(player.field_71071_by, this, true);
        }
        return null;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        if (this.canAccess(player.func_110124_au()) || this.allowView) {
            return GuiComponentContainer.class;
        }
        return null;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        this.closeInventory();
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.personalChest;
    }

    private void openInventory() {
        ++this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, this.numUsingPlayers);
    }

    private void closeInventory() {
        if (this.numUsingPlayers > 0) {
            --this.numUsingPlayers;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, this.numUsingPlayers);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0) {
            this.numUsingPlayers = type;
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt.func_74775_l("Inventory"));
        this.handler.setExtractingState(this.allowExtraction);
        this.handler.setInsertingState(this.allowInjection);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inv.writeToNBT(this.getTag(nbt, "Inventory"));
        return nbt;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.allowInjection || this.allowExtraction;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.allowInjection || this.allowExtraction) {
                return (T)this.handler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void onChange(int type) {
        if (type == 1) {
            this.inv.clear();
        }
        if (type == 2) {
            this.handler.setInsertingState(this.allowInjection);
        } else if (type == 3) {
            this.handler.setExtractingState(this.allowExtraction);
        }
    }

    @Override
    public void loadFromState(int state) {
        super.loadFromState(state);
        this.handler.loadFromState(state);
    }

    @Override
    public List<ItemStack> getDrops() {
        NBTTagCompound nbt;
        int value;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack personal = Ic2Items.personalSafe.func_77946_l();
        if (!this.inv.isInvEmpty()) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.inv.writeToNBT(nbt2);
            personal.func_77983_a("ItemsStored", (NBTBase)nbt2);
        }
        if ((value = this.handler.getValue()) != 0) {
            nbt = StackUtil.getOrCreateNbtData(personal);
            nbt.func_74774_a("Value", (byte)value);
        }
        if (this.allowView) {
            nbt = StackUtil.getOrCreateNbtData(personal);
            nbt.func_74757_a("Allow", this.allowView);
        }
        if (this.allowTeam) {
            nbt = StackUtil.getOrCreateNbtData(personal);
            nbt.func_74757_a("Team", this.allowTeam);
        }
        list.add(personal);
        return list;
    }
}

