/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.texture;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.core.block.base.util.texture.ICopyEntry;
import ic2.core.platform.registry.Ic2States;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorCopyEntry
implements ICopyEntry,
INetworkFieldData {
    EnumFacing facing;
    IEnergyConductorColored.WireColor color;
    IBlockState state;

    public ColorCopyEntry(int dir) {
        this.facing = EnumFacing.func_82600_a((int)dir);
    }

    public void clear() {
        this.color = null;
        this.state = null;
    }

    public void set(IEnergyConductorColored.WireColor wire) {
        this.color = wire;
        this.state = ColorCopyEntry.getStateFromColor(wire);
    }

    @Override
    public Block getBlock() {
        return Blocks.field_150350_a;
    }

    @Override
    public int[] getColorMultiplier() {
        return new int[]{-1};
    }

    @Override
    public IBlockState getModelState() {
        return this.state;
    }

    @Override
    public IBlockState getRenderState() {
        return this.state;
    }

    @Override
    public EnumFacing getSide() {
        return this.facing;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getQuads() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(this.state).func_188616_a(this.state, this.facing, 0L);
    }

    private static IBlockState getStateFromColor(IEnergyConductorColored.WireColor wire) {
        if (wire == null || wire == IEnergyConductorColored.WireColor.Blank) {
            return Ic2States.constructionFoam;
        }
        int meta = wire.ordinal() - 1;
        return Ic2States.cfWallBlack.func_177230_c().func_176203_a(meta);
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.facing = EnumFacing.func_82600_a((int)buffer.readByte());
        byte colorID = buffer.readByte();
        IEnergyConductorColored.WireColor wireColor = this.color = colorID == -1 ? null : IEnergyConductorColored.WireColor.valueLookup[colorID];
        if (this.color == null) {
            return;
        }
        this.state = ColorCopyEntry.getStateFromColor(this.color);
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeByte((byte)this.facing.func_176745_a());
        buffer.writeByte((byte)(this.color == null ? -1 : this.color.ordinal()));
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("Side"));
        int colorID = nbt.func_74762_e("Color");
        IEnergyConductorColored.WireColor wireColor = this.color = colorID == -1 ? null : IEnergyConductorColored.WireColor.values()[colorID];
        if (this.color == null) {
            return;
        }
        this.state = ColorCopyEntry.getStateFromColor(this.color);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("Side", (byte)this.facing.ordinal());
        nbt.func_74774_a("Color", this.color == null ? (byte)-1 : (byte)this.color.ordinal());
    }

    public static ColorCopyEntry[] createArray(int size) {
        ColorCopyEntry[] array = new ColorCopyEntry[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new ColorCopyEntry(i);
        }
        return array;
    }

    public IEnergyConductorColored.WireColor getColor() {
        return this.color;
    }
}

