/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base;

import ic2.api.classic.tile.IAdvancedComparatorProvider;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.ISpecialWrenchable;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.IHasComparator;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.IItemContainer;
import ic2.core.util.obj.IRedstoneProvider;
import ic2.core.util.obj.IRedstoneTile;
import ic2.core.util.obj.IWrenchableTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class BlockCommonContainer
extends BlockContainer
implements ISpecialWrenchable,
ILocaleBlock,
IAdvancedComparatorProvider {
    LocaleComp comp;
    private ThreadLocal<TileEntity> localTile = new ThreadLocal();

    public BlockCommonContainer(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.getDefaultBlockState());
        this.comp = Ic2Lang.nullKey;
    }

    public abstract IBlockState getDefaultBlockState();

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    @Override
    public LocaleComp getName() {
        return this.comp;
    }

    public Block setTranslationKey(LocaleComp name) {
        this.comp = name;
        return super.func_149663_c(name.getUnlocalized());
    }

    public Block func_149663_c(String name) {
        this.comp = new LangComponentHolder.LocaleBlockComp("tile." + name);
        return super.func_149663_c(name);
    }

    public TileEntity getLocalTile() {
        return this.localTile.get();
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        this.localTile.set(te);
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.localTile.set(null);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityBlock) {
            ((TileEntityBlock)tile).onBlockBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tileEntity = tile = this.getLocalTile() == null ? world.func_175625_s(pos) : this.getLocalTile();
        if (tile != null) {
            if (tile instanceof IWorldNameable) {
                IWorldNameable name = (IWorldNameable)tile;
                if (name.func_145818_k_()) {
                    Item item;
                    int count = this.quantityDropped(state, fortune, RANDOM);
                    if (count > 0 && (item = this.func_180660_a(state, RANDOM, fortune)) != null) {
                        list.add(new ItemStack(item, count, this.func_180651_a(state)).func_151001_c(name.func_70005_c_()));
                    }
                } else {
                    list.addAll(super.getDrops(world, pos, state, fortune));
                }
            } else {
                list.addAll(super.getDrops(world, pos, state, fortune));
            }
            if (tile instanceof IItemContainer) {
                list.addAll(((IItemContainer)tile).getDrops());
            }
        } else {
            list.addAll(super.getDrops(world, pos, state, fortune));
        }
        return list;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IClickable click;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof IClickable && (click = (IClickable)te).hasRightClick() && click.onRightClick(playerIn, hand, facing, FMLCommonHandler.instance().getEffectiveSide())) {
            return true;
        }
        if (playerIn.func_70093_af()) {
            return false;
        }
        return te instanceof IHasGui && (IC2.platform.isRendering() || IC2.platform.launchGui(playerIn, (IHasGui)te, hand));
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof IClickable)) {
            return;
        }
        IClickable click = (IClickable)tile;
        if (click.hasLeftClick()) {
            click.onLeftClick(playerIn, FMLCommonHandler.instance().getEffectiveSide());
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (IC2.platform.isRendering()) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityBlock)) {
            return;
        }
        TileEntityBlock block = (TileEntityBlock)tile;
        block.setFacing(this.getDefaultPlacementFacing(state, placer));
        if (stack.func_82837_s()) {
            block.setCustomName(stack.func_82833_r());
        }
    }

    public EnumFacing getDefaultPlacementFacing(IBlockState state, EntityLivingBase placer) {
        if (placer == null) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.func_176733_a((double)placer.field_70177_z).func_176734_d();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IWorldNameable name;
        TileEntity tile = world.func_175625_s(target.func_178782_a());
        if (tile instanceof IWorldNameable && (name = (IWorldNameable)tile).func_145818_k_()) {
            ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
            stack.func_151001_c(name.func_70005_c_());
            return stack;
        }
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        IWorldNameable name;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IWorldNameable && (name = (IWorldNameable)tile).func_145818_k_()) {
            ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
            stack.func_151001_c(name.func_70005_c_());
            return stack;
        }
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    @Override
    public EnumFacing getFacing(World world, BlockPos pos) {
        IWrenchableTile block = (IWrenchableTile)world.func_175625_s(pos);
        return block != null ? block.getFacing() : null;
    }

    @Override
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        IWrenchableTile block = (IWrenchableTile)world.func_175625_s(pos);
        if (block != null && block.canSetFacing(player, newDirection)) {
            block.setFacing(newDirection);
            return true;
        }
        return false;
    }

    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getCommonPower(blockState, blockAccess, pos, side);
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getCommonPower(blockState, blockAccess, pos, side);
    }

    public int getCommonPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof IRedstoneProvider) {
            return ((IRedstoneProvider)tile).getRedstoneStrenght(side);
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            if (tile instanceof IMachine) {
                return ((IMachine)tile).isRedstoneSensitive();
            }
            if (tile instanceof IRedstoneTile) {
                return ((IRedstoneTile)tile).canConnectToRedstone(side);
            }
        }
        return super.canConnectRedstone(state, world, pos, side);
    }

    @Override
    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof IWrenchableTile)) {
            return false;
        }
        return ((IWrenchableTile)tile).canRemoveBlock(player);
    }

    @Override
    public double getWrenchSuccessRate(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof IWrenchableTile)) {
            return 0.0;
        }
        return ((IWrenchableTile)tile).getWrenchDropRate();
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        IWorldNameable name;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack result = new ItemStack((Block)this, 1, this.func_176201_c(state));
        if (te instanceof IWorldNameable && (name = (IWorldNameable)te).func_145818_k_()) {
            result.func_151001_c(name.func_70005_c_());
        }
        items.add(result);
        if (te instanceof IItemContainer) {
            items.addAll(((IItemContainer)te).getDrops());
        }
        return items;
    }

    @Override
    public boolean hasSpecialAction(World world, BlockPos pos, EnumFacing dir, EntityPlayer player, Vec3d vec) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof IWrenchableTile)) {
            return false;
        }
        return ((IWrenchableTile)tile).hasSpecialAction(player, dir, vec);
    }

    @Override
    public EnumActionResult onSpecialAction(World world, BlockPos pos, EnumFacing dir, EntityPlayer player, Vec3d vec) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof IWrenchableTile)) {
            return EnumActionResult.PASS;
        }
        return ((IWrenchableTile)tile).doSpecialAction(player, dir, vec);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile;
        if (this.needsRedstoneUpdates(this.func_176201_c(state)) && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityBlock) {
            ((TileEntityBlock)tile).onBlockUpdate(blockIn);
        }
    }

    public boolean needsRedstoneUpdates(int meta) {
        return true;
    }

    @Deprecated
    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        ComparatorManager manager;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IHasComparator && (manager = ((IHasComparator)tile).getManager()) != null) {
            boolean isStatic = manager.shouldBeStatic(null);
            boolean isInverted = manager.isInverted(null);
            int value = manager.getValue(null);
            if (isInverted) {
                value = 15 - value;
            }
            if (isStatic) {
                return value > 0 ? 15 : 0;
            }
            return value;
        }
        return 0;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        InventoryHandler handler;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHasHandler && (handler = ((IHasHandler)tile).getHandler()) != null && handler.isBlockingStrong()) {
            return false;
        }
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    @Override
    public int getComparatorOutput(IBlockState state, World world, BlockPos pos, EnumFacing side) {
        ComparatorManager manager;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHasComparator && (manager = ((IHasComparator)tile).getManager()) != null) {
            boolean isStatic = manager.shouldBeStatic(side);
            boolean isInverted = manager.isInverted(side);
            int value = manager.getValue(side);
            if (isInverted) {
                value = 15 - value;
            }
            if (isStatic) {
                return value > 0 ? 15 : 0;
            }
            return value;
        }
        return 0;
    }
}

