/*
 * Decompiled with CFR 0.152.
 */
package net.eve0415.ifpatcher.patch;

import com.buuz135.industrial.config.CustomConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.eve0415.ifpatcher.IFPatcher;
import net.eve0415.ifpatcher.Patch;
import net.minecraftforge.common.config.Configuration;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchMobImprisonmentTool
extends Patch {
    public static Boolean blacklistBosses;
    public static List<String> blacklistedEntities;

    public PatchMobImprisonmentTool(byte[] inputClass) {
        super(inputClass);
    }

    public static void configuration(Configuration config) {
        blacklistBosses = CustomConfiguration.config.getBoolean("blacklistBosses", "general.mob_imprisonment_tool", true, "Should bosses be blacklisted from being captured with the tool? entityBlackList will have priority over this setting.");
        blacklistedEntities = Arrays.asList(CustomConfiguration.config.getStringList("entityBlacklist", "general.mob_imprisonment_tool", new String[]{"minecraft:wither"}, "A list of entities blacklist from being captured with the tool. Format: 'modid:entityid', 'modid:*', 'modid:chicken*'"));
    }

    public static boolean isBlacklisted(String entity) {
        for (String blacklistedEntity : blacklistedEntities) {
            Pattern pattern;
            if (!blacklistedEntity.contains("*") && blacklistedEntity.equals(entity)) {
                return true;
            }
            if (!blacklistedEntity.contains("*") || !(pattern = Pattern.compile(blacklistedEntity.replace("*", ".*"))).matcher(entity).matches()) continue;
            return true;
        }
        IFPatcher.LOGGER.info("Boss blacklisted: {}", (Object)blacklistBosses);
        return false;
    }

    @Override
    protected boolean patch() {
        MethodNode configuration = new MethodNode(1, "configuration", "(Lnet/minecraftforge/common/config/Configuration;)V", null, null);
        configuration.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        configuration.instructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "configuration", "(Lnet/minecraftforge/common/config/Configuration;)V", false));
        configuration.instructions.add((AbstractInsnNode)new InsnNode(177));
        this.classNode.methods.add(configuration);
        IFPatcher.LOGGER.info("MobImprisonmentTool configuration system added");
        InsnList isBlacklisted = this.findMethod((String)"isBlacklisted").instructions;
        isBlacklisted.clear();
        isBlacklisted.add((AbstractInsnNode)new VarInsnNode(25, 1));
        isBlacklisted.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "isBlacklisted", "(Ljava/lang/String;)Z", false));
        isBlacklisted.add((AbstractInsnNode)new InsnNode(172));
        IFPatcher.LOGGER.info("Implement MobImprisonmentTool blacklist");
        InsnList itemInteractionForEntity = this.findMethod((String)this.getName((String)"itemInteractionForEntity", (String)"func_111207_a")).instructions;
        for (AbstractInsnNode insnNode : itemInteractionForEntity) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.name.equals(this.getName("isNonBoss", "func_184222_aU"))) continue;
            itemInteractionForEntity.remove(methodInsnNode.getPrevious());
            itemInteractionForEntity.remove(methodInsnNode.getNext());
            itemInteractionForEntity.remove((AbstractInsnNode)methodInsnNode);
            IFPatcher.LOGGER.info("Remove default blacklist of boss");
            break;
        }
        itemInteractionForEntity = this.findMethod((String)this.getName((String)"itemInteractionForEntity", (String)"func_111207_a")).instructions;
        for (AbstractInsnNode insnNode : itemInteractionForEntity) {
            if (insnNode.getOpcode() != 187) continue;
            InsnList blacklistBosses = new InsnList();
            LabelNode label = new LabelNode();
            blacklistBosses.add((AbstractInsnNode)new FieldInsnNode(178, this.hookClass, "blacklistBosses", "Ljava/lang/Boolean;"));
            blacklistBosses.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
            blacklistBosses.add((AbstractInsnNode)new JumpInsnNode(153, label));
            blacklistBosses.add((AbstractInsnNode)new VarInsnNode(25, 3));
            blacklistBosses.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/EntityLivingBase", this.getName("isNonBoss", "func_184222_aU"), "()Z", false));
            blacklistBosses.add((AbstractInsnNode)new JumpInsnNode(154, label));
            blacklistBosses.add((AbstractInsnNode)new InsnNode(3));
            blacklistBosses.add((AbstractInsnNode)new InsnNode(172));
            blacklistBosses.add((AbstractInsnNode)label);
            itemInteractionForEntity.insertBefore(insnNode, blacklistBosses);
            IFPatcher.LOGGER.info("Add condition check for boss blacklist");
            break;
        }
        return true;
    }
}

