/*
 * Decompiled with CFR 0.152.
 */
package net.eve0415.ifpatcher;

import net.eve0415.ifpatcher.IFPatcher;
import net.eve0415.ifpatcher.patch.PatchCommonProxy;
import net.eve0415.ifpatcher.patch.PatchConveyorInsertionUpgrade;
import net.eve0415.ifpatcher.patch.PatchCustomConfiguration;
import net.eve0415.ifpatcher.patch.PatchItemStackUtils;
import net.eve0415.ifpatcher.patch.PatchLaserBase;
import net.eve0415.ifpatcher.patch.PatchMobImprisonmentTool;
import net.eve0415.ifpatcher.patch.PatchPlantSower;
import net.eve0415.ifpatcher.patch.PatchPotionBrewer;
import net.eve0415.ifpatcher.patch.PatchPump;
import net.minecraft.launchwrapper.IClassTransformer;

public class Transformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        switch (transformedName) {
            case "com.buuz135.industrial.proxy.CommonProxy": {
                IFPatcher.LOGGER.info("Patching CommonProxy from IF");
                return new PatchCommonProxy(bytes).apply();
            }
            case "com.buuz135.industrial.proxy.block.upgrade.ConveyorInsertionUpgrade": {
                IFPatcher.LOGGER.info("Patching Conveyor Insertion Upgrade from IF");
                return new PatchConveyorInsertionUpgrade(bytes).apply();
            }
            case "com.buuz135.industrial.config.CustomConfiguration": {
                IFPatcher.LOGGER.info("Patching CustomConfiguration from IF");
                return new PatchCustomConfiguration(bytes).apply();
            }
            case "com.buuz135.industrial.utils.ItemStackUtils": {
                IFPatcher.LOGGER.info("Patching ItemStackUtils from IF");
                return new PatchItemStackUtils(bytes).apply();
            }
            case "com.buuz135.industrial.tile.world.LaserBaseTile": {
                IFPatcher.LOGGER.info("Patching Laser Base from IF");
                return new PatchLaserBase(bytes).apply();
            }
            case "com.buuz135.industrial.item.MobImprisonmentToolItem": {
                IFPatcher.LOGGER.info("Patching Mob Imprisonment Tool from IF");
                return new PatchMobImprisonmentTool(bytes).apply();
            }
            case "com.buuz135.industrial.tile.agriculture.CropSowerTile": {
                IFPatcher.LOGGER.info("Patching Plant Sower from IF");
                return new PatchPlantSower(bytes).apply();
            }
            case "com.buuz135.industrial.tile.magic.PotionEnervatorTile": {
                IFPatcher.LOGGER.info("Patching Potion Brewer from IF");
                return new PatchPotionBrewer(bytes).apply();
            }
            case "com.buuz135.industrial.tile.world.FluidPumpTile": {
                IFPatcher.LOGGER.info("Patching Fluid Pump from IF");
                return new PatchPump(bytes).apply();
            }
        }
        return bytes;
    }
}

