/*
 * Decompiled with CFR 0.152.
 */
package net.eve0415.ifpatcher;

import net.eve0415.ifpatcher.IFPatcher;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class Patch
implements Opcodes {
    protected final String hookClass = this.getName(this.getClass()).replaceAll("patch/(.+)Patch", "hook/$1Hook");
    protected final ClassNode classNode;
    final byte[] inputClassBytes;

    public Patch(byte[] inputClass) {
        this.inputClassBytes = inputClass;
        ClassReader classReader = new ClassReader(inputClass);
        this.classNode = new ClassNode();
        classReader.accept((ClassVisitor)this.classNode, 0);
    }

    public byte[] apply() {
        if (this.patch()) {
            IFPatcher.LOGGER.info("{} succeeded", (Object)this.getClass().getSimpleName());
            return this.writeClass();
        }
        IFPatcher.LOGGER.error("{} failed", (Object)this.getClass().getSimpleName());
        return this.inputClassBytes;
    }

    protected byte[] writeClass() {
        ClassWriter classWriter = new ClassWriter(3);
        this.classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    protected abstract boolean patch();

    protected String getName(Class<?> clazz) {
        return Type.getInternalName(clazz);
    }

    protected String getName(String name, String srgName) {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? name : srgName;
    }

    protected MethodNode findMethod(String methodName) {
        for (MethodNode methodNode : this.classNode.methods) {
            if (!methodNode.name.equals(methodName)) continue;
            return methodNode;
        }
        return null;
    }
}

