/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.client.gui.TextElement;
import wanion.lib.client.gui.WElement;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.client.gui.interaction.WKeyInteraction;
import wanion.lib.client.gui.interaction.WMouseInteraction;
import wanion.lib.common.IController;
import wanion.lib.common.INBTMessage;
import wanion.lib.common.IUpdatable;
import wanion.lib.common.WContainer;
import wanion.lib.common.WTileEntity;
import wanion.lib.common.control.ControlController;
import wanion.lib.common.control.IControl;
import wanion.lib.common.field.FieldController;
import wanion.lib.common.field.IField;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.MatchingController;

@SideOnly(value=Side.CLIENT)
public abstract class WGuiContainer<T extends WTileEntity>
extends GuiContainer
implements INBTMessage {
    private final WContainer<T> wContainer;
    private final ResourceLocation guiTextureLocation;
    private final List<WElement<?>> wElements = new ArrayList();
    protected final String tileName;
    protected final String inventory;
    protected final Slot firstPlayerSlot;
    protected final TextElement tileNameTextElement;
    protected final TextElement inventoryTextElement;
    private WInteraction latestInteraction;

    public WGuiContainer(@Nonnull WContainer<T> wContainer, @Nonnull ResourceLocation guiTextureLocation) {
        this(wContainer, guiTextureLocation, 0, 0);
    }

    public WGuiContainer(@Nonnull WContainer<T> wContainer, @Nonnull ResourceLocation guiTextureLocation, int width, int height) {
        super(wContainer);
        this.firstPlayerSlot = this.field_147002_h.func_75139_a(this.field_147002_h.field_75151_b.size() - 36);
        this.wContainer = wContainer;
        this.guiTextureLocation = guiTextureLocation;
        this.tileName = I18n.func_135052_a((String)this.getContainer().getTileName(), (Object[])new Object[0]);
        this.inventory = I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]);
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.latestInteraction = new WInteraction(this, 0, 0);
        this.tileNameTextElement = this.getTileNameTextElement();
        this.addElement(this.tileNameTextElement);
        this.inventoryTextElement = this.getInventoryTextElement();
        this.addElement(this.inventoryTextElement);
    }

    public final void addElement(@Nonnull WElement<?> element) {
        this.wElements.add(element);
    }

    protected TextElement getTileNameTextElement() {
        return new TextElement(this.tileName, this, 7, 7);
    }

    protected TextElement getInventoryTextElement() {
        return new TextElement(this.inventory, this, this.firstPlayerSlot.field_75223_e - 1, this.firstPlayerSlot.field_75221_f - 11);
    }

    @Nonnull
    public WContainer<T> getContainer() {
        return this.wContainer;
    }

    @Nonnull
    public T getTile() {
        return this.wContainer.getTile();
    }

    public final <C extends IController<?, ?>> C getController(@Nonnull Class<C> aClass) {
        return ((WTileEntity)((Object)this.getTile())).getController(aClass);
    }

    @Nonnull
    public <C extends IControl<C>> C getControl(@Nonnull Class<C> cClass) {
        return (C)((IControl)((Object)this.getController(ControlController.class).get(cClass)));
    }

    @Nonnull
    public IField<?> getField(@Nonnull String fieldName) {
        return this.getController(FieldController.class).getField(fieldName);
    }

    @Nonnull
    public AbstractMatching<?> getMatching(int matchingNumber) {
        return this.getController(MatchingController.class).getMatching(matchingNumber);
    }

    @Nonnull
    public EntityPlayer getEntityPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Nonnull
    public WInteraction getLatestInteraction() {
        return this.latestInteraction;
    }

    protected final void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.guiTextureLocation);
        boolean smallGui = this.field_146999_f < 256 && this.field_147000_g < 256;
        WGuiContainer.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)(smallGui ? 256.0f : (float)Math.max(this.field_146999_f, this.field_147000_g)), (float)(smallGui ? 256.0f : (float)Math.max(this.field_146999_f, this.field_147000_g)));
        this.latestInteraction = new WInteraction(this, mouseX, mouseY);
        this.getEnabledElements().forEach(element -> element.draw(this.latestInteraction));
        this.getUpdatableElements().forEach(IUpdatable::update);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.latestInteraction = new WInteraction(this, mouseX, mouseY);
        this.getEnabledElements().forEach(element -> element.drawForeground(this.latestInteraction));
        for (GuiButton guibutton : this.field_146292_n) {
            if (!guibutton.func_146115_a()) continue;
            guibutton.func_146111_b(mouseX, mouseY);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        WKeyInteraction keyInteraction = new WKeyInteraction(this);
        if (this.interact(keyInteraction)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        WMouseInteraction mouseInteraction = new WMouseInteraction(this);
        if (this.interact(mouseInteraction)) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    private boolean interact(@Nonnull WInteraction wInteraction) {
        for (WElement<?> element : this.getInteractableElements(wInteraction)) {
            if (!wInteraction.shouldProceed()) continue;
            element.interaction(wInteraction);
        }
        return wInteraction.shouldProceed();
    }

    private Collection<WElement<?>> getEnabledElements() {
        return this.wElements.stream().filter(WElement::isEnabled).collect(Collectors.toList());
    }

    private Collection<WElement<?>> getInteractableElements(@Nonnull WInteraction wInteraction) {
        return this.wElements.stream().filter(element -> element.isEnabled() && element.canInteractWith(wInteraction)).collect(Collectors.toList());
    }

    private Collection<IUpdatable> getUpdatableElements() {
        return this.wElements.stream().filter(IUpdatable.class::isInstance).map(IUpdatable.class::cast).collect(Collectors.toList());
    }

    @Override
    public void receiveNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.wElements.stream().filter(INBTMessage.class::isInstance).forEach(element -> ((INBTMessage)((Object)element)).receiveNBT(nbtTagCompound));
    }
}

