/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark;

import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.debark.util.ItemUtils;

public class DebarkShapelessRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ItemStack log;
    private final ItemStack debarkedLog;
    private final NonNullList<Ingredient> ingredients;

    public DebarkShapelessRecipe(ItemStack log, ItemStack debarkedLog) {
        this.log = log;
        this.debarkedLog = debarkedLog;
        this.ingredients = NonNullList.func_191196_a();
        this.ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.log}));
        this.ingredients.add((Object)Ingredient.func_193368_a((Item[])new Item[]{Items.field_151053_p, Items.field_151049_t, Items.field_151036_c, Items.field_151006_E, Items.field_151056_x}));
    }

    private boolean isAxe(ItemStack stack) {
        return stack.func_77973_b().getToolClasses(stack).contains("axe");
    }

    private boolean isLog(ItemStack stack) {
        return ItemUtils.canMerge(stack, this.log);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        int logs = 0;
        int axes = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.isLog(stack)) {
                ++logs;
                continue;
            }
            if (this.isAxe(stack)) {
                ++axes;
                continue;
            }
            return false;
        }
        return logs == 1 && axes == 1;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.debarkedLog.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return this.debarkedLog.func_77946_l();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remainingItems = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_190926_b()) {
                if (this.isAxe(stack)) {
                    ItemStack newStack = stack.func_77946_l();
                    newStack.func_77964_b(newStack.func_77952_i() + 1);
                    if (newStack.func_77952_i() > newStack.func_77958_k()) {
                        remainingItems.add((Object)ItemStack.field_190927_a);
                        continue;
                    }
                    remainingItems.add((Object)newStack);
                    continue;
                }
                remainingItems.add((Object)ItemStack.field_190927_a);
                continue;
            }
            remainingItems.add((Object)ItemStack.field_190927_a);
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public boolean func_192399_d() {
        return false;
    }

    public String func_193358_e() {
        return "debark:log_debarking";
    }
}

