/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.debark;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.debark.DebarkMod;
import pl.asie.debark.old.UCWBlockAccess;

public class BlockDebarkedLog
extends BlockLog {
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)3);
    private final IBlockState[] parents;

    public BlockDebarkedLog(IBlockState[] parents) {
        this.parents = parents;
    }

    public IBlockState getParentState(int variant) {
        if (variant < 0 || variant >= this.parents.length) {
            if (DebarkMod.enableDebugLogging) {
                DebarkMod.logger.error("Mod requested parent block state for " + (Object)((Object)this) + " with invalid variant number " + variant + "!");
            }
            return this.parents[0];
        }
        return this.parents[variant];
    }

    public IBlockState getParentState(IBlockState myState) {
        return this.getParentState((Integer)myState.func_177229_b((IProperty)VARIANT));
    }

    public ItemStack getParentStack(int variant) {
        if (variant < 0 || variant >= this.parents.length) {
            if (DebarkMod.enableDebugLogging) {
                DebarkMod.logger.error("Mod requested parent item stack for " + (Object)((Object)this) + " with invalid variant number " + variant + "!");
            }
            return this.parents[0].func_177230_c().func_185473_a(null, null, this.parents[0]);
        }
        return this.parents[variant].func_177230_c().func_185473_a(null, null, this.parents[variant]);
    }

    public int getVariantCount() {
        return this.parents.length;
    }

    public String getLocalizedName(int variant) {
        return I18n.func_74837_a((String)"tile.debark.debarked.name", (Object[])new Object[]{this.getParentStack(variant).func_82833_r()});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta << 2).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLog.field_176299_a, VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.values()[meta & 3]).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta >> 2));
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT);
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)).ordinal() | (Integer)state.func_177229_b((IProperty)VARIANT) << 2;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return this.getParentStack((Integer)state.func_177229_b((IProperty)VARIANT));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.getVariantCount(); ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState parent = this.getParentState(world.func_180495_p(pos));
        return parent.func_177230_c().getFlammability((IBlockAccess)new UCWBlockAccess(world, (Map<BlockPos, IBlockState>)ImmutableMap.of((Object)pos, (Object)parent)), pos, face);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState parent = this.getParentState(world.func_180495_p(pos));
        return parent.func_177230_c().isFlammable((IBlockAccess)new UCWBlockAccess(world, (Map<BlockPos, IBlockState>)ImmutableMap.of((Object)pos, (Object)parent)), pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState parent = this.getParentState(world.func_180495_p(pos));
        return parent.func_177230_c().getFireSpreadSpeed((IBlockAccess)new UCWBlockAccess(world, (Map<BlockPos, IBlockState>)ImmutableMap.of((Object)pos, (Object)parent)), pos, face);
    }
}

