/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RayTracer {
    private static RayTracer instance = new RayTracer();
    protected RayTraceResult target = null;

    public static RayTracer instance() {
        if (instance == null) {
            instance = new RayTracer();
        }
        return instance;
    }

    public void fire(EntityLivingBase entity, double distance) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.target = this.rayTrace(entity, distance);
    }

    @Nullable
    public RayTraceResult getTarget() {
        return this.target;
    }

    @Nullable
    protected RayTraceResult rayTrace(EntityLivingBase entity, double distance) {
        Vec3d position = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (entity.func_70047_e() != 0.12f) {
            position = position.func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        }
        Vec3d look = entity.func_70040_Z();
        for (double i = 1.0; i < distance; i += 0.2) {
            Vec3d search = position.func_72441_c(look.field_72450_a * i, look.field_72448_b * i, look.field_72449_c * i);
            AxisAlignedBB searchBox = new AxisAlignedBB(search.field_72450_a - 0.1, search.field_72448_b - 0.1, search.field_72449_c - 0.1, search.field_72450_a + 0.1, search.field_72448_b + 0.1, search.field_72449_c + 0.1);
            RayTraceResult blockCheck = entity.field_70170_p.func_72901_a(new Vec3d(position.field_72450_a, position.field_72448_b, position.field_72449_c), search, false);
            if (blockCheck != null && blockCheck.field_72313_a == RayTraceResult.Type.BLOCK && position.func_72436_e(blockCheck.field_72307_f) < position.func_72436_e(search)) {
                return blockCheck;
            }
            Entity target = this.getEntity(entity, position, search, look, searchBox, 0.1);
            if (target == null) continue;
            return new RayTraceResult(target);
        }
        return null;
    }

    @Nullable
    protected Entity getEntity(EntityLivingBase base, Vec3d position, Vec3d search, Vec3d look, AxisAlignedBB searchBox, double v) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        List entityObjects = base.field_70170_p.func_72872_a(Entity.class, searchBox);
        for (Entity entity : entityObjects) {
            if (entity == null || entity == base || !entity.func_70067_L()) continue;
            entityList.add(entity);
        }
        if (entityList.size() <= 0) {
            return null;
        }
        Entity entity = null;
        if (entityList.size() > 1) {
            for (Entity e : entityList) {
                if (entity != null) {
                    Vec3d vec3d = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                    Vec3d vec3d2 = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    if (!(position.func_72436_e(vec3d) < position.func_72436_e(vec3d2))) continue;
                }
                entity = e;
            }
        } else {
            entity = (Entity)entityList.get(0);
        }
        return entity;
    }
}

