/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.computronics.reference.Config;

public class RadarUtils {
    public static Set<Map<String, Object>> getEntities(World world, BlockPos pos, AxisAlignedBB bounds, Class<? extends EntityLivingBase> eClass) {
        return RadarUtils.getEntities(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, bounds, eClass);
    }

    public static Set<Map<String, Object>> getEntities(World world, double xCoord, double yCoord, double zCoord, AxisAlignedBB bounds, Class<? extends EntityLivingBase> eClass) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        for (EntityLivingBase entity : world.func_72872_a(eClass, bounds)) {
            double dx = entity.field_70165_t - xCoord;
            double dy = entity.field_70163_u - yCoord;
            double dz = entity.field_70161_v - zCoord;
            if (!(Math.sqrt(dx * dx + dy * dy + dz * dz) < (double)Config.RADAR_RANGE)) continue;
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("name", entity.func_70005_c_());
            if (!Config.RADAR_ONLY_DISTANCE) {
                entry.put("x", (int)dx);
                entry.put("y", (int)dy);
                entry.put("z", (int)dz);
            }
            entry.put("distance", Math.sqrt(dx * dx + dy * dy + dz * dz));
            entities.add(entry);
        }
        return entities;
    }

    public static Set<Map<String, Object>> getItems(World world, BlockPos pos, AxisAlignedBB bounds, Class<? extends EntityItem> eClass) {
        return RadarUtils.getItems(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, bounds, eClass);
    }

    public static Set<Map<String, Object>> getItems(World world, double xCoord, double yCoord, double zCoord, AxisAlignedBB bounds, Class<? extends EntityItem> eClass) {
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        for (EntityItem entity : world.func_72872_a(eClass, bounds)) {
            double dx = entity.field_70165_t - xCoord;
            double dy = entity.field_70163_u - yCoord;
            double dz = entity.field_70161_v - zCoord;
            if (!(Math.sqrt(dx * dx + dy * dy + dz * dz) < (double)Config.RADAR_RANGE)) continue;
            HashMap<String, Object> entry = new HashMap<String, Object>();
            ItemStack stack = entity.func_92059_d();
            entry.put("name", Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()));
            entry.put("damage", stack.func_77952_i());
            entry.put("hasTag", stack.func_77942_o());
            entry.put("size", stack.func_190916_E());
            entry.put("label", stack.func_82833_r());
            if (!Config.RADAR_ONLY_DISTANCE) {
                entry.put("x", (int)dx);
                entry.put("y", (int)dy);
                entry.put("z", (int)dz);
            }
            entry.put("distance", Math.sqrt(dx * dx + dy * dy + dz * dz));
            entities.add(entry);
        }
        return entities;
    }
}

