/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.network.BlacklistedPeripheral;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.client.audio.ISound;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.audio.MachineSound;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.internal.IComputronicsPeripheral;
import pl.asie.lib.tile.TileMachine;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.internal.IColorable;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.driver.DeviceInfo", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.BlacklistedPeripheral", modid="opencomputers"), @Optional.Interface(iface="pl.asie.computronics.api.multiperipheral.IMultiPeripheral", modid="computercraft")})
public abstract class TileEntityPeripheralBase
extends TileMachine
implements Environment,
DeviceInfo,
IMultiPeripheral,
IComputronicsPeripheral,
BlacklistedPeripheral,
IColorable {
    protected String peripheralName;
    private Object node;
    protected CopyOnWriteArrayList<IComputerAccess> attachedComputersCC;
    protected boolean addedToNetwork = false;
    protected Map<String, String> deviceInfo;
    protected int overlayColor = this.getDefaultColor();
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    private ResourceLocation soundRes;

    public TileEntityPeripheralBase(String name) {
        this.peripheralName = name;
        if (Mods.isLoaded("opencomputers")) {
            this.initOC();
        }
        this.soundRes = TileEntityPeripheralBase.getSoundFor(this.getSoundName());
    }

    public TileEntityPeripheralBase(String name, double bufferSize) {
        this.peripheralName = name;
        if (Mods.isLoaded("opencomputers")) {
            this.initOC(bufferSize);
        }
        this.soundRes = TileEntityPeripheralBase.getSoundFor(this.getSoundName());
    }

    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Optional.Method(modid="opencomputers")
    protected void initOC(double s) {
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).withConnector(s).create());
    }

    @Optional.Method(modid="opencomputers")
    protected void initOC() {
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName, Visibility.Network).create());
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return (Node)this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void setNode(Node node) {
        this.node = node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="opencomputers")
    public boolean isPeripheralBlacklisted() {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (Mods.isLoaded("opencomputers")) {
            this.addToNetwork_OC();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K && this.hasSound()) {
            this.updateSound();
        }
    }

    @Optional.Method(modid="opencomputers")
    protected void addToNetwork_OC() {
        Computronics.opencomputers.scheduleForNetworkJoin(this);
        this.onOCNetworkCreation();
    }

    @Optional.Method(modid="opencomputers")
    public void onOCNetworkCreation() {
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (Mods.isLoaded("opencomputers")) {
            this.onChunkUnload_OC();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (Mods.isLoaded("opencomputers")) {
            this.invalidate_OC();
        }
        if (this.field_145850_b.field_72995_K && this.hasSound()) {
            this.updateSound();
        }
    }

    @Optional.Method(modid="opencomputers")
    protected void onChunkUnload_OC() {
        if (this.node() != null) {
            this.node().remove();
        }
    }

    @Optional.Method(modid="opencomputers")
    protected void invalidate_OC() {
        if (this.node() != null) {
            this.node().remove();
        }
    }

    @Optional.Method(modid="opencomputers")
    public Map<String, String> getDeviceInfo() {
        OCUtils.Device device;
        if (this.deviceInfo == null && (device = this.deviceInfo()) != null) {
            this.deviceInfo = device.deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    protected abstract OCUtils.Device deviceInfo();

    @Optional.Method(modid="opencomputers")
    public void readFromNBT_OC(NBTTagCompound nbt) {
        if (this.node() != null && this.node().host() == this) {
            this.node().load(nbt.func_74775_l("oc:node"));
        }
    }

    @Optional.Method(modid="opencomputers")
    public void writeToNBT_OC(NBTTagCompound nbt) {
        if (this.node() != null && this.node().host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node().save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    @Optional.Method(modid="computercraft")
    public String getType() {
        return this.peripheralName;
    }

    @Optional.Method(modid="computercraft")
    public void attach(IComputerAccess computer) {
        if (this.attachedComputersCC == null) {
            this.attachedComputersCC = new CopyOnWriteArrayList();
        }
        this.attachedComputersCC.add(computer);
    }

    @Optional.Method(modid="computercraft")
    public void detach(IComputerAccess computer) {
        if (this.attachedComputersCC != null) {
            this.attachedComputersCC.remove(computer);
        }
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            return tother.func_145831_w().equals(this.field_145850_b) && tother.func_174877_v().equals((Object)this.func_174877_v());
        }
        return false;
    }

    @Override
    @Optional.Method(modid="computercraft")
    public int peripheralPriority() {
        return 1;
    }

    @Override
    public int getColor() {
        return this.overlayColor;
    }

    @Override
    public int getDefaultColor() {
        return ColorUtils.Color.White.color;
    }

    @Override
    public void setColor(int color) {
        this.overlayColor = color;
        this.func_70296_d();
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound nbt) {
        super.readFromRemoteNBT(nbt);
        int oldColor = this.overlayColor;
        if (nbt.func_74764_b("computronics:color")) {
            this.overlayColor = nbt.func_74762_e("computronics:color");
        }
        if (this.overlayColor < 0) {
            this.overlayColor = this.getDefaultColor();
        }
        if (oldColor != this.overlayColor) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public NBTTagCompound writeToRemoteNBT(NBTTagCompound nbt) {
        nbt = super.writeToRemoteNBT(nbt);
        if (this.overlayColor != this.getDefaultColor()) {
            nbt.func_74768_a("computronics:color", this.overlayColor);
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("computronics:color")) {
            this.overlayColor = nbt.func_74762_e("computronics:color");
        }
        if (this.overlayColor < 0) {
            this.overlayColor = this.getDefaultColor();
        }
        if (Mods.isLoaded("opencomputers")) {
            this.readFromNBT_OC(nbt);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.overlayColor != this.getDefaultColor()) {
            nbt.func_74768_a("computronics:color", this.overlayColor);
        }
        if (Mods.isLoaded("opencomputers")) {
            this.writeToNBT_OC(nbt);
        }
        return nbt;
    }

    @Override
    public void removeFromNBTForTransfer(NBTTagCompound data) {
        super.removeFromNBTForTransfer(data);
        data.func_82580_o("oc:node");
    }

    @Nullable
    protected static ResourceLocation getSoundFor(@Nullable String sound) {
        return sound == null ? null : new ResourceLocation("computronics:" + sound);
    }

    @Nullable
    public String getSoundName() {
        return null;
    }

    public ResourceLocation getSoundRes() {
        return this.soundRes;
    }

    public boolean shouldPlaySound() {
        return false;
    }

    public boolean hasSound() {
        return this.getSoundName() != null;
    }

    public float getVolume() {
        return 1.0f;
    }

    public float getPitch() {
        return 1.0f;
    }

    public boolean shouldRepeat() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (this.hasSound()) {
            if (this.shouldPlaySound() && !this.func_145837_r()) {
                if (this.sound == null) {
                    this.sound = new MachineSound(this.getSoundRes(), this.func_174877_v(), this.getVolume(), this.getPitch(), this.shouldRepeat());
                    FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                }
            } else if (this.sound != null) {
                this.sound.endPlaying();
                this.sound = null;
            }
        }
    }
}

