/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.tis3d.module;

import java.util.HashMap;
import javax.annotation.Nullable;
import li.cil.tis3d.api.FontRendererAPI;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.util.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import pl.asie.computronics.integration.tis3d.module.ComputronicsModule;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.tile.TileTapeDrive;

public class ModuleTapeReader
extends ComputronicsModule {
    private final HashMap<String, Command> commandMap = new HashMap();
    private final Command[] COMMANDS = new Command[]{new ImmediateReturnCommand("isEnd"){

        @Override
        protected short getValue(TileTapeDrive tile) {
            return (short)(tile.isEnd() ? 1 : 0);
        }
    }, new ImmediateReturnCommand("isReady"){

        @Override
        protected short getValue(TileTapeDrive tile) {
            return (short)(tile.isReady() ? 1 : 0);
        }
    }, new ImmediateReturnCommand("getState"){

        @Override
        protected short getValue(TileTapeDrive tile) {
            return (short)tile.getEnumState().ordinal();
        }
    }, new ImmediateReturnCommand("getSize"){

        @Override
        protected short getValue(TileTapeDrive tile) {
            return (short)(tile.getSize() % 1024);
        }
    }, new ImmediateReturnCommand("getSize1024"){

        @Override
        protected short getValue(TileTapeDrive tile) {
            return (short)(tile.getSize() / 1024);
        }
    }, new SetterCommand("setSpeed"){

        @Override
        protected void setValue(TileTapeDrive tile, short val) {
            tile.setSpeed((float)val / 100.0f);
        }
    }, new SetterCommand("setVolume"){

        @Override
        protected void setValue(TileTapeDrive tile, short val) {
            tile.setVolume((float)val / 100.0f);
        }
    }, new SetterCommand("seek"){

        @Override
        protected void setValue(TileTapeDrive tile, short val) {
            tile.seek(val);
        }
    }, new SetterCommand("seek1024"){

        @Override
        protected void setValue(TileTapeDrive tile, short val) {
            tile.seek(val * 1024);
        }
    }, new ImmediateReturnCommand("read"){

        @Override
        protected short getValue(TileTapeDrive tile) {
            return (short)tile.read(true);
        }

        @Override
        protected void finishWriting(TileTapeDrive tile, Port writtenPort) {
            tile.seek(1);
            super.finishWriting(tile, writtenPort);
        }
    }, new Command("readMultiple"){
        private short byteQueue;
        {
            this.byteQueue = 0;
        }

        @Override
        protected void process(TileTapeDrive tile) {
            switch (ModuleTapeReader.this.mode) {
                case IDLE: {
                    ModuleTapeReader.this.mode = Mode.WAITING;
                    break;
                }
                case WAITING: {
                    for (Port port : Port.VALUES) {
                        Pipe receivingPipe = ModuleTapeReader.this.getCasing().getReceivingPipe(ModuleTapeReader.this.getFace(), port);
                        if (!receivingPipe.isReading()) {
                            receivingPipe.beginRead();
                        }
                        if (!receivingPipe.canTransfer()) continue;
                        this.byteQueue = receivingPipe.read();
                        if (this.byteQueue < 1) {
                            ModuleTapeReader.this.mode = Mode.IDLE;
                            ModuleTapeReader.this.command = null;
                            ModuleTapeReader.this.sendDataToClient();
                            return;
                        }
                        ModuleTapeReader.this.cancelRead();
                        ModuleTapeReader.this.mode = Mode.WRITING;
                        for (Port p : Port.VALUES) {
                            Pipe sendingPipe = ModuleTapeReader.this.getCasing().getSendingPipe(ModuleTapeReader.this.getFace(), p);
                            if (sendingPipe.isWriting()) continue;
                            sendingPipe.beginWrite((short)tile.read(true));
                        }
                        return;
                    }
                    break;
                }
            }
        }

        @Override
        protected void finishWriting(TileTapeDrive tile, Port writtenPort) {
            ModuleTapeReader.this.cancelWrite();
            this.byteQueue = (short)(this.byteQueue - 1);
            if (this.byteQueue > 0) {
                tile.seek(1);
                for (Port port : Port.VALUES) {
                    Pipe sendingPipe = ModuleTapeReader.this.getCasing().getSendingPipe(ModuleTapeReader.this.getFace(), port);
                    if (sendingPipe.isWriting()) continue;
                    sendingPipe.beginWrite((short)tile.read(true));
                }
            } else {
                tile.seek(1);
                ModuleTapeReader.this.mode = Mode.IDLE;
                ModuleTapeReader.this.command = null;
                for (Port port : Port.VALUES) {
                    Pipe receivingPipe = ModuleTapeReader.this.getCasing().getReceivingPipe(ModuleTapeReader.this.getFace(), port);
                    if (receivingPipe.isReading()) continue;
                    receivingPipe.beginRead();
                }
                ModuleTapeReader.this.sendDataToClient();
            }
        }

        @Override
        protected void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.func_74777_a("bq", this.byteQueue);
        }

        @Override
        protected void load(NBTTagCompound nbt) {
            super.load(nbt);
            if (nbt.func_74764_b("bq")) {
                this.byteQueue = nbt.func_74765_d("bq");
            }
        }
    }, new SetterCommand("write"){

        @Override
        protected void setValue(TileTapeDrive tile, short val) {
            tile.write((byte)val);
        }
    }, new NeverWritingCommand("writeMultiple"){
        private short byteQueue;
        {
            this.byteQueue = 0;
        }

        @Override
        protected void process(TileTapeDrive tile) {
            switch (ModuleTapeReader.this.mode) {
                case IDLE: {
                    ModuleTapeReader.this.mode = Mode.WAITING;
                    break;
                }
                case WAITING: {
                    for (Port port : Port.VALUES) {
                        Pipe receivingPipe = ModuleTapeReader.this.getCasing().getReceivingPipe(ModuleTapeReader.this.getFace(), port);
                        if (!receivingPipe.isReading()) {
                            receivingPipe.beginRead();
                        }
                        if (!receivingPipe.canTransfer()) continue;
                        this.byteQueue = receivingPipe.read();
                        if (this.byteQueue < 1) {
                            ModuleTapeReader.this.mode = Mode.IDLE;
                            ModuleTapeReader.this.command = null;
                            ModuleTapeReader.this.sendDataToClient();
                            return;
                        }
                        ModuleTapeReader.this.mode = Mode.WRITING;
                    }
                    break;
                }
                case WRITING: {
                    for (Port port : Port.VALUES) {
                        Pipe receivingPipe = ModuleTapeReader.this.getCasing().getReceivingPipe(ModuleTapeReader.this.getFace(), port);
                        if (!receivingPipe.isReading()) {
                            receivingPipe.beginRead();
                        }
                        if (!receivingPipe.canTransfer()) continue;
                        tile.write((byte)receivingPipe.read());
                        this.byteQueue = (short)(this.byteQueue - 1);
                        if (this.byteQueue > 0) continue;
                        ModuleTapeReader.this.mode = Mode.IDLE;
                        ModuleTapeReader.this.command = null;
                        ModuleTapeReader.this.sendDataToClient();
                    }
                    break;
                }
            }
        }

        @Override
        protected void save(NBTTagCompound nbt) {
            super.save(nbt);
            nbt.func_74777_a("bq", this.byteQueue);
        }

        @Override
        protected void load(NBTTagCompound nbt) {
            super.load(nbt);
            if (nbt.func_74764_b("bq")) {
                this.byteQueue = nbt.func_74765_d("bq");
            }
        }
    }, new SetterCommand("switchState"){

        @Override
        protected void setValue(TileTapeDrive tile, short val) {
            if (val < 0 || val >= TapeDriveState.State.VALUES.length) {
                return;
            }
            tile.switchState(TapeDriveState.State.VALUES[val % TapeDriveState.State.VALUES.length]);
        }
    }};
    private Mode mode = Mode.IDLE;
    private Command command = null;
    private static final ResourceLocation BACK_ICON = new ResourceLocation("computronics:textures/blocks/tis3d/module_tape_reader_back.png");
    private static final ResourceLocation CENTER_ICON = new ResourceLocation("computronics:textures/blocks/tis3d/module_tape_reader_center.png");
    private static final ResourceLocation OFF_ICON = new ResourceLocation("computronics:textures/blocks/tis3d/module_tape_reader_off.png");
    private static final ResourceLocation ON_ICON = new ResourceLocation("computronics:textures/blocks/tis3d/module_tape_reader_on.png");

    @Nullable
    private Command getCommand(short ordinal) {
        return ordinal >= 0 && ordinal < this.COMMANDS.length ? this.COMMANDS[ordinal] : null;
    }

    public ModuleTapeReader(Casing casing, Face face) {
        super(casing, face);
    }

    public void step() {
        super.step();
        switch (this.mode) {
            case IDLE: {
                TileTapeDrive tile = this.getTapeDrive();
                if (tile == null) break;
                for (Port port : Port.VALUES) {
                    Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
                    if (!receivingPipe.isReading()) {
                        receivingPipe.beginRead();
                    }
                    if (!receivingPipe.canTransfer()) continue;
                    this.command = this.getCommand(receivingPipe.read());
                    break;
                }
                if (this.command == null) break;
                this.command.process(tile);
                this.sendDataToClient();
                break;
            }
            case WAITING: 
            case WRITING: {
                TileTapeDrive tile = this.getTapeDrive();
                if (tile != null && this.command != null) {
                    this.command.process(tile);
                    break;
                }
                this.cancelWrite();
                this.mode = Mode.IDLE;
                this.command = null;
                for (Port port : Port.VALUES) {
                    Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
                    if (receivingPipe.isReading()) continue;
                    receivingPipe.beginRead();
                }
                this.sendDataToClient();
                break;
            }
        }
    }

    public void onWriteComplete(Port port) {
        super.onWriteComplete(port);
        if (this.command != null) {
            this.command.finishWriting(this.getTapeDrive(), port);
        }
    }

    public void onDisabled() {
        super.onDisabled();
        this.mode = Mode.IDLE;
        this.command = null;
        this.sendDataToClient();
    }

    @Nullable
    public TileTapeDrive getTapeDrive() {
        TileEntity tile = this.getCasing().getCasingWorld().func_175625_s(this.getCasing().getPosition().func_177972_a(Face.toEnumFacing((Face)this.getFace())));
        return tile instanceof TileTapeDrive ? (TileTapeDrive)tile : null;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        Command cmd;
        int modeTag;
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("mode") && (modeTag = nbt.func_74762_e("mode")) >= 0 && modeTag < Mode.VALUES.length) {
            this.mode = Mode.VALUES[modeTag];
        }
        if (nbt.func_74764_b("cmdUID") && (cmd = this.commandMap.get(nbt.func_74779_i("cmdUID"))) != null) {
            this.command = cmd;
            if (nbt.func_74764_b("cmdTag")) {
                NBTTagCompound cmdTag = nbt.func_74775_l("cmdTag");
                this.command.load(cmdTag);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("mode", this.mode.ordinal());
        if (this.command != null) {
            nbt.func_74778_a("cmdUID", this.command.getUID());
            NBTTagCompound cmdTag = new NBTTagCompound();
            this.command.save(cmdTag);
            nbt.func_74782_a("cmdTag", (NBTBase)cmdTag);
        }
    }

    @Override
    protected void sendDataToClient() {
    }

    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        RenderUtil.bindTexture((ResourceLocation)BACK_ICON);
        RenderUtil.drawQuad();
        if (enabled) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
            RenderUtil.bindTexture((ResourceLocation)CENTER_ICON);
            RenderUtil.drawQuad();
            boolean hasTapeDrive = this.getTapeDrive() != null;
            RenderUtil.bindTexture((ResourceLocation)(hasTapeDrive ? ON_ICON : OFF_ICON));
            RenderUtil.drawQuad();
            if (!hasTapeDrive) {
                String s = StringUtils.center((String)"NO TAPE DRIVE", (int)16);
                GlStateManager.func_179109_b((float)((float)(s.length() + 1) / 64.0f), (float)0.1875f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)1.0f);
                FontRendererAPI.drawString((String)s);
            }
        }
    }

    private abstract class SetterCommand
    extends NeverWritingCommand {
        private SetterCommand(String uid) {
            super(uid);
        }

        @Override
        protected void process(TileTapeDrive tile) {
            switch (ModuleTapeReader.this.mode) {
                case IDLE: {
                    ModuleTapeReader.this.mode = Mode.WAITING;
                    break;
                }
                case WAITING: {
                    for (Port port : Port.VALUES) {
                        Pipe receivingPipe = ModuleTapeReader.this.getCasing().getReceivingPipe(ModuleTapeReader.this.getFace(), port);
                        if (!receivingPipe.isReading()) {
                            receivingPipe.beginRead();
                        }
                        if (!receivingPipe.canTransfer()) continue;
                        this.setValue(tile, receivingPipe.read());
                        ModuleTapeReader.this.mode = Mode.IDLE;
                        ModuleTapeReader.this.command = null;
                        return;
                    }
                    break;
                }
            }
        }

        protected abstract void setValue(TileTapeDrive var1, short var2);
    }

    private abstract class ImmediateReturnCommand
    extends IdleAfterWritingCommand {
        private ImmediateReturnCommand(String uid) {
            super(uid);
        }

        @Override
        protected void process(TileTapeDrive tile) {
            if (ModuleTapeReader.this.mode == Mode.IDLE) {
                ModuleTapeReader.this.cancelRead();
                ModuleTapeReader.this.mode = Mode.WRITING;
                for (Port port : Port.VALUES) {
                    Pipe sendingPipe = ModuleTapeReader.this.getCasing().getSendingPipe(ModuleTapeReader.this.getFace(), port);
                    if (sendingPipe.isWriting()) continue;
                    sendingPipe.beginWrite(this.getValue(tile));
                }
            }
        }

        protected abstract short getValue(TileTapeDrive var1);
    }

    private abstract class IdleAfterWritingCommand
    extends Command {
        private IdleAfterWritingCommand(String uid) {
            super(uid);
        }

        @Override
        protected void finishWriting(TileTapeDrive tile, Port writtenPort) {
            ModuleTapeReader.this.cancelWrite();
            ModuleTapeReader.this.mode = Mode.IDLE;
            ModuleTapeReader.this.command = null;
            for (Port port : Port.VALUES) {
                Pipe receivingPipe = ModuleTapeReader.this.getCasing().getReceivingPipe(ModuleTapeReader.this.getFace(), port);
                if (receivingPipe.isReading()) continue;
                receivingPipe.beginRead();
            }
            ModuleTapeReader.this.sendDataToClient();
        }
    }

    private abstract class NeverWritingCommand
    extends Command {
        private NeverWritingCommand(String uid) {
            super(uid);
        }

        @Override
        protected void finishWriting(TileTapeDrive tile, Port writtenPort) {
        }
    }

    private abstract class Command {
        protected final String uid;

        protected Command(String uid) {
            this.uid = uid;
            if (ModuleTapeReader.this.commandMap.containsKey(uid)) {
                throw new IllegalArgumentException("Attempt to add command with UID that has already been registered!");
            }
            ModuleTapeReader.this.commandMap.put(uid, this);
        }

        protected final String getUID() {
            return this.uid;
        }

        protected abstract void process(TileTapeDrive var1);

        protected abstract void finishWriting(TileTapeDrive var1, Port var2);

        protected void save(NBTTagCompound nbt) {
        }

        protected void load(NBTTagCompound nbt) {
        }
    }

    private static enum Mode {
        IDLE,
        WAITING,
        WRITING;

        private static final Mode[] VALUES;

        static {
            VALUES = Mode.values();
        }
    }
}

