/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.computronics.CommonProxy;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheralProvider;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheralRegistry;
import pl.asie.computronics.audio.DFPWMPlaybackManager;
import pl.asie.computronics.audio.SoundCardPlaybackManager;
import pl.asie.computronics.audio.tts.TextToSpeech;
import pl.asie.computronics.audio.tts.TextToSpeechLoader;
import pl.asie.computronics.block.BlockAudioCable;
import pl.asie.computronics.block.BlockCamera;
import pl.asie.computronics.block.BlockChatBox;
import pl.asie.computronics.block.BlockCipher;
import pl.asie.computronics.block.BlockCipherAdvanced;
import pl.asie.computronics.block.BlockColorfulLamp;
import pl.asie.computronics.block.BlockIronNote;
import pl.asie.computronics.block.BlockRadar;
import pl.asie.computronics.block.BlockSpeaker;
import pl.asie.computronics.block.BlockSpeechBox;
import pl.asie.computronics.block.BlockTapeReader;
import pl.asie.computronics.cc.IntegrationComputerCraft;
import pl.asie.computronics.cc.multiperipheral.MultiPeripheralRegistry;
import pl.asie.computronics.gui.providers.GuiProviderCipher;
import pl.asie.computronics.gui.providers.GuiProviderPortableTapeDrive;
import pl.asie.computronics.gui.providers.GuiProviderTapeDrive;
import pl.asie.computronics.integration.ModRecipes;
import pl.asie.computronics.integration.charset.IntegrationCharset;
import pl.asie.computronics.integration.conventional.IntegrationConventional;
import pl.asie.computronics.integration.forestry.IntegrationForestry;
import pl.asie.computronics.integration.railcraft.IntegrationRailcraft;
import pl.asie.computronics.integration.tis3d.IntegrationTIS3D;
import pl.asie.computronics.item.ItemMultipleComputronics;
import pl.asie.computronics.item.ItemPortableTapeDrive;
import pl.asie.computronics.item.ItemTape;
import pl.asie.computronics.item.block.ComputronicsItemBlock;
import pl.asie.computronics.network.NetworkHandlerClient;
import pl.asie.computronics.network.NetworkHandlerServer;
import pl.asie.computronics.oc.IntegrationOpenComputers;
import pl.asie.computronics.reference.Capabilities;
import pl.asie.computronics.reference.Compat;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tape.PortableDriveManager;
import pl.asie.computronics.tape.StorageManager;
import pl.asie.computronics.tape.TapeStorageEventHandler;
import pl.asie.computronics.tile.TileAudioCable;
import pl.asie.computronics.tile.TileCamera;
import pl.asie.computronics.tile.TileChatBox;
import pl.asie.computronics.tile.TileCipherBlock;
import pl.asie.computronics.tile.TileCipherBlockAdvanced;
import pl.asie.computronics.tile.TileColorfulLamp;
import pl.asie.computronics.tile.TileIronNote;
import pl.asie.computronics.tile.TileRadar;
import pl.asie.computronics.tile.TileSpeaker;
import pl.asie.computronics.tile.TileSpeechBox;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.computronics.util.chat.ChatHandler;
import pl.asie.computronics.util.event.ServerTickHandler;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.gui.managed.IGuiProvider;
import pl.asie.lib.gui.managed.ManagedGuiHandler;
import pl.asie.lib.network.PacketHandler;

@Mod(modid="computronics", name="Computronics", version="1.6.7", dependencies="required-after:asielib;required-after:forge@[14.23.5.2847,);after:computercraft;after:opencomputers@[1.7,);after:tis3d@[1.2.0,);before:openperipheralcore@[1.1,);before:openperipheralapi@[3.2,);after:buildcraft|core@[7.2.0,);after:railcraft@[12.0,);after:gregtech;after:enderio@[5.1.55,);after:forestry@[5.7.0,);after:waila@[1.5.10,);after:mekanismapi|energy@[8.0.0,);after:flamingo@[1.7.10-1.3,);after:armourersworkshop@[1.7.10-0.33,);after:theoneprobe@[1.0.5,)", acceptedMinecraftVersions="[1.12.2]")
public class Computronics {
    public Config config;
    public Compat compat;
    public static Random rand = new Random();
    public static Logger log = LogManager.getLogger((String)"computronics");
    public static FMLEventChannel channel;
    @Mod.Instance(value="computronics")
    public static Computronics instance;
    public static StorageManager storage;
    public static TapeStorageEventHandler storageEventHandler;
    public static ManagedGuiHandler gui;
    public static PacketHandler packet;
    public static ExecutorService rsaThreads;
    public static ServerTickHandler serverTickHandler;
    public DFPWMPlaybackManager audio;
    public int managerId;
    public SoundCardPlaybackManager soundCardAudio;
    public int soundCardManagerId;
    @SidedProxy(clientSide="pl.asie.computronics.ClientProxy", serverSide="pl.asie.computronics.CommonProxy")
    public static CommonProxy proxy;
    public static BlockIronNote ironNote;
    public static BlockTapeReader tapeReader;
    public static BlockAudioCable audioCable;
    public static BlockSpeaker speaker;
    public static BlockSpeechBox speechBox;
    public static BlockCamera camera;
    public static BlockChatBox chatBox;
    public static BlockCipher cipher;
    public static BlockCipherAdvanced cipher_advanced;
    public static BlockRadar radar;
    public static BlockColorfulLamp colorfulLamp;
    public static IntegrationOpenComputers opencomputers;
    public static IntegrationComputerCraft computercraft;
    public static IntegrationRailcraft railcraft;
    public static IntegrationForestry forestry;
    public static IntegrationTIS3D tis3D;
    public static IntegrationCharset charset;
    public static ItemPortableTapeDrive portableTapeDrive;
    public static ItemTape itemTape;
    public static ItemMultipleComputronics itemParts;
    public static IGuiProvider guiTapeDrive;
    public static IGuiProvider guiPortableTapeDrive;
    public static IGuiProvider guiCipher;
    public static MultiPeripheralRegistry peripheralRegistry;
    public static CreativeTabs tab;
    public static TextToSpeech tts;

    public boolean isEnabled(String name, boolean def) {
        return this.config.isEnabled(name, def);
    }

    public void registerBlockWithTileEntity(BlockBase block, Class<? extends TileEntity> tile, String name) {
        this.registerBlockWithTileEntity(block, new ComputronicsItemBlock(block), tile, name);
    }

    public void registerBlockWithTileEntity(Block block, ItemBlock itemBlock, Class<? extends TileEntity> tile, String name) {
        GameRegistry.findRegistry(Block.class).register(block.setRegistryName(new ResourceLocation("computronics", name)));
        GameRegistry.findRegistry(Item.class).register(itemBlock.setRegistryName(block.getRegistryName()));
        TileEntity.func_190560_a((String)name, tile);
        proxy.registerItemModel(block, 0, "computronics:" + name);
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)tile.getCanonicalName());
    }

    public void registerItem(Item item, String name) {
        GameRegistry.findRegistry(Item.class).register(item.setRegistryName(new ResourceLocation("computronics", name)));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        serverTickHandler = new ServerTickHandler();
        MinecraftForge.EVENT_BUS.register((Object)serverTickHandler);
        this.config = new Config(event);
        storage = new StorageManager();
        this.audio = new DFPWMPlaybackManager(proxy.isClient());
        this.managerId = AudioPacketRegistry.INSTANCE.registerManager(this.audio);
        this.soundCardAudio = new SoundCardPlaybackManager(proxy.isClient());
        this.soundCardManagerId = AudioPacketRegistry.INSTANCE.registerManager(this.soundCardAudio);
        packet = new PacketHandler("computronics", new NetworkHandlerClient(), new NetworkHandlerServer());
        this.compat = new Compat(this.config.config);
        this.config.preInit();
        gui = new ManagedGuiHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)gui);
        if (this.isEnabled("ironNoteBlock", true)) {
            ironNote = new BlockIronNote();
            this.registerBlockWithTileEntity(ironNote, TileIronNote.class, "iron_note_block");
        }
        if (this.isEnabled("audioCable", true)) {
            audioCable = new BlockAudioCable();
            this.registerBlockWithTileEntity(audioCable, TileAudioCable.class, "audio_cable");
        }
        if (this.isEnabled("speaker", true)) {
            speaker = new BlockSpeaker();
            this.registerBlockWithTileEntity(speaker, TileSpeaker.class, "speaker");
        }
        if (this.isEnabled("tape", true)) {
            guiTapeDrive = new GuiProviderTapeDrive();
            gui.registerGuiProvider(guiTapeDrive);
            tapeReader = new BlockTapeReader();
            this.registerBlockWithTileEntity(tapeReader, TileTapeDrive.class, "tape_reader");
        }
        if (this.isEnabled("camera", true)) {
            camera = new BlockCamera();
            this.registerBlockWithTileEntity(camera, TileCamera.class, "camera");
        }
        if (this.isEnabled("chatBox", true)) {
            chatBox = new BlockChatBox();
            this.registerBlockWithTileEntity(chatBox, TileChatBox.class, "chat_box");
            proxy.registerItemModel(chatBox, 8, "computronics:chat_box");
        }
        if (this.isEnabled("cipher", true)) {
            guiCipher = new GuiProviderCipher();
            gui.registerGuiProvider(guiCipher);
            cipher = new BlockCipher();
            this.registerBlockWithTileEntity(cipher, TileCipherBlock.class, "cipher");
        }
        if (this.isEnabled("cipher_advanced", true)) {
            cipher_advanced = new BlockCipherAdvanced();
            this.registerBlockWithTileEntity(cipher_advanced, TileCipherBlockAdvanced.class, "cipher_advanced");
            rsaThreads = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setPriority(1).build());
        }
        if (this.isEnabled("radar", true)) {
            radar = new BlockRadar();
            this.registerBlockWithTileEntity(radar, TileRadar.class, "radar");
        }
        if (this.isEnabled("lamp", true)) {
            colorfulLamp = new BlockColorfulLamp();
            this.registerBlockWithTileEntity(colorfulLamp, TileColorfulLamp.class, "colorful_lamp");
        }
        if (this.isEnabled("tape", true)) {
            itemTape = new ItemTape(Config.TAPE_LENGTHS);
            this.registerItem(itemTape, "tape");
            itemTape.registerItemModels();
            itemParts = new ItemMultipleComputronics("computronics", new String[]{"part_tape_track"});
            itemParts.func_77637_a(tab);
            this.registerItem(itemParts, "parts");
            itemParts.registerItemModels();
        }
        if (this.isEnabled("portableTapeDrive", true)) {
            portableTapeDrive = new ItemPortableTapeDrive();
            this.registerItem(portableTapeDrive, "portable_tape_drive");
            guiPortableTapeDrive = new GuiProviderPortableTapeDrive();
            gui.registerGuiProvider(guiPortableTapeDrive);
        }
        if (Mods.isLoaded("railcraft")) {
            railcraft = new IntegrationRailcraft();
            railcraft.preInit(this.config.config);
        }
        if (Mods.isLoaded("computercraft")) {
            computercraft = new IntegrationComputerCraft(this);
            peripheralRegistry = new MultiPeripheralRegistry();
            computercraft.preInit();
        }
        if (Mods.isLoaded("opencomputers")) {
            opencomputers = new IntegrationOpenComputers(this);
            opencomputers.preInit();
        }
        if (Config.TTS_ENABLED) {
            boolean success = TextToSpeechLoader.INSTANCE.preInit();
            if (success && !(tts = new TextToSpeech()).preInit()) {
                tts = null;
            }
            if (this.isEnabled("speechBox", true)) {
                speechBox = new BlockSpeechBox();
                this.registerBlockWithTileEntity(speechBox, TileSpeechBox.class, "speech_box");
            }
        }
        if (Mods.isLoaded("tis3d")) {
            tis3D = new IntegrationTIS3D();
            tis3D.preInit();
        }
        charset = new IntegrationCharset();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ChatHandler());
        if (tapeReader != null || portableTapeDrive != null) {
            storageEventHandler = new TapeStorageEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)storageEventHandler);
        }
        if (portableTapeDrive != null) {
            MinecraftForge.EVENT_BUS.register((Object)PortableDriveManager.INSTANCE);
        }
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"pl.asie.computronics.integration.info.IntegrationWaila.register");
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"pl.asie.computronics.integration.info.IntegrationTOP");
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"pl.asie.computronics.integration.waila.IntegrationWaila.register");
        if (Mods.isLoaded("computercraft")) {
            computercraft.init();
        }
        if (Mods.isLoaded("opencomputers")) {
            opencomputers.init();
        }
        if (Mods.isLoaded("tis3d") && tis3D != null) {
            tis3D.init(this.compat);
        }
        if (Mods.isLoaded("conventional")) {
            IntegrationConventional.INSTANCE.init();
        }
        Capabilities.INSTANCE.init();
        proxy.init();
        this.config.save();
    }

    @Optional.Method(modid="computercraft")
    public static void registerMultiPeripheralProvider(IMultiPeripheralProvider provider) {
        if (peripheralRegistry != null) {
            peripheralRegistry.registerPeripheralProvider(provider);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModRecipes.instance = new ModRecipes();
        if (ModRecipes.instance != null) {
            ModRecipes.instance.registerRecipes();
        } else {
            log.error("Could not register recipes, an error occured!");
        }
        if (Mods.isLoaded("opencomputers")) {
            opencomputers.postInit();
        }
        if (Mods.isLoaded("computercraft")) {
            computercraft.postInit();
        }
        if (Mods.isLoaded("tis3d") && tis3D != null) {
            tis3D.postInit();
        }
        charset.postInit();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent event) {
        if (Mods.isLoaded("computercraft")) {
            computercraft.serverStart();
        }
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        proxy.onServerStop();
        PortableDriveManager.INSTANCE.onServerStop();
    }

    @Mod.EventHandler
    public void receiveIMC(FMLInterModComms.IMCEvent event) {
        if (Mods.isLoaded("computercraft")) {
            ImmutableList messages = event.getMessages();
            for (FMLInterModComms.IMCMessage message : messages) {
                if (!message.key.equalsIgnoreCase("addmultiperipherals") || !message.isStringMessage()) continue;
                if (peripheralRegistry != null) {
                    try {
                        String methodString = message.getStringValue();
                        String[] methodParts = methodString.split("\\.");
                        String methodName = methodParts[methodParts.length - 1];
                        String className = methodString.substring(0, methodString.length() - methodName.length() - 1);
                        try {
                            Class<?> c = Class.forName(className);
                            Method method = c.getDeclaredMethod(methodName, IMultiPeripheralRegistry.class);
                            method.invoke(null, peripheralRegistry);
                        }
                        catch (ClassNotFoundException e) {
                            log.warn("Could not find class " + className, (Throwable)e);
                        }
                        catch (NoSuchMethodException e) {
                            log.warn("Could not find method " + methodString, (Throwable)e);
                        }
                        catch (Exception e) {
                            log.warn("Exception while trying to call method " + methodString, (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception while trying to register a MultiPeripheral", (Throwable)e);
                    }
                    continue;
                }
                log.warn(String.format(Locale.ENGLISH, "Mod (%s) tried to register MultiPeripheral before Computronics' preInit!", message.getSender()));
            }
        }
    }

    static {
        tab = new CreativeTabs("tabComputronics"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)itemTape, 1, 0);
            }
        };
    }
}

