/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.api.TeleportPipeType;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.additionalpipes.utils.PlayerUtils;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventTileState;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.transport.tile.TilePipeHolder;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class PipeBehaviorTeleport
extends APPipe
implements ITeleportPipe {
    protected static final Random rand = new Random();
    private int frequency = 0;
    public byte state = 1;
    public UUID ownerUUID;
    public String ownerName = "";
    public int[] network = new int[0];
    public boolean isPublic = false;
    public final TeleportPipeType type;

    public PipeBehaviorTeleport(IPipe pipe, TeleportPipeType type) {
        super(pipe);
        this.type = type;
        if (this.isServer()) {
            TeleportManager.instance.add(this, this.frequency);
        }
    }

    public PipeBehaviorTeleport(IPipe pipe, NBTTagCompound tagCompound, TeleportPipeType type) {
        super(pipe, tagCompound);
        this.type = type;
        this.frequency = tagCompound.func_74762_e("freq");
        this.state = tagCompound.func_74771_c("state");
        if (tagCompound.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(tagCompound.func_74779_i("ownerUUID"));
            this.ownerName = tagCompound.func_74779_i("ownerName");
        }
        this.isPublic = tagCompound.func_74767_n("isPublic");
        if (this.isServer()) {
            TeleportManager.instance.add(this, this.frequency);
        }
    }

    @Override
    public byte getState() {
        return this.state;
    }

    @Override
    public void setState(byte state) {
        this.state = state;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public TeleportPipeType getType() {
        return this.type;
    }

    @PipeEventHandler
    public void onInvalidate(PipeEventTileState.Invalidate event) {
        if (this.isServer()) {
            Log.debug("Teleport pipe at " + this.getPos() + " invalidated");
            TeleportManager.instance.remove(this, this.frequency);
        }
    }

    @PipeEventHandler
    public void onChunkUnload(PipeEventTileState.ChunkUnload event) {
        if (this.isServer()) {
            Log.debug("Teleport pipe at " + this.getPos() + " unloaded");
            TeleportManager.instance.remove(this, this.frequency);
        }
    }

    @PipeEventHandler
    public void onValidate(PipeEventTileState.Validate event) {
        if (this.isServer()) {
            Log.debug("Teleport pipe at " + this.getPos() + " validated");
        }
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.ownerUUID == null) {
            this.ownerUUID = PlayerUtils.getUUID(player);
            this.ownerName = player.func_70005_c_();
        }
        if (!this.isPublic) {
            if (PlayerUtils.getUUID(player).equals(this.ownerUUID)) {
                if (!player.func_70005_c_().equals(this.ownerName)) {
                    this.ownerName = player.func_70005_c_();
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.ap.accessdenied", new Object[]{this.ownerName}));
                return true;
            }
        }
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        if (!player.field_70170_p.field_72995_K) {
            BlockPos pipePos = this.pipe.getHolder().getPipePos();
            player.openGui((Object)AdditionalPipes.instance, 1, this.pipe.getHolder().getPipeWorld(), pipePos.func_177958_n(), pipePos.func_177956_o(), pipePos.func_177952_p());
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        ITeleportPipe pipe;
        return obj instanceof ITeleportPipe && (pipe = (ITeleportPipe)obj).getType() == this.getType() && pipe.getState() == this.getState() && pipe.isPublic() == this.isPublic() && Objects.equals(pipe.getOwnerUUID(), this.getOwnerUUID()) && Objects.equals(pipe.getPosition(), this.getPosition()) && pipe.getFrequency() == this.getFrequency();
    }

    @Override
    public void setFrequency(int freq) {
        this.frequency = freq;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public TilePipeHolder getContainer() {
        if (this.pipe != null) {
            return (TilePipeHolder)this.pipe.getHolder();
        }
        return null;
    }

    public boolean canConnect(EnumFacing face, PipeBehaviour other) {
        if (other instanceof PipeBehaviorTeleport) {
            return false;
        }
        return super.canConnect(face, other);
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbttagcompound = super.writeToNbt();
        nbttagcompound.func_74768_a("freq", this.frequency);
        nbttagcompound.func_74774_a("state", this.state);
        if (this.ownerUUID != null) {
            nbttagcompound.func_74778_a("ownerUUID", this.ownerUUID.toString());
            nbttagcompound.func_74778_a("ownerName", this.ownerName);
        }
        nbttagcompound.func_74757_a("isPublic", this.isPublic);
        return nbttagcompound;
    }

    public static boolean canPlayerModifyPipe(EntityPlayer player, PipeBehaviorTeleport pipe) {
        return pipe.isPublic || pipe.ownerUUID.equals(PlayerUtils.getUUID(player)) || player.field_71075_bZ.field_75098_d;
    }

    @Override
    public BlockPos getPosition() {
        return this.getPos();
    }

    @Override
    public boolean canReceive() {
        return (this.state & 2) > 0;
    }

    @Override
    public boolean canSend() {
        return (this.state & 1) > 0;
    }
}

