/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.network.message;

import buildcraft.additionalpipes.pipes.PipeBehaviorTeleport;
import buildcraft.transport.tile.TilePipeHolder;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTelePipeData
implements IMessage,
IMessageHandler<MessageTelePipeData, IMessage> {
    public BlockPos position;
    public int[] locations;
    public String ownerUUID;
    public String ownerName;

    public MessageTelePipeData() {
    }

    public MessageTelePipeData(BlockPos position, int[] locations, UUID ownerUUID, String ownerName) {
        this.position = position;
        this.locations = locations;
        this.ownerUUID = ownerUUID.toString();
        this.ownerName = ownerName;
    }

    public void fromBytes(ByteBuf buf) {
        this.position = BlockPos.func_177969_a((long)buf.readLong());
        int locationsLength = buf.readInt();
        this.locations = new int[locationsLength];
        for (int counter = 0; counter < locationsLength; ++counter) {
            this.locations[counter] = buf.readInt();
        }
        this.ownerUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.position.func_177986_g());
        buf.writeInt(this.locations.length);
        for (int location : this.locations) {
            buf.writeInt(location);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ownerUUID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.ownerName);
    }

    public IMessage onMessage(MessageTelePipeData message, MessageContext ctx) {
        TileEntity te = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(message.position);
        PipeBehaviorTeleport pipe = (PipeBehaviorTeleport)((TilePipeHolder)te).getPipe().getBehaviour();
        pipe.ownerUUID = UUID.fromString(message.ownerUUID);
        pipe.ownerName = message.ownerName;
        pipe.network = message.locations;
        return null;
    }

    public String toString() {
        return "MessageTelePipeData";
    }
}

