/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.APPipeDefintions;
import buildcraft.additionalpipes.CommandAdditionalPipes;
import buildcraft.additionalpipes.MultiPlayerProxy;
import buildcraft.additionalpipes.api.TeleportManagerBase;
import buildcraft.additionalpipes.chunkloader.BlockTeleportTether;
import buildcraft.additionalpipes.chunkloader.ChunkLoadingHandler;
import buildcraft.additionalpipes.chunkloader.TileTeleportTether;
import buildcraft.additionalpipes.gates.GateProvider;
import buildcraft.additionalpipes.gates.TriggerPipeClosed;
import buildcraft.additionalpipes.gui.GuiHandler;
import buildcraft.additionalpipes.item.ItemDogDeaggravator;
import buildcraft.additionalpipes.network.PacketHandler;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.sound.APSounds;
import buildcraft.additionalpipes.test.TeleportManagerTest;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.registry.CreativeTabManager;
import buildcraft.silicon.BCSiliconItems;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="additionalpipes", name="Additional Pipes", dependencies="required-after:buildcrafttransport@[7.99.13,);required-after:buildcraftsilicon;required-after:buildcraftfactory", version="6.0.0.9", acceptedMinecraftVersions="[1.12.2]")
public class AdditionalPipes {
    public static final String MODID = "additionalpipes";
    public static final String NAME = "Additional Pipes";
    public static final String VERSION = "6.0.0.9";
    @Mod.Instance(value="additionalpipes")
    public static AdditionalPipes instance;
    @SidedProxy(clientSide="buildcraft.additionalpipes.MultiPlayerProxyClient", serverSide="buildcraft.additionalpipes.MultiPlayerProxy")
    public static MultiPlayerProxy proxy;
    public File configFile;
    public CreativeTabManager.CreativeTabBC creativeTab;
    public Item pipeLiquidsObsidian;
    public BlockTeleportTether blockTeleportTether;
    public Item dogDeaggravator;
    public ITriggerInternal triggerPipeClosed;
    Block blockFoo;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        this.configFile = event.getSuggestedConfigurationFile();
        APConfiguration.loadConfigs(this.configFile);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.creativeTab = CreativeTabManager.createTab((String)"apcreativetab");
        Log.info("Registering pipes");
        APPipeDefintions.createPipes();
        APPipeDefintions.setFluidCapacities();
        Log.info("Registering gates");
        proxy.registerSprites();
        this.triggerPipeClosed = new TriggerPipeClosed();
        StatementManager.registerTriggerProvider((ITriggerProvider)new GateProvider());
        this.blockTeleportTether = new BlockTeleportTether();
        this.blockTeleportTether.setRegistryName("teleport_tether");
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Log.info("Registering blocks");
        event.getRegistry().register((IForgeRegistryEntry)this.blockTeleportTether);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Log.info("Registering items");
        this.dogDeaggravator = new ItemDogDeaggravator();
        event.getRegistry().register((IForgeRegistryEntry)this.dogDeaggravator);
        event.getRegistry().register(new ItemBlock((Block)this.blockTeleportTether).setRegistryName(this.blockTeleportTether.getRegistryName()));
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Log.info("Registering recipes");
        if (APConfiguration.enableChunkloaderRecipe) {
            Log.debug("Chunkloader recipe enabled!");
            ShapedOreRecipe chunkloaderRecipe = new ShapedOreRecipe(new ResourceLocation(MODID, "recipes/teleport_tether"), (Block)this.blockTeleportTether, new Object[]{"iii", "iLi", "ici", Character.valueOf('i'), "ingotIron", Character.valueOf('L'), "gemLapis", Character.valueOf('c'), new ItemStack((Item)BCSiliconItems.redstoneChipset, 1, 3)});
            chunkloaderRecipe.setRegistryName("teleport_tether");
            event.getRegistry().register((IForgeRegistryEntry)chunkloaderRecipe);
        }
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        Log.info("Registering sounds");
        APSounds.register((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        Log.info("Registering chunk load handler");
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadingHandler());
        GameRegistry.registerTileEntity(TileTeleportTether.class, (String)"teleport_tether");
        proxy.registerKeyHandler();
        this.creativeTab.setItem(new ItemStack(APPipeDefintions.itemsTeleportPipeItem));
        if (APConfiguration.enableDebugLog) {
            Log.info("Running Teleport Manager Tests");
            TeleportManagerTest.runAllTests();
        }
        TeleportManagerBase.INSTANCE = TeleportManager.instance;
        Log.info("Setting up renderings...");
        proxy.registerRendering();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandAdditionalPipes());
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        Log.debug("World unloaded, clearing teleport manager");
        TeleportManager.instance.reset();
    }
}

