/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.structure;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeHolders;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureOceanMonument;

public class ModernBetaStructureOceanMonument
extends StructureOceanMonument {
    public static final List<Biome> WATER_BIOMES = Arrays.asList(ModernBetaBiomeHolders.BETA_FROZEN_OCEAN, ModernBetaBiomeHolders.BETA_OCEAN, Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_76781_i, Biomes.field_76776_l, Biomes.field_76777_m);
    public static final List<Biome> SPAWN_BIOMES = Arrays.asList(ModernBetaBiomeHolders.BETA_OCEAN, Biomes.field_76771_b, Biomes.field_150575_M);
    private final int spacing;
    private final int separation;

    public ModernBetaStructureOceanMonument() {
        this.spacing = 32;
        this.separation = 5;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int originalChunkX = chunkX;
        int originalChunkZ = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        int structureX = chunkX / this.spacing;
        int structureZ = chunkZ / this.spacing;
        Random random = this.field_75039_c.func_72843_D(structureX, structureZ, 10387313);
        structureX *= this.spacing;
        structureZ *= this.spacing;
        structureX += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2;
        structureZ += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2;
        chunkX = originalChunkX;
        chunkZ = originalChunkZ;
        BiomeProvider biomeProvider = this.field_75039_c.func_72959_q();
        if (biomeProvider instanceof ModernBetaBiomeProvider) {
            ModernBetaBiomeProvider modernBetaBiomeProvider = (ModernBetaBiomeProvider)this.field_75039_c.func_72959_q();
            if (chunkX == structureX && chunkZ == structureZ) {
                if (!modernBetaBiomeProvider.func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 16, SPAWN_BIOMES)) {
                    return false;
                }
                boolean validBiome = modernBetaBiomeProvider.func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 29, WATER_BIOMES);
                if (validBiome) {
                    return true;
                }
            }
        }
        return false;
    }
}

