/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.structure;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeHolders;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureStart;

public class ModernBetaMapGenScatteredFeature
extends MapGenScatteredFeature {
    private static final List<Biome> ALLOWED_BIOMES = Arrays.asList(ModernBetaBiomeHolders.BETA_DESERT, ModernBetaBiomeHolders.BETA_RAINFOREST, ModernBetaBiomeHolders.BETA_SWAMPLAND, ModernBetaBiomeHolders.BETA_TUNDRA, ModernBetaBiomeHolders.BETA_TAIGA, Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_76780_h, Biomes.field_76774_n, Biomes.field_150584_S);
    private final int maxDistanceBetweenScatteredFeatures;

    public ModernBetaMapGenScatteredFeature() {
        this.maxDistanceBetweenScatteredFeatures = 32;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int originalChunkX = chunkX;
        int originalChunkZ = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int structureX = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int structureZ = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(structureX, structureZ, 14357617);
        structureX *= this.maxDistanceBetweenScatteredFeatures;
        structureZ *= this.maxDistanceBetweenScatteredFeatures;
        if (originalChunkX == (structureX += random.nextInt(this.maxDistanceBetweenScatteredFeatures - 8)) && originalChunkZ == (structureZ += random.nextInt(this.maxDistanceBetweenScatteredFeatures - 8))) {
            int x = originalChunkX * 16 + 8;
            int z = originalChunkZ * 16 + 8;
            Biome biome = this.field_75039_c.func_72959_q().func_180631_a(new BlockPos(x, 0, z));
            if (biome == null) {
                return false;
            }
            for (Biome allowedBiome : ALLOWED_BIOMES) {
                if (biome != allowedBiome) continue;
                return true;
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends MapGenScatteredFeature.Start {
        public Start() {
        }

        public Start(World world, Random random, int chunkX, int chunkZ) {
            this(world, random, chunkX, chunkZ, world.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
        }

        public Start(World world, Random random, int chunkX, int chunkZ, Biome biome) {
            super(world, random, chunkX, chunkZ, biome);
            if (biome == ModernBetaBiomeHolders.BETA_RAINFOREST) {
                this.field_75075_a.add(new ComponentScatteredFeaturePieces.JunglePyramid(random, chunkX * 16, chunkZ * 16));
            } else if (biome == ModernBetaBiomeHolders.BETA_SWAMPLAND) {
                this.field_75075_a.add(new ComponentScatteredFeaturePieces.SwampHut(random, chunkX * 16, chunkZ * 16));
            } else if (biome == ModernBetaBiomeHolders.BETA_DESERT) {
                this.field_75075_a.add(new ComponentScatteredFeaturePieces.DesertPyramid(random, chunkX * 16, chunkZ * 16));
            } else if (biome == ModernBetaBiomeHolders.BETA_TUNDRA || biome == ModernBetaBiomeHolders.BETA_TAIGA) {
                this.field_75075_a.add(new ComponentScatteredFeaturePieces.Igloo(random, chunkX * 16, chunkZ * 16));
            }
            this.func_75072_c();
        }
    }
}

