/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.gen.source;

import java.util.Random;
import mod.bespectacled.modernbetaforge.api.world.gen.NoiseChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaNoiseSettings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class SkylandsChunkSource
extends NoiseChunkSource {
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;
    private final PerlinOctaveNoise surfaceOctaveNoise;
    private final PerlinOctaveNoise forestOctaveNoise;

    public SkylandsChunkSource(World world, ModernBetaChunkGenerator chunkGenerator, ModernBetaChunkGeneratorSettings settings, long seed, boolean mapFeaturesEnabled, ModernBetaNoiseSettings noiseSettings) {
        super(world, chunkGenerator, settings, seed, mapFeaturesEnabled, noiseSettings);
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        new PerlinOctaveNoise(this.random, 4, true);
        this.surfaceOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        new PerlinOctaveNoise(this.random, 10, true);
        new PerlinOctaveNoise(this.random, 16, true);
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        this.setForestOctaveNoise(this.forestOctaveNoise);
        this.setBeachOctaveNoise(null);
    }

    @Override
    public void provideSurface(Biome[] biomes, ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        double scale = 0.03125;
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        double[] surfaceNoise = this.surfaceOctaveNoise.sampleBeta(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, scale * 2.0, scale * 2.0, scale * 2.0);
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceDepth = (int)(surfaceNoise[localZ + localX * 16] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int runDepth = -1;
                Biome biome = biomes[localX + localZ * 16];
                IBlockState topBlock = biome.field_76752_A;
                IBlockState fillerBlock = biome.field_76753_B;
                if (this.useCustomSurfaceBuilder(biome, chunkPrimer, rand, x, z)) continue;
                for (int y = this.worldTopY - 1; y >= this.worldMinY; --y) {
                    IBlockState blockState = chunkPrimer.func_177856_a(localX, y, localZ);
                    if (BlockStates.isAir(blockState)) {
                        runDepth = -1;
                        continue;
                    }
                    if (!BlockStates.isEqual(blockState, this.defaultBlock)) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = this.defaultBlock;
                        }
                        runDepth = surfaceDepth;
                        blockState = y >= 0 ? topBlock : fillerBlock;
                        chunkPrimer.func_177855_a(localX, y, localZ, blockState);
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    chunkPrimer.func_177855_a(localX, y, localZ, fillerBlock);
                    if (--runDepth != 0 || !BlockStates.isEqual(fillerBlock, BlockStates.SAND)) continue;
                    runDepth = rand.nextInt(4);
                    fillerBlock = BlockStates.SANDSTONE;
                }
            }
        }
    }

    @Override
    protected void sampleNoiseColumn(double[] buffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double coordinateScale = this.settings.coordinateScale;
        double heightScale = this.settings.heightScale;
        double mainNoiseScaleX = this.settings.mainNoiseScaleX;
        double mainNoiseScaleY = this.settings.mainNoiseScaleY;
        double mainNoiseScaleZ = this.settings.mainNoiseScaleZ;
        double lowerLimitScale = this.settings.lowerLimitScale;
        double upperLimitScale = this.settings.upperLimitScale;
        for (int noiseY = 0; noiseY < buffer.length; ++noiseY) {
            double density;
            double densityOffset = this.getOffset();
            double mainNoise = (this.mainOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale / mainNoiseScaleX, heightScale / mainNoiseScaleY, coordinateScale / mainNoiseScaleZ) / 10.0 + 1.0) / 2.0;
            if (mainNoise < 0.0) {
                density = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
            } else if (mainNoise > 1.0) {
                density = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
            } else {
                double minLimitNoise = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
                double maxLimitNoise = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
                density = minLimitNoise + (maxLimitNoise - minLimitNoise) * mainNoise;
            }
            density -= densityOffset;
            buffer[noiseY] = density = this.applySlides(density, noiseY);
        }
    }

    private double getOffset() {
        return 8.0;
    }
}

