/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.gen.source;

import java.util.Random;
import mod.bespectacled.modernbetaforge.api.world.gen.NoiseChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaNoiseSettings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class Infdev415ChunkSource
extends NoiseChunkSource {
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;
    private final PerlinOctaveNoise beachOctaveNoise;
    private final PerlinOctaveNoise surfaceOctaveNoise;
    private final PerlinOctaveNoise forestOctaveNoise;

    public Infdev415ChunkSource(World world, ModernBetaChunkGenerator chunkGenerator, ModernBetaChunkGeneratorSettings settings, long seed, boolean mapFeaturesEnabled, ModernBetaNoiseSettings noiseSettings) {
        super(world, chunkGenerator, settings, seed, mapFeaturesEnabled, noiseSettings);
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        this.beachOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        this.surfaceOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        new PerlinOctaveNoise(this.random, 5, true);
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, 5, true);
        this.setForestOctaveNoise(this.forestOctaveNoise);
        this.setBeachOctaveNoise(this.beachOctaveNoise);
    }

    @Override
    public void provideSurface(Biome[] biomes, ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        double scale = 0.03125;
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        int bedrockFloor = this.worldMinY + this.bedrockFloor;
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        Random bedrockRand = this.createSurfaceRandom(chunkX, chunkZ);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = startX + localX;
                int z = startZ + localZ;
                boolean genSandBeach = this.beachOctaveNoise.sample((double)x * scale, (double)z * scale, 0.0) + rand.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = this.beachOctaveNoise.sample((double)z * scale, 109.0134, (double)x * scale) + rand.nextDouble() * 0.2 > 3.0;
                double surfaceNoise = this.surfaceOctaveNoise.sampleXY((double)x * scale * 2.0, (double)z * scale * 2.0);
                int surfaceDepth = (int)(surfaceNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int runDepth = -1;
                Biome biome = biomes[localX + localZ * 16];
                IBlockState topBlock = biome.field_76752_A;
                IBlockState fillerBlock = biome.field_76753_B;
                if (this.useCustomSurfaceBuilder(biome, chunkPrimer, rand, x, z)) continue;
                for (int y = this.worldTopY - 1; y >= this.worldMinY; --y) {
                    if (y <= bedrockFloor + bedrockRand.nextInt(5)) {
                        chunkPrimer.func_177855_a(localX, y, localZ, BlockStates.BEDROCK);
                        continue;
                    }
                    IBlockState blockState = chunkPrimer.func_177856_a(localX, y, localZ);
                    if (BlockStates.isAir(blockState)) {
                        runDepth = -1;
                        continue;
                    }
                    if (!BlockStates.isEqual(blockState, this.defaultBlock)) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = this.defaultBlock;
                        } else if (y >= this.seaLevel - 4 && y <= this.seaLevel + 1) {
                            topBlock = biome.field_76752_A;
                            fillerBlock = biome.field_76753_B;
                            if (genGravelBeach) {
                                topBlock = BlockStates.AIR;
                                fillerBlock = BlockStates.GRAVEL;
                            }
                            if (genSandBeach) {
                                topBlock = BlockStates.SAND;
                                fillerBlock = BlockStates.SAND;
                            }
                        }
                        runDepth = surfaceDepth;
                        if (y < this.seaLevel && BlockStates.isAir(topBlock)) {
                            topBlock = this.defaultFluid;
                        }
                        blockState = y >= this.seaLevel - 1 || y < this.seaLevel - 1 && BlockStates.isAir(chunkPrimer.func_177856_a(localX, y + 1, localZ)) ? topBlock : fillerBlock;
                        chunkPrimer.func_177855_a(localX, y, localZ, blockState);
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    chunkPrimer.func_177855_a(localX, y, localZ, fillerBlock);
                    --runDepth;
                }
            }
        }
    }

    @Override
    protected void sampleNoiseColumn(double[] buffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double coordinateScale = this.settings.coordinateScale;
        double heightScale = this.settings.heightScale;
        double mainNoiseScaleX = this.settings.mainNoiseScaleX;
        double mainNoiseScaleY = this.settings.mainNoiseScaleY;
        double mainNoiseScaleZ = this.settings.mainNoiseScaleZ;
        double lowerLimitScale = this.settings.lowerLimitScale;
        double upperLimitScale = this.settings.upperLimitScale;
        for (int noiseY = 0; noiseY < buffer.length; ++noiseY) {
            double density;
            double densityOffset = this.getOffset(noiseY);
            double mainNoiseVal = this.mainOctaveNoise.sample((double)noiseX * coordinateScale / mainNoiseScaleX, (double)noiseY * coordinateScale / mainNoiseScaleY, (double)noiseZ * coordinateScale / mainNoiseScaleZ) / 2.0;
            if (mainNoiseVal < -1.0) {
                density = this.minLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / lowerLimitScale;
                density -= densityOffset;
                density = this.clampNoise(density);
            } else if (mainNoiseVal > 1.0) {
                density = this.maxLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / upperLimitScale;
                density -= densityOffset;
                density = this.clampNoise(density);
            } else {
                double minLimitVal = this.minLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / lowerLimitScale;
                double maxLimitVal = this.maxLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / upperLimitScale;
                minLimitVal -= densityOffset;
                maxLimitVal -= densityOffset;
                minLimitVal = this.clampNoise(minLimitVal);
                maxLimitVal = this.clampNoise(maxLimitVal);
                double delta = (mainNoiseVal + 1.0) / 2.0;
                density = minLimitVal + (maxLimitVal - minLimitVal) * delta;
            }
            buffer[noiseY] = density = this.applySlides(density, noiseY);
        }
    }

    private double clampNoise(double density) {
        return MathHelper.func_151237_a((double)density, (double)-10.0, (double)10.0);
    }

    private double getOffset(int noiseY) {
        double offset = (double)(noiseY * this.verticalNoiseResolution) - (double)this.seaLevel;
        if (offset < 0.0) {
            offset *= 3.0;
        }
        return offset;
    }
}

