/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.gen.source;

import java.util.Random;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.Clime;
import mod.bespectacled.modernbetaforge.api.world.gen.NoiseChunkSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.biome.source.BetaBiomeSource;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaNoiseSettings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BetaChunkSource
extends NoiseChunkSource {
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;
    private final PerlinOctaveNoise beachOctaveNoise;
    private final PerlinOctaveNoise surfaceOctaveNoise;
    private final PerlinOctaveNoise scaleOctaveNoise;
    private final PerlinOctaveNoise depthOctaveNoise;
    private final PerlinOctaveNoise forestOctaveNoise;
    private final ClimateSampler climateSampler;

    public BetaChunkSource(World world, ModernBetaChunkGenerator chunkGenerator, ModernBetaChunkGeneratorSettings settings, long seed, boolean mapFeaturesEnabled, ModernBetaNoiseSettings noiseSettings) {
        super(world, chunkGenerator, settings, seed, mapFeaturesEnabled, noiseSettings);
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        this.beachOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        this.surfaceOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        this.scaleOctaveNoise = new PerlinOctaveNoise(this.random, 10, true);
        this.depthOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        this.climateSampler = world.func_72959_q() instanceof ModernBetaBiomeProvider && ((ModernBetaBiomeProvider)world.func_72959_q()).getBiomeSource() instanceof BetaBiomeSource ? (BetaBiomeSource)((ModernBetaBiomeProvider)world.func_72959_q()).getBiomeSource() : new BetaBiomeSource(world.func_72912_H());
        this.setForestOctaveNoise(this.forestOctaveNoise);
        this.setBeachOctaveNoise(this.beachOctaveNoise);
    }

    @Override
    public void provideSurface(Biome[] biomes, ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        double scale = 0.03125;
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        int bedrockFloor = this.worldMinY + this.bedrockFloor;
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        double[] sandNoise = this.beachOctaveNoise.sampleBeta(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, scale, scale, 1.0);
        double[] gravelNoise = this.beachOctaveNoise.sampleBeta(chunkX * 16, 109.0134, chunkZ * 16, 16, 1, 16, scale, 1.0, scale);
        double[] surfaceNoise = this.surfaceOctaveNoise.sampleBeta(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, scale * 2.0, scale * 2.0, scale * 2.0);
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int x = startX + localX;
                int z = startZ + localZ;
                boolean genSandBeach = sandNoise[localZ + localX * 16] + rand.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = gravelNoise[localZ + localX * 16] + rand.nextDouble() * 0.2 > 3.0;
                int surfaceDepth = (int)(surfaceNoise[localZ + localX * 16] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int runDepth = -1;
                Biome biome = biomes[localX + localZ * 16];
                IBlockState topBlock = biome.field_76752_A;
                IBlockState fillerBlock = biome.field_76753_B;
                if (this.useCustomSurfaceBuilder(biome, chunkPrimer, rand, x, z)) continue;
                for (int y = this.worldTopY - 1; y >= this.worldMinY; --y) {
                    if (y <= bedrockFloor + rand.nextInt(5)) {
                        chunkPrimer.func_177855_a(localX, y, localZ, BlockStates.BEDROCK);
                        continue;
                    }
                    IBlockState blockState = chunkPrimer.func_177856_a(localX, y, localZ);
                    if (BlockStates.isAir(blockState)) {
                        runDepth = -1;
                        continue;
                    }
                    if (!BlockStates.isEqual(blockState, this.defaultBlock)) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = this.defaultBlock;
                        } else if (y >= this.seaLevel - 4 && y <= this.seaLevel + 1) {
                            topBlock = biome.field_76752_A;
                            fillerBlock = biome.field_76753_B;
                            if (genGravelBeach) {
                                topBlock = BlockStates.AIR;
                                fillerBlock = BlockStates.GRAVEL;
                            }
                            if (genSandBeach) {
                                topBlock = BlockStates.SAND;
                                fillerBlock = BlockStates.SAND;
                            }
                        }
                        if (y < this.seaLevel && BlockStates.isAir(topBlock)) {
                            topBlock = this.defaultFluid;
                        }
                        runDepth = surfaceDepth;
                        if (y >= this.seaLevel - 1) {
                            chunkPrimer.func_177855_a(localX, y, localZ, topBlock);
                            continue;
                        }
                        chunkPrimer.func_177855_a(localX, y, localZ, fillerBlock);
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    chunkPrimer.func_177855_a(localX, y, localZ, fillerBlock);
                    if (--runDepth != 0 || !BlockStates.isEqual(fillerBlock, BlockStates.SAND)) continue;
                    runDepth = rand.nextInt(4);
                    fillerBlock = BlockStates.SANDSTONE;
                }
            }
        }
    }

    @Override
    protected void sampleNoiseColumn(double[] buffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        int horizNoiseResolution = 16 / (this.noiseSizeX + 1);
        int x = startNoiseX / this.noiseSizeX * 16 + localNoiseX * horizNoiseResolution + horizNoiseResolution / 2;
        int z = startNoiseZ / this.noiseSizeZ * 16 + localNoiseZ * horizNoiseResolution + horizNoiseResolution / 2;
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double depthNoiseScaleX = this.settings.depthNoiseScaleX;
        double depthNoiseScaleZ = this.settings.depthNoiseScaleZ;
        double coordinateScale = this.settings.coordinateScale;
        double heightScale = this.settings.heightScale;
        double mainNoiseScaleX = this.settings.mainNoiseScaleX;
        double mainNoiseScaleY = this.settings.mainNoiseScaleY;
        double mainNoiseScaleZ = this.settings.mainNoiseScaleZ;
        double lowerLimitScale = this.settings.lowerLimitScale;
        double upperLimitScale = this.settings.upperLimitScale;
        double baseSize = this.settings.baseSize;
        double heightStretch = this.settings.stretchY;
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain() * temp;
        rain = 1.0 - rain;
        rain *= rain;
        rain *= rain;
        rain = 1.0 - rain;
        double scale = this.scaleOctaveNoise.sampleXZ(noiseX, noiseZ, 1.121, 1.121);
        scale = (scale + 256.0) / 512.0;
        if ((scale *= rain) > 1.0) {
            scale = 1.0;
        }
        double depth = this.depthOctaveNoise.sampleXZ(noiseX, noiseZ, depthNoiseScaleX, depthNoiseScaleZ);
        if ((depth /= 8000.0) < 0.0) {
            depth = -depth * 0.3;
        }
        if ((depth = depth * 3.0 - 2.0) < 0.0) {
            if ((depth /= 2.0) < -1.0) {
                depth = -1.0;
            }
            depth /= 1.4;
            depth /= 2.0;
            scale = 0.0;
        } else {
            if (depth > 1.0) {
                depth = 1.0;
            }
            depth /= 8.0;
        }
        if (scale < 0.0) {
            scale = 0.0;
        }
        scale += 0.5;
        depth = depth * baseSize / 8.0;
        depth = baseSize + depth * 4.0;
        for (int noiseY = 0; noiseY < buffer.length; ++noiseY) {
            double density;
            double densityOffset = this.getOffset(noiseY, heightStretch, depth, scale);
            double mainNoise = (this.mainOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale / mainNoiseScaleX, heightScale / mainNoiseScaleY, coordinateScale / mainNoiseScaleZ) / 10.0 + 1.0) / 2.0;
            if (mainNoise < 0.0) {
                density = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
            } else if (mainNoise > 1.0) {
                density = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
            } else {
                double minLimitNoise = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
                double maxLimitNoise = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
                density = minLimitNoise + (maxLimitNoise - minLimitNoise) * mainNoise;
            }
            density -= densityOffset;
            buffer[noiseY] = density = this.applySlides(density, noiseY);
        }
    }

    private double getOffset(int noiseY, double heightStretch, double depth, double scale) {
        double offset = ((double)noiseY - depth) * heightStretch / scale;
        if (offset < 0.0) {
            offset *= 4.0;
        }
        return offset;
    }
}

