/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.gen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeSourceType;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSourceType;
import net.minecraft.init.Biomes;
import net.minecraft.util.JsonUtils;

public class ModernBetaChunkGeneratorSettings {
    public final String chunkSource;
    public final String biomeSource;
    public final boolean replaceOceanBiomes;
    public final boolean replaceBeachBiomes;
    public final float coordinateScale;
    public final float heightScale;
    public final float upperLimitScale;
    public final float lowerLimitScale;
    public final float depthNoiseScaleX;
    public final float depthNoiseScaleZ;
    public final float depthNoiseScaleExponent;
    public final float mainNoiseScaleX;
    public final float mainNoiseScaleY;
    public final float mainNoiseScaleZ;
    public final float baseSize;
    public final float stretchY;
    public final int seaLevel;
    public final int height;
    public final boolean useCaves;
    public final boolean useDungeons;
    public final int dungeonChance;
    public final boolean useStrongholds;
    public final boolean useVillages;
    public final boolean useMineShafts;
    public final boolean useTemples;
    public final boolean useMonuments;
    public final boolean useMansions;
    public final boolean useRavines;
    public final boolean useWaterLakes;
    public final int waterLakeChance;
    public final boolean useLavaLakes;
    public final int lavaLakeChance;
    public final boolean useLavaOceans;
    public final String fixedBiome;
    public final int claySize;
    public final int clayCount;
    public final int clayMinHeight;
    public final int clayMaxHeight;
    public final int dirtSize;
    public final int dirtCount;
    public final int dirtMinHeight;
    public final int dirtMaxHeight;
    public final int gravelSize;
    public final int gravelCount;
    public final int gravelMinHeight;
    public final int gravelMaxHeight;
    public final int graniteSize;
    public final int graniteCount;
    public final int graniteMinHeight;
    public final int graniteMaxHeight;
    public final int dioriteSize;
    public final int dioriteCount;
    public final int dioriteMinHeight;
    public final int dioriteMaxHeight;
    public final int andesiteSize;
    public final int andesiteCount;
    public final int andesiteMinHeight;
    public final int andesiteMaxHeight;
    public final int coalSize;
    public final int coalCount;
    public final int coalMinHeight;
    public final int coalMaxHeight;
    public final int ironSize;
    public final int ironCount;
    public final int ironMinHeight;
    public final int ironMaxHeight;
    public final int goldSize;
    public final int goldCount;
    public final int goldMinHeight;
    public final int goldMaxHeight;
    public final int redstoneSize;
    public final int redstoneCount;
    public final int redstoneMinHeight;
    public final int redstoneMaxHeight;
    public final int diamondSize;
    public final int diamondCount;
    public final int diamondMinHeight;
    public final int diamondMaxHeight;
    public final int lapisSize;
    public final int lapisCount;
    public final int lapisCenterHeight;
    public final int lapisSpread;
    public final boolean useTallGrass;
    public final boolean useNewFlowers;
    public final boolean useLilyPads;
    public final boolean useMelons;
    public final boolean useDesertWells;
    public final boolean useFossils;
    public final float tempNoiseScale;
    public final float rainNoiseScale;
    public final float detailNoiseScale;

    private ModernBetaChunkGeneratorSettings(Factory factory) {
        this.chunkSource = factory.chunkSource;
        this.biomeSource = factory.biomeSource;
        this.replaceOceanBiomes = factory.replaceOceanBiomes;
        this.replaceBeachBiomes = factory.replaceBeachBiomes;
        this.coordinateScale = factory.coordinateScale;
        this.heightScale = factory.heightScale;
        this.upperLimitScale = factory.upperLimitScale;
        this.lowerLimitScale = factory.lowerLimitScale;
        this.depthNoiseScaleX = factory.depthNoiseScaleX;
        this.depthNoiseScaleZ = factory.depthNoiseScaleZ;
        this.depthNoiseScaleExponent = factory.depthNoiseScaleExponent;
        this.mainNoiseScaleX = factory.mainNoiseScaleX;
        this.mainNoiseScaleY = factory.mainNoiseScaleY;
        this.mainNoiseScaleZ = factory.mainNoiseScaleZ;
        this.baseSize = factory.baseSize;
        this.stretchY = factory.stretchY;
        this.seaLevel = factory.seaLevel;
        this.height = factory.height;
        this.useCaves = factory.useCaves;
        this.useDungeons = factory.useDungeons;
        this.dungeonChance = factory.dungeonChance;
        this.useStrongholds = factory.useStrongholds;
        this.useVillages = factory.useVillages;
        this.useMineShafts = factory.useMineShafts;
        this.useTemples = factory.useTemples;
        this.useMonuments = factory.useMonuments;
        this.useMansions = factory.useMansions;
        this.useRavines = factory.useRavines;
        this.useWaterLakes = factory.useWaterLakes;
        this.waterLakeChance = factory.waterLakeChance;
        this.useLavaLakes = factory.useLavaLakes;
        this.lavaLakeChance = factory.lavaLakeChance;
        this.useLavaOceans = factory.useLavaOceans;
        this.fixedBiome = factory.fixedBiome;
        this.claySize = factory.claySize;
        this.clayCount = factory.clayCount;
        this.clayMinHeight = factory.clayMinHeight;
        this.clayMaxHeight = factory.clayMaxHeight;
        this.dirtSize = factory.dirtSize;
        this.dirtCount = factory.dirtCount;
        this.dirtMinHeight = factory.dirtMinHeight;
        this.dirtMaxHeight = factory.dirtMaxHeight;
        this.gravelSize = factory.gravelSize;
        this.gravelCount = factory.gravelCount;
        this.gravelMinHeight = factory.gravelMinHeight;
        this.gravelMaxHeight = factory.gravelMaxHeight;
        this.graniteSize = factory.graniteSize;
        this.graniteCount = factory.graniteCount;
        this.graniteMinHeight = factory.graniteMinHeight;
        this.graniteMaxHeight = factory.graniteMaxHeight;
        this.dioriteSize = factory.dioriteSize;
        this.dioriteCount = factory.dioriteCount;
        this.dioriteMinHeight = factory.dioriteMinHeight;
        this.dioriteMaxHeight = factory.dioriteMaxHeight;
        this.andesiteSize = factory.andesiteSize;
        this.andesiteCount = factory.andesiteCount;
        this.andesiteMinHeight = factory.andesiteMinHeight;
        this.andesiteMaxHeight = factory.andesiteMaxHeight;
        this.coalSize = factory.coalSize;
        this.coalCount = factory.coalCount;
        this.coalMinHeight = factory.coalMinHeight;
        this.coalMaxHeight = factory.coalMaxHeight;
        this.ironSize = factory.ironSize;
        this.ironCount = factory.ironCount;
        this.ironMinHeight = factory.ironMinHeight;
        this.ironMaxHeight = factory.ironMaxHeight;
        this.goldSize = factory.goldSize;
        this.goldCount = factory.goldCount;
        this.goldMinHeight = factory.goldMinHeight;
        this.goldMaxHeight = factory.goldMaxHeight;
        this.redstoneSize = factory.redstoneSize;
        this.redstoneCount = factory.redstoneCount;
        this.redstoneMinHeight = factory.redstoneMinHeight;
        this.redstoneMaxHeight = factory.redstoneMaxHeight;
        this.diamondSize = factory.diamondSize;
        this.diamondCount = factory.diamondCount;
        this.diamondMinHeight = factory.diamondMinHeight;
        this.diamondMaxHeight = factory.diamondMaxHeight;
        this.lapisSize = factory.lapisSize;
        this.lapisCount = factory.lapisCount;
        this.lapisCenterHeight = factory.lapisCenterHeight;
        this.lapisSpread = factory.lapisSpread;
        this.useTallGrass = factory.useTallGrass;
        this.useNewFlowers = factory.useNewFlowers;
        this.useLilyPads = factory.useLilyPads;
        this.useMelons = factory.useMelons;
        this.useDesertWells = factory.useDesertWells;
        this.useFossils = factory.useFossils;
        this.tempNoiseScale = factory.tempNoiseScale;
        this.rainNoiseScale = factory.rainNoiseScale;
        this.detailNoiseScale = factory.detailNoiseScale;
    }

    public static class Serializer
    implements JsonDeserializer<Factory>,
    JsonSerializer<Factory> {
        public Factory deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Factory factory = new Factory();
            try {
                factory.chunkSource = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"chunkSource", (String)factory.chunkSource);
                factory.biomeSource = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"biomeSource", (String)factory.biomeSource);
                factory.replaceOceanBiomes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"replaceOceanBiomes", (boolean)factory.replaceOceanBiomes);
                factory.replaceBeachBiomes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"replaceBeachBiomes", (boolean)factory.replaceBeachBiomes);
                factory.coordinateScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"coordinateScale", (float)factory.coordinateScale);
                factory.heightScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"heightScale", (float)factory.heightScale);
                factory.lowerLimitScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"lowerLimitScale", (float)factory.lowerLimitScale);
                factory.upperLimitScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"upperLimitScale", (float)factory.upperLimitScale);
                factory.depthNoiseScaleX = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"depthNoiseScaleX", (float)factory.depthNoiseScaleX);
                factory.depthNoiseScaleZ = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"depthNoiseScaleZ", (float)factory.depthNoiseScaleZ);
                factory.depthNoiseScaleExponent = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"depthNoiseScaleExponent", (float)factory.depthNoiseScaleExponent);
                factory.mainNoiseScaleX = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"mainNoiseScaleX", (float)factory.mainNoiseScaleX);
                factory.mainNoiseScaleY = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"mainNoiseScaleY", (float)factory.mainNoiseScaleY);
                factory.mainNoiseScaleZ = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"mainNoiseScaleZ", (float)factory.mainNoiseScaleZ);
                factory.baseSize = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"baseSize", (float)factory.baseSize);
                factory.stretchY = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"stretchY", (float)factory.stretchY);
                factory.seaLevel = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"seaLevel", (int)factory.seaLevel);
                factory.height = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"height", (int)factory.height);
                factory.useCaves = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useCaves", (boolean)factory.useCaves);
                factory.useDungeons = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useDungeons", (boolean)factory.useDungeons);
                factory.dungeonChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dungeonChance", (int)factory.dungeonChance);
                factory.useStrongholds = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useStrongholds", (boolean)factory.useStrongholds);
                factory.useVillages = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useVillages", (boolean)factory.useVillages);
                factory.useMineShafts = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMineShafts", (boolean)factory.useMineShafts);
                factory.useTemples = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useTemples", (boolean)factory.useTemples);
                factory.useMonuments = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMonuments", (boolean)factory.useMonuments);
                factory.useMansions = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMansions", (boolean)factory.useMansions);
                factory.useRavines = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useRavines", (boolean)factory.useRavines);
                factory.useWaterLakes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useWaterLakes", (boolean)factory.useWaterLakes);
                factory.waterLakeChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"waterLakeChance", (int)factory.waterLakeChance);
                factory.useLavaLakes = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLavaLakes", (boolean)factory.useLavaLakes);
                factory.lavaLakeChance = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lavaLakeChance", (int)factory.lavaLakeChance);
                factory.useLavaOceans = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLavaOceans", (boolean)factory.useLavaOceans);
                factory.fixedBiome = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"fixedBiome", (String)factory.fixedBiome);
                factory.claySize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"claySize", (int)factory.claySize);
                factory.clayCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"clayCount", (int)factory.clayCount);
                factory.clayMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"clayMinHeight", (int)factory.clayMinHeight);
                factory.clayMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"clayMaxHeight", (int)factory.clayMaxHeight);
                factory.dirtSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtSize", (int)factory.dirtSize);
                factory.dirtCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtCount", (int)factory.dirtCount);
                factory.dirtMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtMinHeight", (int)factory.dirtMinHeight);
                factory.dirtMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dirtMaxHeight", (int)factory.dirtMaxHeight);
                factory.gravelSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelSize", (int)factory.gravelSize);
                factory.gravelCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelCount", (int)factory.gravelCount);
                factory.gravelMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelMinHeight", (int)factory.gravelMinHeight);
                factory.gravelMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"gravelMaxHeight", (int)factory.gravelMaxHeight);
                factory.graniteSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteSize", (int)factory.graniteSize);
                factory.graniteCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteCount", (int)factory.graniteCount);
                factory.graniteMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteMinHeight", (int)factory.graniteMinHeight);
                factory.graniteMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"graniteMaxHeight", (int)factory.graniteMaxHeight);
                factory.dioriteSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteSize", (int)factory.dioriteSize);
                factory.dioriteCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteCount", (int)factory.dioriteCount);
                factory.dioriteMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteMinHeight", (int)factory.dioriteMinHeight);
                factory.dioriteMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"dioriteMaxHeight", (int)factory.dioriteMaxHeight);
                factory.andesiteSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteSize", (int)factory.andesiteSize);
                factory.andesiteCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteCount", (int)factory.andesiteCount);
                factory.andesiteMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteMinHeight", (int)factory.andesiteMinHeight);
                factory.andesiteMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"andesiteMaxHeight", (int)factory.andesiteMaxHeight);
                factory.coalSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalSize", (int)factory.coalSize);
                factory.coalCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalCount", (int)factory.coalCount);
                factory.coalMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalMinHeight", (int)factory.coalMinHeight);
                factory.coalMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"coalMaxHeight", (int)factory.coalMaxHeight);
                factory.ironSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironSize", (int)factory.ironSize);
                factory.ironCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironCount", (int)factory.ironCount);
                factory.ironMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironMinHeight", (int)factory.ironMinHeight);
                factory.ironMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"ironMaxHeight", (int)factory.ironMaxHeight);
                factory.goldSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldSize", (int)factory.goldSize);
                factory.goldCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldCount", (int)factory.goldCount);
                factory.goldMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldMinHeight", (int)factory.goldMinHeight);
                factory.goldMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"goldMaxHeight", (int)factory.goldMaxHeight);
                factory.redstoneSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneSize", (int)factory.redstoneSize);
                factory.redstoneCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneCount", (int)factory.redstoneCount);
                factory.redstoneMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneMinHeight", (int)factory.redstoneMinHeight);
                factory.redstoneMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"redstoneMaxHeight", (int)factory.redstoneMaxHeight);
                factory.diamondSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondSize", (int)factory.diamondSize);
                factory.diamondCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondCount", (int)factory.diamondCount);
                factory.diamondMinHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondMinHeight", (int)factory.diamondMinHeight);
                factory.diamondMaxHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"diamondMaxHeight", (int)factory.diamondMaxHeight);
                factory.lapisSize = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisSize", (int)factory.lapisSize);
                factory.lapisCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisCount", (int)factory.lapisCount);
                factory.lapisCenterHeight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisCenterHeight", (int)factory.lapisCenterHeight);
                factory.lapisSpread = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"lapisSpread", (int)factory.lapisSpread);
                factory.useTallGrass = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useTallGrass", (boolean)factory.useTallGrass);
                factory.useNewFlowers = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useNewFlowers", (boolean)factory.useNewFlowers);
                factory.useLilyPads = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useLilyPads", (boolean)factory.useLilyPads);
                factory.useMelons = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useMelons", (boolean)factory.useMelons);
                factory.useDesertWells = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useDesertWells", (boolean)factory.useDesertWells);
                factory.useFossils = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"useFossils", (boolean)factory.useFossils);
                factory.tempNoiseScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"tempNoiseScale", (float)factory.tempNoiseScale);
                factory.rainNoiseScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"rainNoiseScale", (float)factory.rainNoiseScale);
                factory.detailNoiseScale = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"detailNoiseScale", (float)factory.detailNoiseScale);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return factory;
        }

        public JsonElement serialize(Factory factory, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("chunkSource", factory.chunkSource);
            jsonObject.addProperty("biomeSource", factory.biomeSource);
            jsonObject.addProperty("replaceOceanBiomes", Boolean.valueOf(factory.replaceOceanBiomes));
            jsonObject.addProperty("replaceBeachBiomes", Boolean.valueOf(factory.replaceBeachBiomes));
            jsonObject.addProperty("coordinateScale", (Number)Float.valueOf(factory.coordinateScale));
            jsonObject.addProperty("heightScale", (Number)Float.valueOf(factory.heightScale));
            jsonObject.addProperty("lowerLimitScale", (Number)Float.valueOf(factory.lowerLimitScale));
            jsonObject.addProperty("upperLimitScale", (Number)Float.valueOf(factory.upperLimitScale));
            jsonObject.addProperty("depthNoiseScaleX", (Number)Float.valueOf(factory.depthNoiseScaleX));
            jsonObject.addProperty("depthNoiseScaleZ", (Number)Float.valueOf(factory.depthNoiseScaleZ));
            jsonObject.addProperty("depthNoiseScaleExponent", (Number)Float.valueOf(factory.depthNoiseScaleExponent));
            jsonObject.addProperty("mainNoiseScaleX", (Number)Float.valueOf(factory.mainNoiseScaleX));
            jsonObject.addProperty("mainNoiseScaleY", (Number)Float.valueOf(factory.mainNoiseScaleY));
            jsonObject.addProperty("mainNoiseScaleZ", (Number)Float.valueOf(factory.mainNoiseScaleZ));
            jsonObject.addProperty("baseSize", (Number)Float.valueOf(factory.baseSize));
            jsonObject.addProperty("stretchY", (Number)Float.valueOf(factory.stretchY));
            jsonObject.addProperty("seaLevel", (Number)factory.seaLevel);
            jsonObject.addProperty("height", (Number)factory.height);
            jsonObject.addProperty("useCaves", Boolean.valueOf(factory.useCaves));
            jsonObject.addProperty("useDungeons", Boolean.valueOf(factory.useDungeons));
            jsonObject.addProperty("dungeonChance", (Number)factory.dungeonChance);
            jsonObject.addProperty("useStrongholds", Boolean.valueOf(factory.useStrongholds));
            jsonObject.addProperty("useVillages", Boolean.valueOf(factory.useVillages));
            jsonObject.addProperty("useMineShafts", Boolean.valueOf(factory.useMineShafts));
            jsonObject.addProperty("useTemples", Boolean.valueOf(factory.useTemples));
            jsonObject.addProperty("useMonuments", Boolean.valueOf(factory.useMonuments));
            jsonObject.addProperty("useMansions", Boolean.valueOf(factory.useMansions));
            jsonObject.addProperty("useRavines", Boolean.valueOf(factory.useRavines));
            jsonObject.addProperty("useWaterLakes", Boolean.valueOf(factory.useWaterLakes));
            jsonObject.addProperty("waterLakeChance", (Number)factory.waterLakeChance);
            jsonObject.addProperty("useLavaLakes", Boolean.valueOf(factory.useLavaLakes));
            jsonObject.addProperty("lavaLakeChance", (Number)factory.lavaLakeChance);
            jsonObject.addProperty("useLavaOceans", Boolean.valueOf(factory.useLavaOceans));
            jsonObject.addProperty("fixedBiome", factory.fixedBiome);
            jsonObject.addProperty("claySize", (Number)factory.claySize);
            jsonObject.addProperty("clayCount", (Number)factory.clayCount);
            jsonObject.addProperty("clayMinHeight", (Number)factory.clayMinHeight);
            jsonObject.addProperty("clayMaxHeight", (Number)factory.clayMaxHeight);
            jsonObject.addProperty("dirtSize", (Number)factory.dirtSize);
            jsonObject.addProperty("dirtCount", (Number)factory.dirtCount);
            jsonObject.addProperty("dirtMinHeight", (Number)factory.dirtMinHeight);
            jsonObject.addProperty("dirtMaxHeight", (Number)factory.dirtMaxHeight);
            jsonObject.addProperty("gravelSize", (Number)factory.gravelSize);
            jsonObject.addProperty("gravelCount", (Number)factory.gravelCount);
            jsonObject.addProperty("gravelMinHeight", (Number)factory.gravelMinHeight);
            jsonObject.addProperty("gravelMaxHeight", (Number)factory.gravelMaxHeight);
            jsonObject.addProperty("graniteSize", (Number)factory.graniteSize);
            jsonObject.addProperty("graniteCount", (Number)factory.graniteCount);
            jsonObject.addProperty("graniteMinHeight", (Number)factory.graniteMinHeight);
            jsonObject.addProperty("graniteMaxHeight", (Number)factory.graniteMaxHeight);
            jsonObject.addProperty("dioriteSize", (Number)factory.dioriteSize);
            jsonObject.addProperty("dioriteCount", (Number)factory.dioriteCount);
            jsonObject.addProperty("dioriteMinHeight", (Number)factory.dioriteMinHeight);
            jsonObject.addProperty("dioriteMaxHeight", (Number)factory.dioriteMaxHeight);
            jsonObject.addProperty("andesiteSize", (Number)factory.andesiteSize);
            jsonObject.addProperty("andesiteCount", (Number)factory.andesiteCount);
            jsonObject.addProperty("andesiteMinHeight", (Number)factory.andesiteMinHeight);
            jsonObject.addProperty("andesiteMaxHeight", (Number)factory.andesiteMaxHeight);
            jsonObject.addProperty("coalSize", (Number)factory.coalSize);
            jsonObject.addProperty("coalCount", (Number)factory.coalCount);
            jsonObject.addProperty("coalMinHeight", (Number)factory.coalMinHeight);
            jsonObject.addProperty("coalMaxHeight", (Number)factory.coalMaxHeight);
            jsonObject.addProperty("ironSize", (Number)factory.ironSize);
            jsonObject.addProperty("ironCount", (Number)factory.ironCount);
            jsonObject.addProperty("ironMinHeight", (Number)factory.ironMinHeight);
            jsonObject.addProperty("ironMaxHeight", (Number)factory.ironMaxHeight);
            jsonObject.addProperty("goldSize", (Number)factory.goldSize);
            jsonObject.addProperty("goldCount", (Number)factory.goldCount);
            jsonObject.addProperty("goldMinHeight", (Number)factory.goldMinHeight);
            jsonObject.addProperty("goldMaxHeight", (Number)factory.goldMaxHeight);
            jsonObject.addProperty("redstoneSize", (Number)factory.redstoneSize);
            jsonObject.addProperty("redstoneCount", (Number)factory.redstoneCount);
            jsonObject.addProperty("redstoneMinHeight", (Number)factory.redstoneMinHeight);
            jsonObject.addProperty("redstoneMaxHeight", (Number)factory.redstoneMaxHeight);
            jsonObject.addProperty("diamondSize", (Number)factory.diamondSize);
            jsonObject.addProperty("diamondCount", (Number)factory.diamondCount);
            jsonObject.addProperty("diamondMinHeight", (Number)factory.diamondMinHeight);
            jsonObject.addProperty("diamondMaxHeight", (Number)factory.diamondMaxHeight);
            jsonObject.addProperty("lapisSize", (Number)factory.lapisSize);
            jsonObject.addProperty("lapisCount", (Number)factory.lapisCount);
            jsonObject.addProperty("lapisCenterHeight", (Number)factory.lapisCenterHeight);
            jsonObject.addProperty("lapisSpread", (Number)factory.lapisSpread);
            jsonObject.addProperty("useTallGrass", Boolean.valueOf(factory.useTallGrass));
            jsonObject.addProperty("useNewFlowers", Boolean.valueOf(factory.useNewFlowers));
            jsonObject.addProperty("useLilyPads", Boolean.valueOf(factory.useLilyPads));
            jsonObject.addProperty("useMelons", Boolean.valueOf(factory.useMelons));
            jsonObject.addProperty("useDesertWells", Boolean.valueOf(factory.useDesertWells));
            jsonObject.addProperty("useFossils", Boolean.valueOf(factory.useFossils));
            jsonObject.addProperty("tempNoiseScale", (Number)Float.valueOf(factory.tempNoiseScale));
            jsonObject.addProperty("rainNoiseScale", (Number)Float.valueOf(factory.rainNoiseScale));
            jsonObject.addProperty("detailNoiseScale", (Number)Float.valueOf(factory.detailNoiseScale));
            return jsonObject;
        }
    }

    public static class Factory {
        static final Gson JSON_ADAPTER = new GsonBuilder().registerTypeAdapter(Factory.class, (Object)new Serializer()).create();
        public String chunkSource = ChunkSourceType.BETA.getId();
        public String biomeSource = BiomeSourceType.BETA.getId();
        public boolean replaceOceanBiomes = true;
        public boolean replaceBeachBiomes = true;
        public float coordinateScale = 684.412f;
        public float heightScale = 684.412f;
        public float upperLimitScale = 512.0f;
        public float lowerLimitScale = 512.0f;
        public float depthNoiseScaleX = 200.0f;
        public float depthNoiseScaleZ = 200.0f;
        public float depthNoiseScaleExponent = 0.5f;
        public float mainNoiseScaleX = 80.0f;
        public float mainNoiseScaleY = 160.0f;
        public float mainNoiseScaleZ = 80.0f;
        public float baseSize = 8.5f;
        public float stretchY = 12.0f;
        public int seaLevel = 64;
        public int height = 128;
        public boolean useCaves = true;
        public boolean useDungeons = true;
        public int dungeonChance = 8;
        public boolean useStrongholds = true;
        public boolean useVillages = true;
        public boolean useMineShafts = true;
        public boolean useTemples = true;
        public boolean useMonuments = true;
        public boolean useMansions = true;
        public boolean useRavines = true;
        public boolean useWaterLakes = true;
        public int waterLakeChance = 4;
        public boolean useLavaLakes = true;
        public int lavaLakeChance = 80;
        public boolean useLavaOceans;
        public String fixedBiome = Biomes.field_76772_c.getRegistryName().toString();
        public int claySize = 33;
        public int clayCount = 10;
        public int clayMinHeight = 0;
        public int clayMaxHeight = 128;
        public int dirtSize = 33;
        public int dirtCount = 20;
        public int dirtMinHeight = 0;
        public int dirtMaxHeight = 128;
        public int gravelSize = 33;
        public int gravelCount = 10;
        public int gravelMinHeight = 0;
        public int gravelMaxHeight = 128;
        public int graniteSize = 33;
        public int graniteCount = 10;
        public int graniteMinHeight = 0;
        public int graniteMaxHeight = 80;
        public int dioriteSize = 33;
        public int dioriteCount = 10;
        public int dioriteMinHeight = 0;
        public int dioriteMaxHeight = 80;
        public int andesiteSize = 33;
        public int andesiteCount = 10;
        public int andesiteMinHeight = 0;
        public int andesiteMaxHeight = 80;
        public int coalSize = 17;
        public int coalCount = 20;
        public int coalMinHeight = 0;
        public int coalMaxHeight = 128;
        public int ironSize = 9;
        public int ironCount = 20;
        public int ironMinHeight = 0;
        public int ironMaxHeight = 64;
        public int goldSize = 9;
        public int goldCount = 2;
        public int goldMinHeight = 0;
        public int goldMaxHeight = 32;
        public int redstoneSize = 8;
        public int redstoneCount = 8;
        public int redstoneMinHeight = 0;
        public int redstoneMaxHeight = 16;
        public int diamondSize = 8;
        public int diamondCount = 1;
        public int diamondMinHeight = 0;
        public int diamondMaxHeight = 16;
        public int lapisSize = 7;
        public int lapisCount = 1;
        public int lapisCenterHeight = 16;
        public int lapisSpread = 16;
        public boolean useTallGrass = true;
        public boolean useNewFlowers = true;
        public boolean useLilyPads = true;
        public boolean useMelons = true;
        public boolean useDesertWells = true;
        public boolean useFossils = true;
        public float tempNoiseScale = 1.0f;
        public float rainNoiseScale = 1.0f;
        public float detailNoiseScale = 1.0f;

        public static Factory jsonToFactory(String string) {
            if (string.isEmpty()) {
                return new Factory();
            }
            try {
                return (Factory)JsonUtils.func_188178_a((Gson)JSON_ADAPTER, (String)string, Factory.class);
            }
            catch (Exception lvt_1_1_) {
                return new Factory();
            }
        }

        public String toString() {
            return JSON_ADAPTER.toJson((Object)this);
        }

        public Factory() {
            this.setDefaults();
        }

        public void setDefaults() {
            this.chunkSource = ChunkSourceType.BETA.getId();
            this.biomeSource = BiomeSourceType.BETA.getId();
            this.replaceOceanBiomes = true;
            this.replaceBeachBiomes = true;
            this.coordinateScale = 684.412f;
            this.heightScale = 684.412f;
            this.upperLimitScale = 512.0f;
            this.lowerLimitScale = 512.0f;
            this.depthNoiseScaleX = 200.0f;
            this.depthNoiseScaleZ = 200.0f;
            this.depthNoiseScaleExponent = 0.5f;
            this.mainNoiseScaleX = 80.0f;
            this.mainNoiseScaleY = 160.0f;
            this.mainNoiseScaleZ = 80.0f;
            this.baseSize = 8.5f;
            this.stretchY = 12.0f;
            this.seaLevel = 64;
            this.height = 128;
            this.useCaves = true;
            this.useDungeons = true;
            this.dungeonChance = 8;
            this.useStrongholds = true;
            this.useVillages = true;
            this.useMineShafts = true;
            this.useTemples = true;
            this.useMonuments = true;
            this.useMansions = true;
            this.useRavines = true;
            this.useWaterLakes = true;
            this.waterLakeChance = 4;
            this.useLavaLakes = true;
            this.lavaLakeChance = 80;
            this.useLavaOceans = false;
            this.fixedBiome = Biomes.field_76772_c.getRegistryName().toString();
            this.claySize = 33;
            this.clayCount = 10;
            this.clayMinHeight = 0;
            this.clayMaxHeight = 128;
            this.dirtSize = 33;
            this.dirtCount = 20;
            this.dirtMinHeight = 0;
            this.dirtMaxHeight = 128;
            this.gravelSize = 33;
            this.gravelCount = 10;
            this.gravelMinHeight = 0;
            this.gravelMaxHeight = 128;
            this.graniteSize = 33;
            this.graniteCount = 10;
            this.graniteMinHeight = 0;
            this.graniteMaxHeight = 80;
            this.dioriteSize = 33;
            this.dioriteCount = 10;
            this.dioriteMinHeight = 0;
            this.dioriteMaxHeight = 80;
            this.andesiteSize = 33;
            this.andesiteCount = 10;
            this.andesiteMinHeight = 0;
            this.andesiteMaxHeight = 80;
            this.coalSize = 17;
            this.coalCount = 20;
            this.coalMinHeight = 0;
            this.coalMaxHeight = 128;
            this.ironSize = 9;
            this.ironCount = 20;
            this.ironMinHeight = 0;
            this.ironMaxHeight = 64;
            this.goldSize = 9;
            this.goldCount = 2;
            this.goldMinHeight = 0;
            this.goldMaxHeight = 32;
            this.redstoneSize = 8;
            this.redstoneCount = 8;
            this.redstoneMinHeight = 0;
            this.redstoneMaxHeight = 16;
            this.diamondSize = 8;
            this.diamondCount = 1;
            this.diamondMinHeight = 0;
            this.diamondMaxHeight = 16;
            this.lapisSize = 7;
            this.lapisCount = 1;
            this.lapisCenterHeight = 16;
            this.lapisSpread = 16;
            this.useTallGrass = true;
            this.useNewFlowers = true;
            this.useLilyPads = true;
            this.useMelons = true;
            this.useDesertWells = true;
            this.useFossils = true;
            this.tempNoiseScale = 1.0f;
            this.rainNoiseScale = 1.0f;
            this.detailNoiseScale = 1.0f;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Factory factory = (Factory)object;
            return this.andesiteCount == factory.andesiteCount && this.andesiteMaxHeight == factory.andesiteMaxHeight && this.andesiteMinHeight == factory.andesiteMinHeight && this.andesiteSize == factory.andesiteSize && Float.compare(factory.baseSize, this.baseSize) == 0 && this.coalCount == factory.coalCount && this.coalMaxHeight == factory.coalMaxHeight && this.coalMinHeight == factory.coalMinHeight && this.coalSize == factory.coalSize && Float.compare(factory.coordinateScale, this.coordinateScale) == 0 && Float.compare(factory.depthNoiseScaleExponent, this.depthNoiseScaleExponent) == 0 && Float.compare(factory.depthNoiseScaleX, this.depthNoiseScaleX) == 0 && Float.compare(factory.depthNoiseScaleZ, this.depthNoiseScaleZ) == 0 && this.diamondCount == factory.diamondCount && this.diamondMaxHeight == factory.diamondMaxHeight && this.diamondMinHeight == factory.diamondMinHeight && this.diamondSize == factory.diamondSize && this.dioriteCount == factory.dioriteCount && this.dioriteMaxHeight == factory.dioriteMaxHeight && this.dioriteMinHeight == factory.dioriteMinHeight && this.dioriteSize == factory.dioriteSize && this.dirtCount == factory.dirtCount && this.dirtMaxHeight == factory.dirtMaxHeight && this.dirtMinHeight == factory.dirtMinHeight && this.dirtSize == factory.dirtSize && this.dungeonChance == factory.dungeonChance && this.fixedBiome.equals(factory.fixedBiome) && this.goldCount == factory.goldCount && this.goldMaxHeight == factory.goldMaxHeight && this.goldMinHeight == factory.goldMinHeight && this.goldSize == factory.goldSize && this.graniteCount == factory.graniteCount && this.graniteMaxHeight == factory.graniteMaxHeight && this.graniteMinHeight == factory.graniteMinHeight && this.graniteSize == factory.graniteSize && this.gravelCount == factory.gravelCount && this.gravelMaxHeight == factory.gravelMaxHeight && this.gravelMinHeight == factory.gravelMinHeight && this.gravelSize == factory.gravelSize && Float.compare(factory.heightScale, this.heightScale) == 0 && this.ironCount == factory.ironCount && this.ironMaxHeight == factory.ironMaxHeight && this.ironMinHeight == factory.ironMinHeight && this.ironSize == factory.ironSize && this.lapisCenterHeight == factory.lapisCenterHeight && this.lapisCount == factory.lapisCount && this.lapisSize == factory.lapisSize && this.lapisSpread == factory.lapisSpread && this.lavaLakeChance == factory.lavaLakeChance && Float.compare(factory.lowerLimitScale, this.lowerLimitScale) == 0 && Float.compare(factory.mainNoiseScaleX, this.mainNoiseScaleX) == 0 && Float.compare(factory.mainNoiseScaleY, this.mainNoiseScaleY) == 0 && Float.compare(factory.mainNoiseScaleZ, this.mainNoiseScaleZ) == 0 && this.redstoneCount == factory.redstoneCount && this.redstoneMaxHeight == factory.redstoneMaxHeight && this.redstoneMinHeight == factory.redstoneMinHeight && this.redstoneSize == factory.redstoneSize && this.seaLevel == factory.seaLevel && this.height == factory.height && Float.compare(factory.stretchY, this.stretchY) == 0 && Float.compare(factory.upperLimitScale, this.upperLimitScale) == 0 && this.useCaves == factory.useCaves && this.useDungeons == factory.useDungeons && this.useLavaLakes == factory.useLavaLakes && this.useLavaOceans == factory.useLavaOceans && this.useMineShafts == factory.useMineShafts && this.useRavines == factory.useRavines && this.useStrongholds == factory.useStrongholds && this.useTemples == factory.useTemples && this.useMonuments == factory.useMonuments && this.useMansions == factory.useMansions && this.useVillages == factory.useVillages && this.useWaterLakes == factory.useWaterLakes && this.waterLakeChance == factory.waterLakeChance && this.chunkSource.equals(factory.chunkSource) && this.biomeSource.equals(factory.biomeSource) && this.replaceOceanBiomes == factory.replaceOceanBiomes && this.replaceBeachBiomes == factory.replaceBeachBiomes && this.claySize == factory.claySize && this.clayMaxHeight == factory.clayMaxHeight && this.clayMinHeight == factory.clayMinHeight && this.clayCount == factory.clayCount && this.useTallGrass == factory.useTallGrass && this.useNewFlowers == factory.useNewFlowers && this.useLilyPads == factory.useLilyPads && this.useMelons == factory.useMelons && this.useDesertWells == factory.useDesertWells && this.useFossils == factory.useFossils && this.tempNoiseScale == factory.tempNoiseScale && this.rainNoiseScale == factory.rainNoiseScale && this.detailNoiseScale == factory.detailNoiseScale;
        }

        public int hashCode() {
            int hashCode = this.coordinateScale == 0.0f ? 0 : Float.floatToIntBits(this.coordinateScale);
            hashCode = 31 * hashCode + (this.heightScale == 0.0f ? 0 : Float.floatToIntBits(this.heightScale));
            hashCode = 31 * hashCode + (this.upperLimitScale == 0.0f ? 0 : Float.floatToIntBits(this.upperLimitScale));
            hashCode = 31 * hashCode + (this.lowerLimitScale == 0.0f ? 0 : Float.floatToIntBits(this.lowerLimitScale));
            hashCode = 31 * hashCode + (this.depthNoiseScaleX == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleX));
            hashCode = 31 * hashCode + (this.depthNoiseScaleZ == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleZ));
            hashCode = 31 * hashCode + (this.depthNoiseScaleExponent == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleExponent));
            hashCode = 31 * hashCode + (this.mainNoiseScaleX == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleX));
            hashCode = 31 * hashCode + (this.mainNoiseScaleY == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleY));
            hashCode = 31 * hashCode + (this.mainNoiseScaleZ == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleZ));
            hashCode = 31 * hashCode + (this.baseSize == 0.0f ? 0 : Float.floatToIntBits(this.baseSize));
            hashCode = 31 * hashCode + (this.stretchY == 0.0f ? 0 : Float.floatToIntBits(this.stretchY));
            hashCode = 31 * hashCode + this.seaLevel;
            hashCode = 31 * hashCode + this.height;
            hashCode = 31 * hashCode + (this.useCaves ? 1 : 0);
            hashCode = 31 * hashCode + (this.useDungeons ? 1 : 0);
            hashCode = 31 * hashCode + this.dungeonChance;
            hashCode = 31 * hashCode + (this.useStrongholds ? 1 : 0);
            hashCode = 31 * hashCode + (this.useVillages ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMineShafts ? 1 : 0);
            hashCode = 31 * hashCode + (this.useTemples ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMonuments ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMansions ? 1 : 0);
            hashCode = 31 * hashCode + (this.useRavines ? 1 : 0);
            hashCode = 31 * hashCode + (this.useWaterLakes ? 1 : 0);
            hashCode = 31 * hashCode + this.waterLakeChance;
            hashCode = 31 * hashCode + (this.useLavaLakes ? 1 : 0);
            hashCode = 31 * hashCode + this.lavaLakeChance;
            hashCode = 31 * hashCode + (this.useLavaOceans ? 1 : 0);
            hashCode = 31 * hashCode + this.fixedBiome.hashCode();
            hashCode = 31 * hashCode + this.claySize;
            hashCode = 31 * hashCode + this.clayCount;
            hashCode = 31 * hashCode + this.clayMinHeight;
            hashCode = 31 * hashCode + this.clayMaxHeight;
            hashCode = 31 * hashCode + this.dirtSize;
            hashCode = 31 * hashCode + this.dirtCount;
            hashCode = 31 * hashCode + this.dirtMinHeight;
            hashCode = 31 * hashCode + this.dirtMaxHeight;
            hashCode = 31 * hashCode + this.gravelSize;
            hashCode = 31 * hashCode + this.gravelCount;
            hashCode = 31 * hashCode + this.gravelMinHeight;
            hashCode = 31 * hashCode + this.gravelMaxHeight;
            hashCode = 31 * hashCode + this.graniteSize;
            hashCode = 31 * hashCode + this.graniteCount;
            hashCode = 31 * hashCode + this.graniteMinHeight;
            hashCode = 31 * hashCode + this.graniteMaxHeight;
            hashCode = 31 * hashCode + this.dioriteSize;
            hashCode = 31 * hashCode + this.dioriteCount;
            hashCode = 31 * hashCode + this.dioriteMinHeight;
            hashCode = 31 * hashCode + this.dioriteMaxHeight;
            hashCode = 31 * hashCode + this.andesiteSize;
            hashCode = 31 * hashCode + this.andesiteCount;
            hashCode = 31 * hashCode + this.andesiteMinHeight;
            hashCode = 31 * hashCode + this.andesiteMaxHeight;
            hashCode = 31 * hashCode + this.coalSize;
            hashCode = 31 * hashCode + this.coalCount;
            hashCode = 31 * hashCode + this.coalMinHeight;
            hashCode = 31 * hashCode + this.coalMaxHeight;
            hashCode = 31 * hashCode + this.ironSize;
            hashCode = 31 * hashCode + this.ironCount;
            hashCode = 31 * hashCode + this.ironMinHeight;
            hashCode = 31 * hashCode + this.ironMaxHeight;
            hashCode = 31 * hashCode + this.goldSize;
            hashCode = 31 * hashCode + this.goldCount;
            hashCode = 31 * hashCode + this.goldMinHeight;
            hashCode = 31 * hashCode + this.goldMaxHeight;
            hashCode = 31 * hashCode + this.redstoneSize;
            hashCode = 31 * hashCode + this.redstoneCount;
            hashCode = 31 * hashCode + this.redstoneMinHeight;
            hashCode = 31 * hashCode + this.redstoneMaxHeight;
            hashCode = 31 * hashCode + this.diamondSize;
            hashCode = 31 * hashCode + this.diamondCount;
            hashCode = 31 * hashCode + this.diamondMinHeight;
            hashCode = 31 * hashCode + this.diamondMaxHeight;
            hashCode = 31 * hashCode + this.lapisSize;
            hashCode = 31 * hashCode + this.lapisCount;
            hashCode = 31 * hashCode + this.lapisCenterHeight;
            hashCode = 31 * hashCode + this.lapisSpread;
            hashCode = 31 * hashCode + (this.replaceOceanBiomes ? 1 : 0);
            hashCode = 31 * hashCode + (this.replaceBeachBiomes ? 1 : 0);
            hashCode = 31 * hashCode + this.chunkSource.hashCode();
            hashCode = 31 * hashCode + this.biomeSource.hashCode();
            hashCode = 31 * hashCode + (this.useTallGrass ? 1 : 0);
            hashCode = 31 * hashCode + (this.useNewFlowers ? 1 : 0);
            hashCode = 31 * hashCode + (this.useLilyPads ? 1 : 0);
            hashCode = 31 * hashCode + (this.useMelons ? 1 : 0);
            hashCode = 31 * hashCode + (this.useDesertWells ? 1 : 0);
            hashCode = 31 * hashCode + (this.useFossils ? 1 : 0);
            hashCode = 31 * hashCode + (this.tempNoiseScale == 0.0f ? 0 : Float.floatToIntBits(this.tempNoiseScale));
            hashCode = 31 * hashCode + (this.rainNoiseScale == 0.0f ? 0 : Float.floatToIntBits(this.rainNoiseScale));
            hashCode = 31 * hashCode + (this.detailNoiseScale == 0.0f ? 0 : Float.floatToIntBits(this.detailNoiseScale));
            return hashCode;
        }

        public ModernBetaChunkGeneratorSettings build() {
            return new ModernBetaChunkGeneratorSettings(this);
        }
    }
}

