/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.gen;

import java.util.List;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSourceType;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;

public class ModernBetaChunkGenerator
extends ChunkGeneratorOverworld {
    private final ChunkSource chunkSource;

    public ModernBetaChunkGenerator(World world, long seed, boolean mapFeaturesEnabled, String generatorOptions) {
        super(world, seed, mapFeaturesEnabled, generatorOptions);
        ModernBetaChunkGeneratorSettings settings = generatorOptions != null ? ModernBetaChunkGeneratorSettings.Factory.jsonToFactory(generatorOptions).build() : new ModernBetaChunkGeneratorSettings.Factory().build();
        this.chunkSource = ChunkSourceType.fromId(settings.chunkSource).create(world, this, settings, seed, mapFeaturesEnabled);
    }

    public void func_185976_a(int x, int z, ChunkPrimer primer) {
        this.chunkSource.provideBaseChunk(primer, x, z);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        return this.chunkSource.provideChunk(chunkX, chunkZ);
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        this.chunkSource.populateChunk(chunkX, chunkZ);
    }

    public void func_185977_a(int chunkX, int chunkZ, ChunkPrimer chunkPrimer, Biome[] biomes) {
        this.chunkSource.provideSurface(biomes, chunkPrimer, chunkX, chunkZ);
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        return this.chunkSource.generateStructures(chunk, chunkX, chunkZ);
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.chunkSource.getPossibleCreatures(creatureType, pos);
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return this.chunkSource.getNearestStructurePos(world, structureName, position, findUnexplored);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        this.chunkSource.recreateStructures(chunk, x, z);
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        return this.chunkSource.isInsideStructure(world, structureName, pos);
    }

    public ChunkSource getChunkSource() {
        return this.chunkSource;
    }
}

