/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.carver;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenBetaCave
extends MapGenBase {
    public void func_186125_a(World world, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer) {
        this.field_75039_c = world;
        this.field_75038_b.setSeed(world.func_72905_C());
        long randomLong0 = this.field_75038_b.nextLong() / 2L * 2L + 1L;
        long randomLong1 = this.field_75038_b.nextLong() / 2L * 2L + 1L;
        for (int chunkX = originChunkX - this.field_75040_a; chunkX <= originChunkX + this.field_75040_a; ++chunkX) {
            for (int chunkZ = originChunkZ - this.field_75040_a; chunkZ <= originChunkZ + this.field_75040_a; ++chunkZ) {
                this.field_75038_b.setSeed((long)chunkX * randomLong0 + (long)chunkZ * randomLong1 ^ world.func_72905_C());
                this.func_180701_a(world, chunkX, chunkZ, originChunkX, originChunkZ, chunkPrimer);
            }
        }
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int originChunkX, int originChunkZ, ChunkPrimer chunkPrimer) {
        int caveCount = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(40) + 1) + 1);
        if (this.field_75038_b.nextInt(this.getMaxCaveCount()) != 0) {
            caveCount = 0;
        }
        for (int i = 0; i < caveCount; ++i) {
            double x = chunkX * 16 + this.field_75038_b.nextInt(16);
            double y = this.getCaveY(this.field_75038_b);
            double z = chunkZ * 16 + this.field_75038_b.nextInt(16);
            int tunnelCount = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.carveCave(chunkPrimer, originChunkX, originChunkZ, x, y, z);
                tunnelCount += this.field_75038_b.nextInt(4);
            }
            for (int j = 0; j < tunnelCount; ++j) {
                float f = this.field_75038_b.nextFloat() * 3.141593f * 2.0f;
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float tunnelSysWidth = this.getTunnelSystemWidth(this.field_75038_b);
                this.carveTunnels(chunkPrimer, originChunkX, originChunkZ, x, y, z, tunnelSysWidth, f, f1, 0, 0, 1.0);
            }
        }
    }

    private void carveCave(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, double x, double y, double z) {
        this.carveTunnels(chunkPrimer, chunkX, chunkZ, x, y, z, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    private void carveTunnels(ChunkPrimer chunkPrimer, int chunkX, int chunkZ, double x, double y, double z, float tunnelSysWidth, float f1, float f2, int branch, int branchCount, double tunnelWHRatio) {
        boolean vary;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random newRandom = new Random(this.field_75038_b.nextLong());
        if (branchCount <= 0) {
            int someNumMaxStarts = 112;
            branchCount = someNumMaxStarts - newRandom.nextInt(someNumMaxStarts / 4);
        }
        boolean noStarts = false;
        if (branch == -1) {
            branch = branchCount / 2;
            noStarts = true;
        }
        int randBranch = newRandom.nextInt(branchCount / 2) + branchCount / 4;
        boolean bl = vary = newRandom.nextInt(6) == 0;
        while (branch < branchCount) {
            double yaw = 1.5 + (double)(MathHelper.func_76126_a((float)((float)branch * 3.141593f / (float)branchCount)) * tunnelSysWidth * 1.0f);
            double pitch = yaw * tunnelWHRatio;
            float f5 = MathHelper.func_76134_b((float)f2);
            float f6 = MathHelper.func_76126_a((float)f2);
            x += (double)(MathHelper.func_76134_b((float)f1) * f5);
            y += (double)f6;
            z += (double)(MathHelper.func_76126_a((float)f1) * f5);
            f2 *= vary ? 0.92f : 0.7f;
            f2 += f4 * 0.1f;
            f1 += f3 * 0.1f;
            f4 *= 0.9f;
            f3 *= 0.75f;
            f4 += (newRandom.nextFloat() - newRandom.nextFloat()) * newRandom.nextFloat() * 2.0f;
            f3 += (newRandom.nextFloat() - newRandom.nextFloat()) * newRandom.nextFloat() * 4.0f;
            if (!noStarts && branch == randBranch && tunnelSysWidth > 1.0f) {
                this.carveTunnels(chunkPrimer, chunkX, chunkZ, x, y, z, newRandom.nextFloat() * 0.5f + 0.5f, f1 - 1.570796f, f2 / 3.0f, branch, branchCount, 1.0);
                this.carveTunnels(chunkPrimer, chunkX, chunkZ, x, y, z, newRandom.nextFloat() * 0.5f + 0.5f, f1 + 1.570796f, f2 / 3.0f, branch, branchCount, 1.0);
                return;
            }
            if (noStarts || newRandom.nextInt(4) != 0) {
                if (!this.canCarveBranch(chunkX, chunkZ, x, z, branch, branchCount, tunnelSysWidth)) {
                    return;
                }
                this.carveRegion(chunkPrimer, 0L, 64, chunkX, chunkZ, x, y, z, yaw, pitch);
                if (noStarts) break;
            }
            ++branch;
        }
    }

    protected boolean carveRegion(ChunkPrimer chunkPrimer, long seed, int seaLevel, int chunkX, int chunkZ, double x, double y, double z, double yaw, double pitch) {
        double ctrX = chunkX * 16 + 8;
        double ctrZ = chunkZ * 16 + 8;
        if (x < ctrX - 16.0 - yaw * 2.0 || z < ctrZ - 16.0 - yaw * 2.0 || x > ctrX + 16.0 + yaw * 2.0 || z > ctrZ + 16.0 + yaw * 2.0) {
            return false;
        }
        int minX = MathHelper.func_76128_c((double)(x - yaw)) - chunkX * 16 - 1;
        int maxX = MathHelper.func_76128_c((double)(x + yaw)) - chunkX * 16 + 1;
        int minY = MathHelper.func_76128_c((double)(y - pitch)) - 1;
        int maxY = MathHelper.func_76128_c((double)(y + pitch)) + 1;
        int minZ = MathHelper.func_76128_c((double)(z - yaw)) - chunkZ * 16 - 1;
        int maxZ = MathHelper.func_76128_c((double)(z + yaw)) - chunkZ * 16 + 1;
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > 16) {
            maxX = 16;
        }
        if (minY < 1) {
            minY = 1;
        }
        if (maxY > 120) {
            maxY = 120;
        }
        if (minZ < 0) {
            minZ = 0;
        }
        if (maxZ > 16) {
            maxZ = 16;
        }
        if (this.isRegionUncarvable(chunkPrimer, chunkX, chunkZ, minX, maxX, minY, maxY, minZ, maxZ)) {
            return false;
        }
        for (int relX = minX; relX < maxX; ++relX) {
            double scaledRelX = ((double)(relX + chunkX * 16) + 0.5 - x) / yaw;
            for (int relZ = minZ; relZ < maxZ; ++relZ) {
                double scaledRelZ = ((double)(relZ + chunkZ * 16) + 0.5 - z) / yaw;
                boolean isGrassBlock = false;
                for (int relY = maxY; relY >= minY; --relY) {
                    double scaledRelY = ((double)relY - 1.0 + 0.5 - y) / pitch;
                    if (!this.isPositionExcluded(scaledRelX, scaledRelY, scaledRelZ)) continue;
                    Block block = chunkPrimer.func_177856_a(relX, relY, relZ).func_177230_c();
                    if (block == Blocks.field_150349_c) {
                        isGrassBlock = true;
                    }
                    if (block != Blocks.field_150348_b && block != Blocks.field_150346_d && block != Blocks.field_150349_c) continue;
                    if (relY - 1 < 10) {
                        chunkPrimer.func_177855_a(relX, relY, relZ, Blocks.field_150353_l.func_176223_P());
                        continue;
                    }
                    chunkPrimer.func_177855_a(relX, relY, relZ, Blocks.field_150350_a.func_176223_P());
                    if (!isGrassBlock || chunkPrimer.func_177856_a(relX, relY - 1, relZ).func_177230_c() != Blocks.field_150346_d) continue;
                    chunkPrimer.func_177855_a(relX, relY - 1, relZ, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
        return true;
    }

    private boolean canCarveBranch(int mainChunkX, int mainChunkZ, double x, double z, int branch, int branchCount, float baseWidth) {
        double ctrX = mainChunkX * 16 + 8;
        double d1 = x - ctrX;
        double ctrZ = mainChunkZ * 16 + 8;
        double d2 = z - ctrZ;
        double d3 = branchCount - branch;
        double d4 = baseWidth + 2.0f + 16.0f;
        return !(d1 * d1 + d2 * d2 - d3 * d3 > d4 * d4);
    }

    private boolean isRegionUncarvable(ChunkPrimer chunkPrimer, int mainChunkX, int mainChunkZ, int relMinX, int relMaxX, int minY, int maxY, int relMinZ, int relMaxZ) {
        for (int relX = relMinX; relX < relMaxX; ++relX) {
            for (int relZ = relMinZ; relZ < relMaxZ; ++relZ) {
                for (int relY = maxY + 1; relY >= minY - 1; --relY) {
                    if (relY < 0 || relY >= 128) continue;
                    Block block = chunkPrimer.func_177856_a(relX, relY, relZ).func_177230_c();
                    if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150358_i)) {
                        return true;
                    }
                    if (relY == minY - 1 || !this.isOnBoundary(relMinX, relMaxX, relMinZ, relMaxZ, relX, relZ)) continue;
                    relY = minY;
                }
            }
        }
        return false;
    }

    private boolean isPositionExcluded(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ) {
        return scaledRelativeY > -0.7 && scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ < 1.0;
    }

    private boolean isOnBoundary(int minX, int maxX, int minZ, int maxZ, int relX, int relZ) {
        return relX != minX && relX != maxX - 1 && relZ != minZ && relZ != maxZ - 1;
    }

    private int getMaxCaveCount() {
        return 15;
    }

    private int getCaveY(Random random) {
        return random.nextInt(random.nextInt(120) + 8);
    }

    private float getTunnelSystemWidth(Random random) {
        float width = random.nextFloat() * 2.0f + random.nextFloat();
        return width;
    }
}

